/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.semantictools.context.renderer.model.BaseDocumentMetadata;
import org.semantictools.context.renderer.model.DocumentMetadata;
import org.semantictools.context.renderer.model.FrameConstraints;
import org.semantictools.context.renderer.model.SampleJson;
import org.semantictools.frame.api.TypeManager;

public class ContextProperties
extends BaseDocumentMetadata
implements Comparable<ContextProperties> {
    private File sourceFile;
    private File contextFile;
    private String rdfTypeURI;
    private String rdfTypeRef;
    private String rdfProperty;
    private String contextURI;
    private String contextRef;
    private String mediaType;
    private String mediaTypeURI;
    private String mediaTypeRef;
    private String sampleText;
    private String purlDomain;
    private File mediaTypeDocFile;
    private List<String> idRefList = new ArrayList<String>();
    private List<String> optional = new ArrayList<String>();
    private Set<String> mixedSet = new HashSet<String>();
    private Set<String> requiresId = new HashSet<String>();
    private List<String> graphTypes = new ArrayList<String>();
    private Set<String> setProperty = new HashSet<String>();
    private String abstactText;
    private String introduction;
    private Set<String> excludedTypes = new HashSet<String>();
    private Set<String> expandedValues = new HashSet<String>();
    private List<SampleJson> sampleJsonList = new ArrayList<SampleJson>();
    private Map<String, FrameConstraints> uri2FrameConstraints = new HashMap<String, FrameConstraints>();
    private Properties rawProperties;
    private Set<String> usePrefix = new HashSet<String>();
    private boolean howToReadThisDocument = true;
    private boolean reservedTermsSection = true;
    private boolean jsonldIntroduction = true;
    private boolean mediaTypeSection = true;
    private boolean overviewDiagram = true;

    public ContextProperties(DocumentMetadata parent, Properties rawProperties) {
        super(parent);
        this.rawProperties = rawProperties;
    }

    public void addSetProperty(String propertyURI) {
        this.setProperty.add(propertyURI);
    }

    public void addUsePrefix(String propertyURI) {
        this.usePrefix.add(propertyURI);
    }

    public void addOptional(String propertyURI) {
        this.optional.add(propertyURI);
    }

    public List<String> getOptionalProperties() {
        return this.optional;
    }

    public boolean usePrefix(String propertyURI) {
        return this.usePrefix.contains(propertyURI);
    }

    public boolean isSetProperty(String propertyURI) {
        return this.setProperty.contains(propertyURI);
    }

    public Set<String> getRequiresId() {
        return this.requiresId;
    }

    public boolean requiresId(String rdfTypeURI) {
        return this.requiresId.contains(rdfTypeURI);
    }

    public void addGraphType(String rdfTypeURI) {
        this.graphTypes.add(rdfTypeURI);
    }

    public List<String> getGraphTypes() {
        return this.graphTypes;
    }

    public String getRdfProperty() {
        return this.rdfProperty;
    }

    public void setRdfProperty(String rdfPropertyName) {
        this.rdfProperty = rdfPropertyName;
    }

    public File getMediaTypeDocFile() {
        return this.mediaTypeDocFile;
    }

    public Set<String> getExcludedTypes() {
        return this.excludedTypes;
    }

    public void setMediaTypeDocFile(File mediaTypeDocFile) {
        this.mediaTypeDocFile = mediaTypeDocFile;
    }

    public String getMediaTypeRef() {
        if (this.mediaTypeRef == null) {
            return "[" + TypeManager.getLocalName(this.rdfTypeURI) + "-media-type]";
        }
        return this.mediaTypeRef;
    }

    public void setMediaTypeRef(String mediaTypeRef) {
        this.mediaTypeRef = mediaTypeRef;
    }

    public String getProperty(String name) {
        return this.rawProperties.getProperty(name);
    }

    public Set<String> getExpandedValues() {
        return this.expandedValues;
    }

    public List<SampleJson> getSampleJsonList() {
        return this.sampleJsonList;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public FrameConstraints getFrameConstraints(String uri) {
        return this.uri2FrameConstraints.get(uri);
    }

    public FrameConstraints fetchFrameConstraints(String uri) {
        FrameConstraints result = this.uri2FrameConstraints.get(uri);
        if (result == null) {
            result = new FrameConstraints(uri);
            this.uri2FrameConstraints.put(uri, result);
        }
        return result;
    }

    public void addFrameConstraints(FrameConstraints value) {
        this.uri2FrameConstraints.put(value.getClassURI(), value);
    }

    public List<FrameConstraints> listFrameConstraints() {
        return new ArrayList<FrameConstraints>(this.uri2FrameConstraints.values());
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public String getAbstactText() {
        return this.abstactText;
    }

    public void setAbstactText(String abstactText) {
        this.abstactText = abstactText;
    }

    public String getRdfTypeURI() {
        return this.rdfTypeURI;
    }

    public void setRdfTypeURI(String rdfTypeURI) {
        this.rdfTypeURI = rdfTypeURI;
    }

    public String getContextURI() {
        return this.contextURI;
    }

    public void setContextURI(String contextURI) {
        this.contextURI = contextURI;
    }

    public String getContextRef() {
        return this.contextRef;
    }

    public void setContextRef(String contextRef) {
        this.contextRef = contextRef;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void addIdRef(String propertyURI) {
        this.idRefList.add(propertyURI);
    }

    public List<String> getIdRefList() {
        return this.idRefList;
    }

    public boolean isIdRef(String propertyURI) {
        return this.idRefList.contains(propertyURI);
    }

    public void addMixed(String propertyURI) {
        this.mixedSet.add(propertyURI);
    }

    public boolean isMixed(String propertyURI) {
        return this.mixedSet.contains(propertyURI);
    }

    public String getRdfTypeRef() {
        return this.rdfTypeRef;
    }

    public void setRdfTypeRef(String rdfTypeRef) {
        this.rdfTypeRef = rdfTypeRef;
    }

    public String getMediaTypeURI() {
        return this.mediaTypeURI;
    }

    public void setMediaTypeURI(String mediaTypeURI) {
        this.mediaTypeURI = mediaTypeURI;
    }

    public String getPurlDomain() {
        return this.purlDomain;
    }

    public void setPurlDomain(String purlDomain) {
        this.purlDomain = purlDomain;
    }

    @Override
    public int compareTo(ContextProperties other) {
        return this.mediaType.compareTo(other.mediaType);
    }

    public String getSampleText() {
        return this.sampleText;
    }

    public void setSampleText(String sampleText) {
        this.sampleText = sampleText;
    }

    public File getContextFile() {
        return this.contextFile;
    }

    public void setContextFile(File contextFile) {
        this.contextFile = contextFile;
    }

    public boolean isHowToReadThisDocument() {
        return this.howToReadThisDocument;
    }

    public void setHowToReadThisDocument(boolean howToReadThisDocument) {
        this.howToReadThisDocument = howToReadThisDocument;
    }

    public boolean isReservedTermsSection() {
        return this.reservedTermsSection;
    }

    public void setReservedTermsSection(boolean reservedTermsSection) {
        this.reservedTermsSection = reservedTermsSection;
    }

    public boolean isJsonldIntroduction() {
        return this.jsonldIntroduction;
    }

    public void setJsonldIntroduction(boolean jsonldIntroduction) {
        this.jsonldIntroduction = jsonldIntroduction;
    }

    public boolean isMediaTypeSection() {
        return this.mediaTypeSection;
    }

    public void setMediaTypeSection(boolean mediaTypeSection) {
        this.mediaTypeSection = mediaTypeSection;
    }

    public boolean isOverviewDiagram() {
        return this.overviewDiagram;
    }

    public void setOverviewDiagram(boolean overviewDiagram) {
        this.overviewDiagram = overviewDiagram;
    }
}

