/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.semantictools.context.renderer.model.BibliographicReference;
import org.semantictools.context.renderer.model.ReferenceManager;

public class DefaultReferenceManager
implements ReferenceManager {
    private Map<String, BibliographicReference> map = new HashMap<String, BibliographicReference>();

    @Override
    public void add(BibliographicReference ref) {
        String key = this.toKey(ref.getLabel());
        this.map.put(key, ref);
    }

    @Override
    public BibliographicReference getReference(String key) {
        BibliographicReference result = this.map.get(key);
        if (result == null) {
            key = this.toKey(key);
            result = this.map.get(key);
        }
        return result;
    }

    private String toKey(String tag) {
        tag = tag.replace("&nbsp;", "_");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                builder.append(c);
                continue;
            }
            builder.append('_');
        }
        return builder.toString();
    }

    @Override
    public List<BibliographicReference> listReferences() {
        return new ArrayList<BibliographicReference>(new HashSet<BibliographicReference>(this.map.values()));
    }

    @Override
    public void put(String key, BibliographicReference ref) {
        this.map.put(key, ref);
    }
}

