/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.util.HashSet;
import java.util.Set;

public class FrameConstraints {
    private String classURI;
    private Set<String> includedProperties = new HashSet<String>();
    private Set<String> excludedProperties = new HashSet<String>();
    private Set<String> excludeSubtypes = new HashSet<String>();

    public FrameConstraints(String classURI) {
        this.classURI = classURI;
    }

    public void copyAll(FrameConstraints copy) {
        this.includedProperties.addAll(copy.includedProperties);
        this.excludedProperties.addAll(copy.excludedProperties);
    }

    public String getClassURI() {
        return this.classURI;
    }

    public void setClassURI(String classURI) {
        this.classURI = classURI;
    }

    public void addIncludedProperty(String propertyURI) {
        this.includedProperties.add(propertyURI);
    }

    public void addExcludedProperty(String propertyURI) {
        this.excludedProperties.add(propertyURI);
    }

    public void addExcludesSubtype(String propertyURI) {
        this.excludeSubtypes.add(propertyURI);
    }

    public boolean isExcludesSubtypes(String propertyURI) {
        return this.excludeSubtypes.contains(propertyURI);
    }

    public boolean isIncludedProperty(String propertyURI) {
        return !this.excludedProperties.contains(propertyURI) && (this.includedProperties.isEmpty() || this.includedProperties.contains(propertyURI));
    }
}

