/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semantictools.context.renderer.model.TermInfo;

public class JsonContext {
    private String contextURI;
    private String mediaType;
    private String rootType;
    private Map<String, TermInfo> termName2TermInfo = new HashMap<String, TermInfo>();
    private Map<String, String> rewriteMap = new HashMap<String, String>();

    public String getRootType() {
        return this.rootType;
    }

    public void setRootType(String rootType) {
        this.rootType = rootType;
    }

    public TermInfo getTermInfoByShortName(String shortName) {
        return this.termName2TermInfo.get(shortName);
    }

    public TermInfo getTermInfoByURI(String uri) {
        if (uri == null) {
            return null;
        }
        String shortName = this.rewrite(uri);
        return this.getTermInfoByShortName(shortName);
    }

    public String getContextURI() {
        return this.contextURI;
    }

    public void setContextURI(String contextURI) {
        this.contextURI = contextURI;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public TermInfo add(String term, String iri) {
        TermInfo info = new TermInfo(term);
        info.setIriValue(iri);
        this.add(info);
        return info;
    }

    public void add(TermInfo rule) {
        this.termName2TermInfo.put(rule.getTermName(), rule);
        this.addRewriteRule(rule);
    }

    private void addRewriteRule(TermInfo rule) {
        String key = rule.getTermName();
        String value = rule.hasIriValue() ? rule.getIri() : rule.getObjectValue().getId();
        this.rewriteMap.put(key, value);
    }

    public boolean containsTerm(String term) {
        return this.termName2TermInfo.get(term) != null;
    }

    public List<TermInfo> getTerms() {
        return new ArrayList<TermInfo>(this.termName2TermInfo.values());
    }

    public String toAbsoluteIRI(String token) {
        if (token.indexOf(47) > 0) {
            return token;
        }
        return this.rewrite(token);
    }

    public String rewrite(String fieldName) {
        String prefix;
        String namespace;
        int colon = fieldName.indexOf(58);
        if (colon >= 0 && (namespace = this.rewriteMap.get(prefix = fieldName.substring(0, colon))) != null) {
            String localName = fieldName.substring(colon + 1);
            return namespace + localName;
        }
        String replacement = this.rewriteMap.get(fieldName);
        if (replacement != null) {
            return replacement;
        }
        return fieldName;
    }

    public void expand() {
        this.expand(this.rewriteMap);
    }

    private void expand(Map<String, String> map) {
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        for (Map.Entry entry : entryList) {
            String uri;
            String prefix;
            String value = (String)entry.getValue();
            int colon = value.indexOf(58);
            if (colon < 0 || (prefix = value.substring(0, colon)).equals(uri = this.rewrite(prefix))) continue;
            String suffix = value.substring(colon + 1);
            String replacement = uri + suffix;
            String key = (String)entry.getKey();
            map.put(key, replacement);
        }
    }

    public void invertRewriteRules() {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(this.rewriteMap.entrySet());
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.rewriteMap.put(value, key);
        }
    }
}

