/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.util.ArrayList;
import java.util.List;
import org.semantictools.context.renderer.model.BranchStyle;
import org.semantictools.context.renderer.model.Modifier;
import org.semantictools.context.renderer.model.Rect;

public class Node {
    private String nameText;
    private String typeText;
    private String nameQualifier;
    private Rect outline = new Rect();
    private Rect nameRect = new Rect();
    private Rect typeRect = new Rect();
    private Rect boundary = this.outline;
    private Modifier modifier = Modifier.NONE;
    private BranchStyle branchStyle = BranchStyle.RECTILINEAR;
    private List<Node> children;
    private Node parent;
    private int row;
    private int column;

    public Node() {
    }

    public Node(String nameText, String typeText) {
        this.nameText = nameText;
        this.typeText = typeText;
    }

    public Node(String nameText, String typeText, Modifier modifier) {
        this(nameText, typeText);
        this.setModifier(modifier);
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public void setNameQualifier(String nameQualifier) {
        this.nameQualifier = nameQualifier;
    }

    public boolean isIriRef() {
        return this.nameText.startsWith("#uri");
    }

    public void applyIriRef() {
        this.nameText = "#uri  " + this.nameText;
        this.nameQualifier = "#uri";
    }

    public void applyNameRef() {
        this.nameText = "#sn  " + this.nameText;
        this.nameQualifier = "#sn";
    }

    public void applyMixedValue() {
        this.nameText = "#mixed  " + this.nameText;
        this.nameQualifier = "#mixed";
    }

    public void applyExpandedValue() {
        this.nameText = "#ev  " + this.nameText;
        this.nameQualifier = "#ev";
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
        if (modifier == Modifier.NONE) {
            this.boundary = this.outline;
        } else if (this.boundary == this.outline) {
            this.boundary = new Rect();
        }
    }

    public void setGridCoordinates(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setLeft(int left, int modifierWidth) {
        this.boundary.setX(left);
        if (this.modifier != Modifier.NONE) {
            this.outline.setX(left += modifierWidth);
        }
        this.nameRect.setX(left);
        this.typeRect.setX(left);
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Rect getBoundary() {
        return this.boundary;
    }

    public BranchStyle getBranchStyle() {
        return this.branchStyle;
    }

    public void setBranchStyle(BranchStyle branchStyle) {
        this.branchStyle = branchStyle;
    }

    public void alignWidth(int modifierWidth) {
        int width = Math.max(this.nameRect.getWidth(), this.typeRect.getWidth());
        this.outline.setWidth(width);
        this.nameRect.setWidth(width);
        this.typeRect.setWidth(width);
        if (this.boundary != this.outline) {
            this.boundary.setWidth(width + modifierWidth);
        }
    }

    public void add(Node node) {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(node);
        node.setParent(this);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public String getNameText() {
        return this.nameText;
    }

    public void setNameText(String nameText) {
        this.nameText = nameText;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public void setTypeText(String typeText) {
        this.typeText = typeText;
    }

    public void align() {
        int height = this.nameRect.getHeight() + this.typeRect.getHeight();
        int width = Math.max(this.nameRect.getWidth(), this.typeRect.getWidth());
        this.nameRect.setWidth(width);
        this.typeRect.setWidth(width);
        this.typeRect.setPosition(this.nameRect.getX(), this.nameRect.getY() + this.nameRect.getHeight());
        this.outline.setPosition(this.nameRect.getX(), this.nameRect.getY());
        this.outline.setHeight(height);
        this.outline.setWidth(width);
    }

    public Rect getOutline() {
        return this.outline;
    }

    public Rect getNameRect() {
        return this.nameRect;
    }

    public Rect getTypeRect() {
        return this.typeRect;
    }

    public void setTop(int top) {
        this.boundary.setY(top);
        this.outline.setY(top);
        this.nameRect.setY(top);
        int typeTop = top + this.nameRect.getHeight();
        this.typeRect.setY(typeTop);
    }

    public void computeHeight() {
        int height = this.nameRect.getHeight() + this.typeRect.getHeight();
        this.outline.setHeight(height);
        if (this.boundary != this.outline) {
            this.boundary.setHeight(height);
        }
    }

    public int getRight() {
        return this.boundary.getX() + this.boundary.getWidth();
    }

    public int getBottom() {
        return this.boundary.getY() + this.boundary.getHeight();
    }

    public int getTop() {
        return this.boundary.getY();
    }

    public int getHeight() {
        return this.boundary.getHeight();
    }

    public Node getFirstChild() {
        return this.children == null || this.children.isEmpty() ? null : this.children.get(0);
    }

    public Node getLastChild() {
        return this.children == null || this.children.isEmpty() ? null : this.children.get(this.children.size() - 1);
    }

    public int getLeft() {
        return this.boundary.getX();
    }

    public int getWidth() {
        return this.boundary.getWidth();
    }

    public String toString() {
        return this.nameText + ":" + this.typeText;
    }
}

