/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semantictools.context.renderer.model.BaseDocumentMetadata;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.DocumentMetadata;
import org.semantictools.context.renderer.model.HttpMethod;
import org.semantictools.context.renderer.model.MethodDocumentation;
import org.semantictools.context.renderer.model.QueryParam;

public class ServiceDocumentation
extends BaseDocumentMetadata {
    private List<ContextProperties> contextPropertiesList = new ArrayList<ContextProperties>();
    private File serviceDocumentationFile;
    private String rdfTypeURI;
    private String postResponseMediaType;
    private String postResponseMediaTypeRef;
    private String abstactText;
    private String introduction;
    private String representationHeading;
    private String representationText;
    private String urlTemplateText;
    private boolean allowArbitraryFormat;
    private boolean allowHtmlFormat;
    private String htmlFormatDocumentation;
    private String defaultMediaType;
    private String postProcessingRules;
    private boolean contentNegotiation;
    private String getInstructions;
    private String putInstructions;
    private MethodDocumentation postDocumentation;
    private MethodDocumentation getDocumentation;
    private MethodDocumentation putDocumentation;
    private MethodDocumentation deleteDocumentation;
    private List<HttpMethod> methodList = new ArrayList<HttpMethod>();
    private List<QueryParam> queryParams = new ArrayList<QueryParam>();
    private List<String> putRules = new ArrayList<String>();
    private Map<String, String> referenceMap = new HashMap<String, String>();
    private Map<String, String> mediaTypeUriMap = new HashMap<String, String>();

    public ServiceDocumentation(DocumentMetadata global) {
        super(global);
    }

    public File getServiceDocumentationFile() {
        return this.serviceDocumentationFile;
    }

    public void setServiceDocumentationFile(File serviceDocumentationFile) {
        this.serviceDocumentationFile = serviceDocumentationFile;
        this.setLocalFile(serviceDocumentationFile);
    }

    public boolean isContentNegotiation() {
        return this.contentNegotiation;
    }

    public void setContentNegotiation(boolean contentNegotiation) {
        this.contentNegotiation = contentNegotiation;
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    public String getPostProcessingRules() {
        return this.postProcessingRules;
    }

    public void setPostProcessingRules(String postProcessingRules) {
        this.postProcessingRules = postProcessingRules;
    }

    public String getRdfTypeURI() {
        if (this.rdfTypeURI == null && !this.contextPropertiesList.isEmpty()) {
            this.rdfTypeURI = this.contextPropertiesList.get(0).getRdfTypeURI();
        }
        return this.rdfTypeURI;
    }

    public void setRdfTypeURI(String rdfTypeURI) {
        this.rdfTypeURI = rdfTypeURI;
    }

    public Map<String, String> getMediaTypeUriMap() {
        return this.mediaTypeUriMap;
    }

    public boolean hasMultipleFormats() {
        int count = this.contextPropertiesList.size() + this.mediaTypeUriMap.size() + (this.allowHtmlFormat ? 1 : 0);
        return count > 1;
    }

    public boolean isAllowHtmlFormat() {
        return this.allowHtmlFormat;
    }

    public void setAllowHtmlFormat(boolean allowHtmlFormat) {
        this.allowHtmlFormat = allowHtmlFormat;
    }

    public String getHtmlFormatDocumentation() {
        return this.htmlFormatDocumentation;
    }

    public void setHtmlFormatDocumentation(String text) {
        this.htmlFormatDocumentation = text;
    }

    public boolean isAllowArbitraryFormat() {
        return this.allowArbitraryFormat;
    }

    public String getUrlTemplateText() {
        return this.urlTemplateText;
    }

    public void setUrlTemplateText(String urlTemplateText) {
        this.urlTemplateText = urlTemplateText;
    }

    public void setAllowArbitraryFormat(boolean allowArbitraryFormat) {
        this.allowArbitraryFormat = allowArbitraryFormat;
    }

    public String getAbstactText() {
        return this.abstactText;
    }

    public void setAbstactText(String abstactText) {
        this.abstactText = abstactText;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public void add(ContextProperties context) {
        this.contextPropertiesList.add(context);
    }

    public List<ContextProperties> listContextProperties() {
        return this.contextPropertiesList;
    }

    public String getRepresentationHeading() {
        return this.representationHeading;
    }

    public void setRepresentationHeading(String representationHeading) {
        this.representationHeading = representationHeading;
    }

    public String getRepresentationText() {
        return this.representationText;
    }

    public void setRepresentationText(String representationText) {
        this.representationText = representationText;
    }

    public MethodDocumentation getPostDocumentation() {
        return this.postDocumentation;
    }

    public void setPostDocumentation(MethodDocumentation postDocumentation) {
        this.postDocumentation = postDocumentation;
    }

    public MethodDocumentation getGetDocumentation() {
        return this.getDocumentation;
    }

    public void setGetDocumentation(MethodDocumentation getDocumentation) {
        this.getDocumentation = getDocumentation;
    }

    public String getPostResponseMediaType() {
        return this.postResponseMediaType;
    }

    public void setPostResponseMediaType(String postResponseType) {
        this.postResponseMediaType = postResponseType;
    }

    public String getPostResponseMediaTypeRef() {
        return this.postResponseMediaTypeRef;
    }

    public void setPostResponseTypeRef(String postResponseTypeRef) {
        this.postResponseMediaTypeRef = postResponseTypeRef;
    }

    public MethodDocumentation getPutDocumentation() {
        return this.putDocumentation;
    }

    public void setPutDocumentation(MethodDocumentation putDocumentation) {
        this.putDocumentation = putDocumentation;
    }

    public MethodDocumentation getDeleteDocumentation() {
        return this.deleteDocumentation;
    }

    public void setDeleteDocumentation(MethodDocumentation deleteDocumentation) {
        this.deleteDocumentation = deleteDocumentation;
    }

    public List<HttpMethod> getMethodList() {
        return this.methodList;
    }

    public void add(HttpMethod method) {
        this.methodList.add(method);
    }

    public boolean contains(HttpMethod method) {
        return this.methodList.contains(method);
    }

    public HttpMethod getMethod(HttpMethod get) {
        for (HttpMethod method : this.methodList) {
            if (!"GET".equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public String getGetInstructions() {
        return this.getInstructions;
    }

    public void setGetInstructions(String getInstructions) {
        this.getInstructions = getInstructions;
    }

    public List<QueryParam> getQueryParams() {
        return this.queryParams;
    }

    public List<String> getPutRules() {
        return this.putRules;
    }

    public String getPutInstructions() {
        return this.putInstructions;
    }

    public void setPutInstructions(String putInstructions) {
        this.putInstructions = putInstructions;
    }
}

