/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.io.File;
import org.semantictools.frame.api.LinkManager;

public class ServiceFileManager {
    private File baseDir;
    private File cssFile;

    public ServiceFileManager(File baseDir, File cssFile) {
        this.baseDir = baseDir;
        this.cssFile = cssFile;
    }

    private String stripProtocol(String uri) {
        int slash = uri.indexOf(47) + 2;
        String path = uri.substring(slash);
        return path;
    }

    public String getRelativeCssPath(File htmlFile) {
        LinkManager linkManager = new LinkManager(htmlFile);
        return linkManager.relativize(this.cssFile);
    }

    public String getServiceDocumentationPath(String rdfTypeURI) {
        return this.stripProtocol(rdfTypeURI).replace('#', '/') + "/service.html";
    }

    public File getServiceDocumentationFile(String rdfTypeURI) {
        String path = this.getServiceDocumentationPath(rdfTypeURI);
        return new File(this.baseDir, path);
    }
}

