/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import org.semantictools.context.renderer.model.TermValue;

public class TermInfo
implements Comparable<TermInfo> {
    private TermCategory category = TermCategory.UNKNOWN;
    private String termName;
    private String iri;
    private TermValue value;

    public TermInfo(String termName) {
        this.termName = termName;
        if (termName == null) {
            throw new RuntimeException("termName must be non-null");
        }
    }

    public TermCategory getCategory() {
        return this.category;
    }

    public void setCategory(TermCategory category) {
        this.category = category;
    }

    public String getTermName() {
        return this.termName;
    }

    public void setTermName(String term) {
        this.termName = term;
    }

    public boolean hasIriValue() {
        return this.iri != null;
    }

    public boolean isCoercedAsIriRef() {
        return this.value != null && "@id".equals(this.value.getType());
    }

    public boolean hasObjectValue() {
        return this.value != null;
    }

    public String getIri() {
        return this.value == null ? this.iri : this.value.getType();
    }

    public void setIriValue(String iri) {
        this.iri = iri;
    }

    public TermValue getObjectValue() {
        return this.value;
    }

    public void setObjectValue(TermValue target) {
        this.value = target;
    }

    @Override
    public int compareTo(TermInfo other) {
        int diff = this.category.ordinal() - other.category.ordinal();
        if (diff == 0) {
            diff = this.termName.compareTo(other.termName);
        }
        return diff;
    }

    public String toString() {
        return this.getTermName();
    }

    public static enum TermCategory {
        NAMESPACE,
        TYPE,
        PROPERTY,
        UNKNOWN;

    }
}

