/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.view;

import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.node.ObjectNode;
import org.semantictools.context.renderer.DiagramGenerator;
import org.semantictools.context.renderer.MediaTypeFileManager;
import org.semantictools.context.renderer.NodeComparatorFactory;
import org.semantictools.context.renderer.NodeUtil;
import org.semantictools.context.renderer.StreamFactory;
import org.semantictools.context.renderer.TermNotFoundException;
import org.semantictools.context.renderer.TreeGenerator;
import org.semantictools.context.renderer.impl.NodeComparatorFactoryImpl;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.CreateDiagramRequest;
import org.semantictools.context.renderer.model.GlobalProperties;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.context.renderer.model.ObjectPresentation;
import org.semantictools.context.renderer.model.SampleJson;
import org.semantictools.context.renderer.model.TermInfo;
import org.semantictools.context.renderer.model.TreeNode;
import org.semantictools.context.view.Caption;
import org.semantictools.context.view.CaptionType;
import org.semantictools.context.view.ClassificationPrinter;
import org.semantictools.context.view.DefaultDocumentPrinter;
import org.semantictools.context.view.DocumentPrinter;
import org.semantictools.context.view.Heading;
import org.semantictools.context.view.IMSDocumentPrinter;
import org.semantictools.context.view.Level;
import org.semantictools.context.view.PrintContext;
import org.semantictools.context.view.PrintEngine;
import org.semantictools.frame.api.FrameNotFoundException;
import org.semantictools.frame.api.GeneratorProperties;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.NamedIndividual;
import org.semantictools.frame.model.RdfType;
import org.semantictools.frame.model.RestCategory;
import org.semantictools.json.JsonManager;
import org.semantictools.json.JsonPrettyPrinter;
import org.semantictools.json.JsonSampleGenerator;
import org.semantictools.uml.api.UmlFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHtmlPrinter
extends PrintEngine {
    private static Logger logger = LoggerFactory.getLogger(ContextHtmlPrinter.class);
    private static final String TOC_MARKER = "<!-- TOC -->";
    private static final String VOWEL = "aeiou";
    private TypeManager typeManager;
    private MediaTypeFileManager namer;
    private boolean includeOverviewDiagram;
    private boolean includeClassDiagrams;
    private Caption overviewDiagram;
    private StreamFactory streamFactory;
    private List<Frame> frameList;
    private List<Datatype> datatypeList;
    private JsonContext context;
    private ContextProperties contextProperties;
    private DiagramGenerator diagramGenerator;
    private TreeGenerator treeGenerator;
    private JsonSampleGenerator sampleGenerator;
    private JsonManager jsonManager;
    private GeneratorProperties generatorProperties;
    private NodeComparatorFactory nodeComparatorFactory;
    private UmlFileManager umlFileManager;
    private Frame root;
    private List<Frame> graphTypes;
    private int figureNumber;
    private int tableNumber;
    private boolean defaultTemplate;
    private CaptionManager captionManager;
    private GlobalProperties global;
    private DocumentPrinter documentPrinter;

    public ContextHtmlPrinter(GlobalProperties global, GeneratorProperties properties, TypeManager typeManager, MediaTypeFileManager namer, StreamFactory streamFactory, DiagramGenerator generator, UmlFileManager umlFileManager) {
        super(new PrintContext());
        this.global = global;
        this.generatorProperties = properties;
        this.diagramGenerator = generator;
        this.umlFileManager = umlFileManager;
        this.streamFactory = streamFactory;
        this.typeManager = typeManager;
        this.namer = namer;
    }

    public List<Frame> getGraphTypes() {
        List<String> uriList;
        if (this.graphTypes == null && (uriList = this.contextProperties.getGraphTypes()) != null && !uriList.isEmpty()) {
            this.graphTypes = new ArrayList<Frame>();
            for (String uri : uriList) {
                Frame frame = this.typeManager.getFrameByUri(uri);
                if (frame == null) {
                    throw new FrameNotFoundException(uri);
                }
                this.graphTypes.add(frame);
            }
        }
        return this.graphTypes;
    }

    public Frame getRootFrame() {
        return this.root;
    }

    public void printHtml(JsonContext context) throws IOException {
        this.printHtml(context, null);
    }

    public void printHtml(JsonContext context, ContextProperties properties) throws IOException {
        this.contextProperties = properties;
        this.context = context;
        this.documentPrinter = this.createDocumentPrinter();
        this.defaultTemplate = this.isDefaultTemplate();
        this.treeGenerator = new TreeGenerator(this.typeManager, context, properties);
        this.sampleGenerator = new JsonSampleGenerator(this.typeManager);
        this.root = context == null ? null : this.typeManager.getFrameByUri(context.getRootType());
        this.overviewDiagram = this.overviewDiagramCaption();
        this.captionManager = new CaptionManager();
        this.jsonManager = new JsonManager(this.typeManager, context);
        this.nodeComparatorFactory = new NodeComparatorFactoryImpl(this.jsonManager);
        this.beginHTML();
        this.pushIndent();
        this.collectFrames();
        this.printTitlePage();
        this.printAbstract();
        this.printToc();
        this.printIntroduction();
        this.printMediaTypeConformance();
        this.printDataBindings();
        this.documentPrinter.printReferences();
        this.documentPrinter.printFooter();
        this.popIndent();
        this.endHTML();
        this.writeOutput();
    }

    private DocumentPrinter createDocumentPrinter() {
        DefaultDocumentPrinter printer = null;
        String template = this.contextProperties.getTemplateName();
        printer = "IMS".equalsIgnoreCase(template) ? new IMSDocumentPrinter(this.getPrintContext()) : new DefaultDocumentPrinter(this.getPrintContext());
        printer.setMetadata(this.contextProperties);
        printer.setClassificationPrinter(new MyClassificationPrinter());
        return printer;
    }

    public void printTitlePage() {
        this.documentPrinter.printTitlePage();
    }

    private boolean isDefaultTemplate() {
        String template = this.contextProperties.getTemplateName();
        if (template == null) {
            template = this.global.getTemplateName();
        }
        return !"simple".equalsIgnoreCase(template);
    }

    private Caption overviewDiagramCaption() {
        String text = null;
        text = this.root == null ? "Graphical representation of the " + this.contextProperties.getMediaType() + " media type" : "Complete JSON representation of " + this.root.getLocalName();
        return new Caption(CaptionType.Figure, text, "completeRep", null);
    }

    private void printDataBindings() throws IOException {
        if (!this.defaultTemplate) {
            return;
        }
        Heading heading = this.documentPrinter.createHeading("JSON Data Bindings");
        this.documentPrinter.beginSection(heading);
        this.printOverviewDiagram();
        this.printFrames();
        this.printDatatypes();
        this.documentPrinter.endSection();
    }

    private void printDatatypes() {
        for (Datatype type : this.datatypeList) {
            if (this.typeManager.isStandardDatatype(type.getNamespace())) continue;
            this.printDatatype(type);
        }
    }

    private void printMediaTypeConformance() {
        this.documentPrinter.endSection();
        if (!this.contextProperties.isMediaTypeSection()) {
            return;
        }
        if (this.context == null) {
            return;
        }
        String headingTemplate = "The {0} Media Type";
        String typeName = this.context.rewrite(this.root.getUri());
        String mediaType = this.contextProperties.getMediaType();
        String contextRef = this.contextProperties.getContextRef();
        Heading heading = this.documentPrinter.createHeading(headingTemplate.replace("{0}", typeName));
        this.documentPrinter.print(heading);
        String text = "The following list defines the necessary and sufficient conditions for a document to conform to the <code>{0}</code> media type.";
        this.printParagraph(text.replace("{0}", mediaType));
        this.indent().print("<OL");
        this.printAttr("class", "uncondensed");
        this.println(">");
        this.pushIndent();
        this.printListItem("The document MUST be a valid JSON document, in accordance with [RFC4627].");
        this.printListItem("The document MUST contain either a single top-level JSON object, or an array of top-level JSON objects.  The first object encountered (either the single top-level object or the first element of the array) is called the <em>root</em> object.");
        boolean hasSubtypes = this.root.getSubtypeList().size() > 1;
        text = hasSubtypes ? "The root object must have a <code>@type</code> property whose value is \"<code>{0}</code>\" or a subtype of <code>{0}</code>." : "The root object must have a <code>@type</code> property whose value is \"<code>{0}</code>\".";
        this.printListItem(text.replace("{0}", typeName));
        text = "Every top-level object MUST have a <code>@context</code> property that references one or more JSON-LD contexts (either by URI or by value).";
        this.printListItem(text);
        text = "Collectively, the set of contexts imported by the root object MUST contain all of the terms found in the <em>standard context</em> {0}.  In particular, the set of imported contexts must contain all the simple names that appear in the standard context, and those simple names must resolve to the same values that appear in the standard context.  This requirement may be satisfied by ensuring that the root object imports the standard context explicitly, or by importing a collection of other contexts that contain equivalent terms.";
        this.printListItem(text.replace("{0}", contextRef));
        text = "The set of contexts imported by the root object MAY include additional terms that do not appear in the standard context {0}.";
        this.printListItem(text.replace("{0}", contextRef));
        text = "Duplicate mappings for names among the imported contexts MUST be overwritten on a last-defined-overrides basis.";
        this.printListItem(text);
        text = "If the JSON-LD context coerces a property to a URI reference, then values of that property MUST be expressed as a fully-qualified URI reference, or a CURIE  or a simple name declared by the context.";
        this.printListItem(text);
        text = "A <em>collection property</em> is any property whose maximum cardinality is greater than 1. Except for the <code>@context</code> property, a non-empty collection MUST always be represented as a JSON array whose values are enclosed in square brackets. Whereas, in general, the JSON-LD syntax specification allows a collection containing a single value to omit the square brackets, the <code>" + mediaType + "</code> media type " + "requires square brackets for all non-empty collections other than the <code>@context</code> property.";
        this.printListItem(text);
        text = "An empty collection property may be represented either by an empty array (i.e. square brackets containing no elements), or by omitting the property altogether.";
        this.printListItem(text);
        text = "Like all other properties, the <code>@id</code> property of a given object is mandatory if the minimum cardinality of that property, as defined by this specification, is greater than zero. The <code>@id</code> property is optional for all other objects (even if it is not explicitly listed in the set of properties for an object).  Conforming implementations SHOULD include the <code>@id</code> property for all addressable objects.";
        this.printListItem(text);
        text = "If the <code>@id</code> property is mandatory, then the value MUST NOT treat the object as a blank node.  In this case, the <code>@id</code> value MUST NOT be a CURIE with an underscore as the prefix.";
        this.printListItem(text);
        text = "Every top-level object MUST contain a <code>@type</code> property and a @context property.";
        this.printListItem(text);
        text = "An embedded object MUST contain a <code>@type</code> property if the object value is a subtype of the declared range of the property.";
        this.printListItem(text);
        text = "Values for properties named in the standard context {0}, MUST not utilize the String Internationalization or Typed Value syntax as described in [JSON-LD-syntax].";
        this.printListItem(text.replace("{0}", contextRef));
        text = "If the context does not coerce the value of an object property to a URI reference, then the object must be rendered as an embedded object.";
        this.printListItem(text);
        text = "The properties of embedded objects must respect the cardinality constraints specified in the section titled JSON Data Bindings.";
        this.printListItem(text);
        this.popIndent();
        this.indent().println("</OL>");
    }

    private void printListItem(String text) {
        this.indent().print("<LI>").print(text).println("</LI>");
    }

    private void writeOutput() throws IOException {
        this.documentPrinter.insertTableOfContents();
        String text = this.documentPrinter.popText();
        String path = this.namer.getIndexFileName();
        OutputStream stream = this.streamFactory.createOutputStream(path);
        PrintStream printStream = stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream);
        printStream.print(text);
        printStream.close();
    }

    private void printToc() {
        if (!this.defaultTemplate) {
            return;
        }
        this.println(TOC_MARKER);
    }

    private void printAbstract() {
        String abstractText;
        if (!this.defaultTemplate) {
            return;
        }
        String string = abstractText = this.contextProperties == null ? null : this.contextProperties.getAbstactText();
        if (abstractText == null) {
            return;
        }
        this.indent().println("<H2>Abstract</H2>");
        this.indent().println("<DIV>");
        this.print(abstractText);
        this.println("</DIV>");
    }

    private void printIntroduction() throws IOException {
        String text = this.contextProperties.getIntroduction();
        if (this.defaultTemplate) {
            String headingText = "Introduction";
            Heading heading = this.documentPrinter.createHeading(headingText);
            this.documentPrinter.beginSection(heading);
        }
        if (text != null) {
            this.indent().println("<DIV>");
            this.print(text);
            this.println("</DIV>");
        }
        this.printSample();
        if (this.defaultTemplate) {
            this.printHowToRead();
        }
    }

    private void printSample() throws IOException {
        List<SampleJson> list;
        String defaultText;
        String typeName = null;
        if (this.context != null && this.root != null) {
            typeName = this.context.rewrite(this.root.getUri());
        }
        if ((defaultText = this.contextProperties.getSampleText()) == null) {
            defaultText = typeName == null ? "<p>Figure 1 shows the representation of a resource in the <code>" + this.contextProperties.getMediaType() + "</code> format.</p>" : "<p>Figure 1 shows the representation of " + this.article(typeName) + typeName + " resource in the <code>" + this.contextProperties.getMediaType() + "</code> format.</p>";
        }
        if ((list = this.contextProperties.getSampleJsonList()).isEmpty()) {
            this.print(defaultText);
            this.printDefaultSample(typeName);
        } else {
            if (list.size() == 1) {
                this.print(defaultText);
            } else {
                this.print("<p>The following ");
                this.print(list.size());
                this.print(" figures illustrate representations of different ");
                this.print(typeName);
                this.print(" resources in the <code>");
                this.print(this.contextProperties.getMediaType());
                this.print("</code> format.");
            }
            this.printOtherSamples();
        }
    }

    private void printHowToRead() throws IOException {
        if (this.context == null || !this.contextProperties.isHowToReadThisDocument()) {
            return;
        }
        Heading heading = this.documentPrinter.createHeading("How To Read this Document");
        this.documentPrinter.print(heading);
        this.printSampleObject();
        this.printPropertyRepresentation();
        this.printOptionalPropertyFigure();
        this.printRepeatedPropertyFigure();
        this.printObjectRepresentation();
        this.printReservedTerms();
        this.printContextDiscussion();
    }

    private void printContextDiscussion() {
        if (!this.contextProperties.isJsonldIntroduction()) {
            return;
        }
        Heading heading = this.documentPrinter.createHeading("The JSON-LD Context");
        this.documentPrinter.print(heading);
        this.printContextSnippet();
        this.printTypeCoercionSample();
    }

    private void printTypeCoercionSample() {
        TermInfo term = this.getTypeCoercionSample(new HashSet<String>(), this.root);
        if (term == null) {
            return;
        }
        this.printParagraph("A context may specify that the values of  certain object properties must be rendered as URI references.   The following snippet presents an example of such a rule.");
        this.beginCodeSnippet();
        this.println("  {");
        this.println("    \"@context\" = {");
        this.println("      ...");
        this.printTerm(term);
        this.println();
        this.println("      ...");
        this.println("  }");
        this.endCodeSnippet();
        this.printParagraph("This rule is an example of <em>type coercion</em>.  For more details about the syntax of a JSON-LD context, see [JSON-LD-syntax].");
    }

    private TermInfo getTypeCoercionSample(Set<String> history, Frame frame) {
        if (history.contains(frame.getUri())) {
            return null;
        }
        history.add(frame.getUri());
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            TermInfo term = this.context.getTermInfoByURI(field.getURI());
            if (term == null) continue;
            if (term.hasObjectValue() && "@id".equals(term.getObjectValue().getType())) {
                return term;
            }
            RdfType type = field.getRdfType();
            if (type == null || !type.canAsFrame() || (term = this.getTypeCoercionSample(history, type.asFrame())) == null) continue;
            return term;
        }
        return null;
    }

    private void printContextSnippet() {
        String contextRef = this.contextProperties.getContextRef();
        String typeName = this.context.rewrite(this.root.getUri());
        Field field = this.getSampleToken();
        String template = "In JSON-LD, a context is used to map simple names that appear in a JSON document to URI values for properties or data types in a formal vocabulary (typically an RDF ontology).  ";
        String example = "For example, the standard context {0} for a {1} contains the following rewrite rules (among others):";
        if (field != null) {
            example = example.replace("{0}", contextRef);
            template = template + example.replace("{1}", typeName);
        }
        this.printParagraph(template);
        if (field == null) {
            return;
        }
        TermInfo term = this.context.getTermInfoByURI(field.getURI());
        String namespace = field.getProperty().getNameSpace();
        String prefix = this.context.rewrite(namespace);
        this.beginCodeSnippet();
        this.println("  {");
        this.println("    \"@context\" = {");
        if (!prefix.equals(namespace)) {
            this.print("      \"").print(prefix).print("\" : \"").print(namespace).println("\",");
        }
        this.printTerm(term);
        this.println(",");
        this.println("      ...");
        this.println("    }");
        this.println("  }");
        this.endCodeSnippet();
    }

    private void printTerm(TermInfo term) {
        if (term.hasObjectValue()) {
            this.print("      \"");
            this.print(term.getTermName());
            this.println("\" : {");
            this.print("        \"@id\" : \"");
            this.print(term.getObjectValue().getId());
            this.println("\",");
            this.print("        \"@type\" : \"");
            this.print(term.getObjectValue().getType());
            this.println("\"");
            this.print("      }");
        } else {
            this.print("      \"");
            this.print(term.getTermName());
            this.print("\" : \"");
            this.print(term.getIri());
            this.print("\"");
        }
    }

    private void beginCodeSnippet() {
        this.indent().print("<DIV");
        this.printAttr("class", "code-snippet");
        this.println(">");
        this.println("<PRE>");
    }

    private void endCodeSnippet() {
        this.println("</PRE>");
        this.indent().println("</DIV>");
    }

    private Field getSampleToken() {
        List<Field> list = this.root.listAllFields();
        for (Field field : list) {
            TermInfo term = this.context.getTermInfoByURI(field.getURI());
            if (term == null || term.hasObjectValue()) continue;
            return field;
        }
        return null;
    }

    private void printReservedTerms() {
        if (!this.contextProperties.isReservedTermsSection()) {
            return;
        }
        Heading heading = this.documentPrinter.createHeading("Reserved Terms");
        this.documentPrinter.print(heading);
        this.printParagraph("The JSON-LD standard reserves a handful of property names and tokens that have special meaning.  These names and tokens, described below, begin with the '@' symbol.");
        this.indent().println("<DL");
        this.printAttr("class", "reservedTerms");
        this.println(">");
        this.pushIndent();
        this.printDefinition("@context", "Used to reference (by URI or by value) a <em>context</em> which declares the simple names that appear throughout a JSON document.");
        this.printDefinition("@id", "Used to uniquely identify things that are being described in the JSON document.  The value of an @id property is either a fully-qualified URI, a CURIE, or a simple name that expands to a fully-qualified URI by virtue of the rules defined in the JSON-LD Context.<P>The @id property may identify a so-called blank node by using a CURIE with an underscore as the prefix.  The binding of a JSON-LD document MAY include identifiers for blank nodes, but these identifiers are not required.");
        this.printDefinition("@type", "Used to set the data type of an object or property value.");
        this.popIndent();
        this.indent().println("</DL>");
        String text = "JSON-LD specifies four other reserved terms (@value, @language, @container, @list).  Ordinarily, these terms are not used in the JSON binding for <code>{0}</code> objects.  However, implementations that extend this specification by including additional properties may utilize these reserved terms in accordance with the rules defined by [JSON-LD-syntax].";
        String typeName = this.root.getLocalName();
        this.printParagraph(text.replace("{0}", typeName));
    }

    private void printDefinition(String termName, String description) {
        this.indent().print("<DT>").print(termName).println("</DT>");
        this.pushIndent();
        this.indent().print("<DD>").print(description).println("</DD>");
        this.popIndent();
    }

    private void printParagraph(String text) {
        this.indent().print("<P>").print(text).println("</P>");
    }

    private void printPropertyRepresentation() throws IOException {
        Field field = this.getSimpleTypeField(new HashSet<String>(), this.root);
        if (field == null) {
            field = this.getAnyField(this.root);
        }
        this.indent().print("<P>Each box representing a property specifies the name and type of the property , as shown in ");
        Caption caption = new Caption(CaptionType.Figure, "Graphical notation for a property", "sampleProperty", field.getURI());
        this.assignNumber(caption);
        this.documentPrinter.printLink(caption);
        this.print(".</P>");
        String src = this.namer.getImagesDir() + "/sampleProperty.png";
        this.printFigure(src, caption);
        if (this.diagramGenerator == null) {
            return;
        }
        TreeNode node = this.treeGenerator.generateNode(field);
        CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
        this.diagramGenerator.generateNotationDiagram(request);
    }

    private void printObjectRepresentation() throws IOException {
        Field uriRefField = this.getUriRefField(new HashSet<String>(), this.root);
        Field snRefField = this.getSnRefField(new HashSet<String>(), this.root);
        this.indent().println("<P>An object within a JSON-LD document may have one of four possible representations:<P>");
        this.indent().println("<OL>");
        this.pushIndent();
        this.indent().println("<LI>The object may be identified by a fully-qualified URI reference.</LI>");
        this.indent().println("<LI>The object may be identified by a Compact URI reference,  known as a CURIE [CURIE-syntax], that can be expanded to a fully qualified URI</LI>");
        this.indent().println("<LI>The object may be identified by a simple name that is mapped to a fully-qualified URI.  This mapping is defined by the JSON-LD context.</LI>");
        this.indent().println("<LI>The object may be embedded within the document.</LI>");
        this.popIndent();
        this.indent().println("</OL>");
        if (uriRefField != null) {
            this.printUriRefDiscussion(uriRefField);
        }
        this.printSnRefDiscussion(snRefField);
    }

    private void printUriRefDiscussion(Field field) throws IOException {
        Caption captionRef = this.captionManager.getFigureCaptionByURI(field.getURI());
        Caption caption = null;
        if (captionRef == null) {
            caption = captionRef = new Caption(CaptionType.Figure, "Property whose value is a URI reference", "uriRef", field.getURI());
        }
        this.indent().println("<P>When an object is to be identified by a fully-qualified URI or a CURIE, the box representing the object will be decorated with the #uri hash tag, as shown in ");
        this.documentPrinter.printLink(captionRef);
        this.println(".</P>");
        if (caption == null) {
            return;
        }
        this.assignNumber(caption);
        String src = this.namer.getImagesDir() + "/uriRef.png";
        TreeNode node = this.treeGenerator.generateNode(field);
        CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
        this.diagramGenerator.generateDiagram(request);
        this.printFigure(src, caption);
    }

    private void printSnRefDiscussion(Field field) throws IOException {
        String fieldURI = field == null ? null : field.getURI();
        Caption captionRef = this.captionManager.getFigureCaptionByURI(fieldURI);
        Caption caption = null;
        if (captionRef == null) {
            captionRef = caption = new Caption(CaptionType.Figure, "Property whose value is a simple name reference for an individual object or enumerable value", "snRef", fieldURI);
            this.assignNumber(caption);
        }
        this.indent().println("<P>When an object or enumerable value is to be identified by a simple name, the box representing the corresponding property will be decorated with the #sn hash tag, as shown in ");
        this.documentPrinter.printLink(captionRef);
        this.println(".</P>");
        if (caption == null) {
            return;
        }
        String src = this.namer.getImagesDir() + "/snRef.png";
        TreeNode node = null;
        if (field == null) {
            node = new TreeNode();
            node.setObjectPresentation(ObjectPresentation.SIMPLE_NAME);
            node.setMinCardinality(1);
            node.setMaxCardinality(1);
            node.setLocalName("@type");
            node.setTypeName("owl:Class");
            node.setTypeURI(OWL.Class.getURI());
        } else {
            node = this.treeGenerator.generateNode(field);
        }
        CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
        this.diagramGenerator.generateDiagram(request);
        this.printFigure(src, caption);
    }

    private void printSampleObject() throws IOException {
        Caption caption = new Caption(CaptionType.Figure, "Representation of a JSON object", "sampleObj", null);
        this.assignNumber(caption);
        this.indent().print("<P>This specification defines the structure of a JSON document using a graphical notation. In this notatation, an object is represented by a box that branches out to other boxes corresponding to the properties of that object, as shown in ");
        this.documentPrinter.printLink(caption);
        this.println(".</P>");
        String src = this.namer.getImagesDir() + "/sampleObj.png";
        List<Frame> graphTypes = this.getGraphTypes();
        TreeNode node = graphTypes == null ? this.treeGenerator.generateRoot(this.root, 1) : this.treeGenerator.generateGraph(graphTypes, 1);
        CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
        this.diagramGenerator.generateDiagram(request);
        this.printFigure(src, caption);
        List<Field> embedded = this.listEmbeddedObjects(this.root);
        if (embedded.size() > 1) {
            String article = this.article(this.root.getLocalName());
            this.indent().print("<P>" + caption.getNumber() + " is not a complete representation of " + article + "  <code>" + this.root.getLocalName() + "</code> object because there are embedded objects (");
            String comma = "";
            for (Field e : embedded) {
                this.print(comma);
                TermInfo term = this.context.getTermInfoByURI(e.getURI());
                if (term == null) continue;
                this.print("<code>");
                this.print(term.getTermName());
                this.print("</code>");
                comma = ", ";
            }
            this.print(").  A complete diagram would show branches emanating from the embedded objects to reveal their properties, and so on, recursively. For a complete representation, see ");
            this.documentPrinter.printForwardRef(this.overviewDiagram);
            this.print(" below.</P>");
        } else if (embedded.size() == 1) {
            Field e = embedded.get(0);
            TermInfo term = this.context.getTermInfoByURI(e.getURI());
            if (term == null) {
                throw new TermNotFoundException(e.getURI());
            }
            String article = Character.toUpperCase(this.root.getLocalName().charAt(0)) == 'A' ? "an" : "a";
            this.indent().print("<P>" + caption.getNumber() + " is not a complete representation of " + article + "  <code>" + this.root.getLocalName() + "</code> object because <code>" + term.getTermName() + "</code> is an embedded object. A complete diagram would show branches emanating from <code>" + term.getTermName() + "</code> " + "to reveal its properties, and so on, recursively. For a complete representation, see ");
            this.documentPrinter.printForwardRef(this.overviewDiagram);
            this.print(" below.</P>");
        }
    }

    private String article(String text) {
        char c = Character.toLowerCase(text.charAt(0));
        return VOWEL.indexOf(c) >= 0 ? "an " : "a ";
    }

    private List<Field> listEmbeddedObjects(Frame frame) {
        ArrayList<Field> result = new ArrayList<Field>();
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            if (!this.isEmbeddedObject(field, field.getRdfType()) || !this.isIncluded(frame, field)) continue;
            result.add(field);
        }
        return result;
    }

    private boolean isIncluded(Frame frame, Field field) {
        String fieldName = field.getLocalName();
        return this.context.getTermInfoByShortName(fieldName) != null;
    }

    private boolean isEmbeddedObject(Field field, RdfType type) {
        if (type == null) {
            return false;
        }
        if (type.canAsListType()) {
            return this.isEmbeddedObject(field, type.asListType().getElementType());
        }
        if (!type.canAsFrame() || type.asFrame().getCategory() == RestCategory.ENUMERABLE) {
            return false;
        }
        if (this.isShortCircuit(type.asFrame())) {
            return false;
        }
        TermInfo term = this.context.getTermInfoByURI(field.getURI());
        return term == null || !term.isCoercedAsIriRef();
    }

    private boolean isShortCircuit(Frame frame) {
        if (!frame.isAbstract()) {
            return false;
        }
        List<Frame> frameList = frame.listAllSubtypes();
        List<Datatype> typeList = frame.getSubdatatypeList();
        return frameList.size() + typeList.size() == 1;
    }

    private void printRepeatedPropertyFigure() throws IOException {
        String typeText = null;
        Field field = this.getRepeatedSimpleType(new HashSet<String>(), this.root);
        if (field != null) {
            typeText = "xs:" + field.getType().getLocalName();
        } else {
            field = this.getAnyRepeatedField(new HashSet<String>(), this.root);
        }
        if (field == null) {
            return;
        }
        if (typeText == null) {
            RdfType rdfType = field.getRdfType();
            if (rdfType.canAsListType()) {
                rdfType = rdfType.asListType().getElementType();
            }
            String typeURI = rdfType.getUri();
            typeText = this.context.rewrite(typeURI);
        }
        Caption captionRef = this.captionManager.getFigureCaptionByURI(field.getURI());
        Caption caption = null;
        if (captionRef == null) {
            captionRef = caption = new Caption(CaptionType.Figure, "Example of a repeatable property", "repeatable-property", field.getURI());
            this.assignNumber(caption);
        }
        this.indent().print("<P>If a property can have multiple values, then its box in the graphical notation is decorated with a circle that contains a plus sign (+) as shown in ");
        this.documentPrinter.printLink(captionRef);
        String fieldName = field.getLocalName();
        String value = field.getRdfType() != null && field.getRdfType().canAsFrame() ? " object" : " value";
        value = "<code>" + typeText + "</code>" + value;
        this.println(".  In this example, the <code>" + fieldName + "</code> property may reference more than one " + value + ".  Ordinarily, these values are encapsulated within a JSON array, but if it turns out that " + " only one value is present, then the square brackets for the array are optional.</P>");
        if (caption == null) {
            return;
        }
        String src = this.namer.getImagesDir() + "/repeatableproperty.png";
        TreeNode node = this.treeGenerator.generateNode(field);
        CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
        this.diagramGenerator.generateDiagram(request);
        this.printFigure(src, caption);
    }

    private void printOptionalPropertyFigure() throws IOException {
        Field field = this.getOptionalSimpleType(new HashSet<String>(), this.root);
        if (field == null) {
            field = this.getAnyOptionalField(new HashSet<String>(), this.root);
        }
        if (field == null) {
            return;
        }
        String fieldURI = field.getURI();
        Caption captionRef = this.captionManager.getFigureCaptionByURI(fieldURI);
        Caption caption = null;
        if (captionRef == null) {
            captionRef = caption = new Caption(CaptionType.Figure, "Example of an optional property", "optional-property", fieldURI);
            this.assignNumber(caption);
        }
        this.indent().print("<P>If a property is optional, its box will be decorated with a circle that contains a question mark, as shown in ");
        this.documentPrinter.printLink(captionRef);
        this.println(".</P>");
        if (caption == null) {
            return;
        }
        String src = this.namer.getImagesDir() + "/optionalproperty.png";
        TreeNode node = null;
        node = this.treeGenerator.generateNode(field);
        CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
        this.diagramGenerator.generateDiagram(request);
        this.printFigure(src, caption);
    }

    private Field getUriRefField(Set<String> history, Frame frame) {
        if (history.contains(frame.getUri())) {
            return null;
        }
        history.add(frame.getUri());
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            Field result;
            String shortName = field.getLocalName();
            TermInfo info = this.context.getTermInfoByShortName(shortName);
            if (info == null) continue;
            RdfType type = field.getRdfType();
            if (info.hasObjectValue() && "@id".equals(info.getObjectValue().getType()) && type != null && type.canAsFrame() && type.asFrame().getCategory() != RestCategory.ENUMERABLE) {
                return field;
            }
            if (type == null || !type.canAsFrame() || (result = this.getUriRefField(history, type.asFrame())) == null) continue;
            return result;
        }
        return null;
    }

    private Field getSnRefField(Set<String> history, Frame frame) {
        if (history.contains(frame.getUri())) {
            return null;
        }
        history.add(frame.getUri());
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            RdfType type;
            String shortName = field.getLocalName();
            TermInfo info = this.context.getTermInfoByShortName(shortName);
            if (info == null || (type = field.getRdfType()) == null || !type.canAsFrame()) continue;
            Frame obj = type.asFrame();
            if (obj.getCategory() == RestCategory.ENUMERABLE) {
                return field;
            }
            Field result = this.getSnRefField(history, obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Field getRepeatedSimpleType(Set<String> history, Frame frame) {
        if (history.contains(frame.getUri())) {
            return null;
        }
        history.add(frame.getUri());
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            Field result;
            if (this.context.getTermInfoByURI(field.getURI()) == null || field.getMaxCardinality() > 0 && field.getMaxCardinality() < 2) continue;
            String typeURI = field.getType().getURI();
            if (typeURI != null && this.typeManager.isStandardDatatype(field.getType().getNameSpace())) {
                return field;
            }
            RdfType type = field.getRdfType();
            if (type == null || !type.canAsFrame() || (result = this.getRepeatedSimpleType(history, type.asFrame())) == null) continue;
            return result;
        }
        return null;
    }

    private Field getOptionalSimpleType(HashSet<String> history, Frame frame) {
        if (history.contains(frame.getUri())) {
            return null;
        }
        history.add(frame.getUri());
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            Field result;
            if (field.getMinCardinality() == 0 && field.getMaxCardinality() == 1 && field.getType().getURI() != null && this.typeManager.isStandardDatatype(field.getType().getNameSpace()) && this.context.getTermInfoByURI(field.getURI()) != null) {
                return field;
            }
            RdfType type = field.getRdfType();
            if (type == null || !type.canAsFrame() || (result = this.getOptionalSimpleType(history, type.asFrame())) == null) continue;
            return result;
        }
        return null;
    }

    private Field getAnyOptionalField(HashSet<String> history, Frame frame) {
        if (history.contains(frame.getUri())) {
            return null;
        }
        history.add(frame.getUri());
        List<Field> list = frame.listAllFields();
        if (list.isEmpty()) {
            return null;
        }
        for (Field field : list) {
            Field result;
            if (field.getMinCardinality() == 0 && field.getMaxCardinality() == 1 && !field.getRdfType().canAsListType() && this.context.getTermInfoByURI(field.getURI()) != null) {
                return field;
            }
            RdfType type = field.getRdfType();
            if (type == null || !type.canAsFrame() || (result = this.getAnyOptionalField(history, type.asFrame())) == null) continue;
            return result;
        }
        return null;
    }

    private Field getAnyRepeatedField(HashSet<String> history, Frame frame) {
        if (history.contains(frame.getUri())) {
            return null;
        }
        history.add(frame.getUri());
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            Field result;
            if (this.context.getTermInfoByURI(field.getURI()) == null) continue;
            if (field.getRdfType().canAsListType()) {
                return field;
            }
            if (field.getMaxCardinality() != 1) {
                return field;
            }
            RdfType type = field.getRdfType();
            if (type == null || !type.canAsFrame() || (result = this.getAnyRepeatedField(history, type.asFrame())) == null) continue;
            return result;
        }
        return null;
    }

    private Field getAnyField(Frame root) {
        List<Field> list = root.listAllFields();
        if (list.isEmpty()) {
            return null;
        }
        for (Field field : list) {
            String uri = field.getType().getURI();
            if (uri == null || uri.startsWith(RDFS.getURI()) || uri.startsWith("http://www.w3.org/2002/07/owl#") || this.context.getTermInfoByURI(field.getURI()) == null) continue;
            return field;
        }
        return list.get(0);
    }

    private void printFigure(String src, Caption caption) {
        this.indent().print("<DIV");
        this.printAttr("class", "figure");
        this.printAttr("id", caption.getId());
        this.println(">");
        this.pushIndent();
        this.indent().print("<IMG");
        this.printAttr("src", src);
        this.println("/>");
        this.printCaption(caption);
        this.popIndent();
        this.indent().println("</DIV>");
    }

    private void printCaption(Caption caption) {
        this.captionManager.add(caption);
        this.indent().print("<DIV");
        this.printAttr("class", "caption");
        this.println(">");
        this.print(caption.getNumber());
        this.print(".&nbsp&nbsp;");
        this.print(caption.getText());
        this.indent().println("</DIV>");
    }

    private Field getSimpleTypeField(Set<String> history, Frame frame) {
        String frameURI = frame.getUri();
        if (history.contains(frameURI)) {
            return null;
        }
        history.add(frameURI);
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            Field result;
            String typeURI = field.getType().getURI();
            if (typeURI == null) continue;
            TermInfo term = this.context.getTermInfoByURI(field.getURI());
            if (this.typeManager.isStandardDatatype(field.getType().getNameSpace()) && term != null) {
                return field;
            }
            RdfType type = field.getRdfType();
            if (type == null || !type.canAsFrame() || (result = this.getSimpleTypeField(history, type.asFrame())) == null) continue;
            return result;
        }
        return null;
    }

    private void assignNumber(Caption caption) {
        String number = null;
        switch (caption.getType()) {
            case Figure: {
                ++this.figureNumber;
                number = "Figure " + this.figureNumber;
                break;
            }
            case Table: {
                ++this.tableNumber;
                number = "Table " + this.tableNumber;
            }
        }
        caption.setNumber(number);
    }

    public List<Frame> listFrames() {
        return this.frameList;
    }

    public boolean isIncludeOverviewDiagram() {
        return this.includeOverviewDiagram && this.context != null && this.contextProperties.isOverviewDiagram();
    }

    public void setIncludeOverviewDiagram(boolean includeOverviewDiagram) {
        this.includeOverviewDiagram = includeOverviewDiagram;
    }

    public boolean isIncludeClassDiagrams() {
        return this.includeClassDiagrams;
    }

    public void setIncludeClassDiagrams(boolean includeClassDiagrams) {
        this.includeClassDiagrams = includeClassDiagrams;
    }

    private void beginHTML() {
        this.println("<HTML>");
        this.println("<HEAD>");
        this.pushIndent();
        this.printStyleSheetLink();
        this.popIndent();
        this.println("</HEAD>");
        this.println("<BODY>");
    }

    private void printStyleSheetLink() {
        String mediaType = this.contextProperties.getMediaType();
        String href = this.namer.pathToStyleSheet(mediaType);
        this.indent().print("<LINK");
        this.printAttr("REL", "StyleSheet");
        this.printAttr("HREF", href);
        this.printAttr("TYPE", "text/css");
        this.println(">");
    }

    private void endHTML() {
        this.println("</BODY>");
        this.println("</HTML>");
    }

    private void printOverviewDiagram() throws IOException {
        if (!this.isIncludeOverviewDiagram()) {
            return;
        }
        String typeName = this.context.rewrite(this.root.getUri());
        String text = "{0} presents a complete graphical representation of the JSON binding for a {1} object. The subsections following this figure provide details about each object that appears in the JSON binding for a {1} object.";
        Caption caption = this.overviewDiagram;
        this.assignNumber(caption);
        text = text.replace("{0}", caption.getNumber()).replace("{1}", typeName);
        this.printParagraph(text);
        this.indent().print("<div");
        this.printAttr("class", "overviewDiagram");
        this.printAttr("id", caption.getId());
        this.println(">");
        this.pushIndent();
        String src = this.namer.getOverviewDiagramPath();
        this.indent().print("<img");
        this.printAttr("src", src);
        this.println("/>");
        this.popIndent();
        this.println("</div>");
        this.printCaption(caption);
        if (this.diagramGenerator != null) {
            String rdfProperty = this.contextProperties.getRdfProperty();
            List<Frame> graphTypes = this.getGraphTypes();
            TreeNode node = graphTypes == null ? this.treeGenerator.generateRoot(this.root, rdfProperty, -1) : this.treeGenerator.generateGraph(graphTypes, -1);
            this.sortAll(node);
            CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
            this.diagramGenerator.generateDiagram(request);
        }
    }

    private void printDefaultSample(String typeName) throws IOException {
        String sampleText = this.getSampleText();
        this.indent().print("<DIV");
        this.printAttr("class", "jsonSample");
        this.println(">");
        this.println("<PRE>");
        this.println(sampleText);
        this.println("</PRE>");
        this.indent().print("</DIV>");
        String sampleCaptionText = null;
        if (typeName == null) {
            sampleCaptionText = "Example JSON document in the format " + this.contextProperties.getMediaType();
        } else {
            sampleCaptionText = "Example JSON document containing {0} {1} object";
            sampleCaptionText = sampleCaptionText.replace("{0}", this.article(typeName));
            sampleCaptionText = sampleCaptionText.replace("{1}", typeName);
        }
        Caption sampleCaption = new Caption(CaptionType.Figure, sampleCaptionText, "completeSample", null);
        this.assignNumber(sampleCaption);
        this.printCaption(sampleCaption);
    }

    private void printOtherSamples() throws IOException {
        List<SampleJson> list = this.contextProperties.getSampleJsonList();
        for (SampleJson sample : list) {
            this.printSample(sample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSample(SampleJson sample) throws IOException {
        InputStream input = this.streamFactory.createInputStream(sample.getFileName());
        if (input == null) {
            logger.warn("File not found " + sample.getFileName());
            return;
        }
        BufferedReader buffer = new BufferedReader(new InputStreamReader(input));
        StringBuilder builder = new StringBuilder();
        try {
            String line = null;
            while ((line = buffer.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
        }
        finally {
            buffer.close();
        }
        String sampleText = builder.toString();
        this.jsonManager.add(sampleText);
        this.indent().print("<DIV");
        this.printAttr("class", "jsonSample");
        this.println(">");
        this.println("<PRE>");
        this.println(sampleText);
        this.println("</PRE>");
        this.indent().print("</DIV>");
        Caption sampleCaption = new Caption(CaptionType.Figure, sample.getCaption(), sample.getFileName(), null);
        this.assignNumber(sampleCaption);
        this.printCaption(sampleCaption);
    }

    private void sortAll(TreeNode node) {
        String typeURI = node.getTypeURI();
        List<TreeNode> kids = node.getChildren();
        if (typeURI != null && kids != null && !kids.isEmpty()) {
            Collections.sort(kids, this.nodeComparatorFactory.getComparator(typeURI));
        }
        if (kids != null) {
            for (TreeNode child : kids) {
                this.sortAll(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSampleText() throws IOException {
        String fileName = this.namer.getJsonSampleFileName();
        InputStream input = this.streamFactory.createInputStream(fileName);
        String result = null;
        if (input == null) {
            result = this.createJsonSample();
        } else {
            BufferedReader buffer = new BufferedReader(new InputStreamReader(input));
            StringBuilder builder = new StringBuilder();
            try {
                String line = null;
                while ((line = buffer.readLine()) != null) {
                    builder.append(line);
                    builder.append("\n");
                }
            }
            finally {
                buffer.close();
            }
            result = builder.toString();
        }
        this.jsonManager.add(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createJsonSample() throws IOException {
        ObjectNode node = this.sampleGenerator.generateSample(this.context, this.contextProperties);
        String fileName = this.namer.getJsonSampleFileName();
        OutputStream out = this.streamFactory.createOutputStream(fileName);
        StringWriter buffer = new StringWriter();
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writer((PrettyPrinter)new JsonPrettyPrinter());
            mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
            writer.writeValue(out, (Object)node);
            writer.writeValue((Writer)buffer, (Object)node);
        }
        finally {
            out.close();
        }
        return buffer.toString();
    }

    private void printFrames() throws IOException {
        for (Frame frame : this.frameList) {
            this.printFrame(frame);
        }
    }

    private void printDatatype(Datatype type) {
        if (this.typeManager.isStandardDatatype(type.getNamespace())) {
            return;
        }
        String termName = null;
        Heading heading = null;
        TermInfo term = this.context.getTermInfoByURI(type.getUri());
        if (term != null) {
            termName = term.getTermName();
            heading = this.documentPrinter.createHeading(termName);
        } else {
            if (this.typeManager.isStandardLiteralType(type.getUri())) {
                return;
            }
            TreeNode node = NodeUtil.createDefaultTypeNode(this.typeManager, this.context, type.getUri());
            termName = node.getTypeName();
            Level level = this.documentPrinter.getCurrentHeading().getLevel().getNextLevel();
            String id = node.getTypeHref().substring(1);
            heading = new Heading(level, termName, id);
            this.documentPrinter.getCurrentHeading().add(heading);
        }
        heading.setClassName("rdfType");
        this.documentPrinter.print(heading);
        String baseURI = this.typeManager.getXsdBaseURI(type);
        this.beginTable("propertiesTable");
        this.beginRow();
        this.printTH("Restriction&nbsp;Base");
        this.printTD(baseURI);
        this.endRow();
        this.printStringFacet("pattern", type.getPattern());
        this.printNumberFacet("length", type.getLength());
        this.printNumberFacet("minLength", type.getMinLength());
        this.printNumberFacet("maxLength", type.getMaxLength());
        this.printNumberFacet("minInclusive", type.getMinInclusive());
        this.printNumberFacet("maxInclusive", type.getMaxInclusive());
        this.printNumberFacet("minExclusive", type.getMinExclusive());
        this.printNumberFacet("maxExclusive", type.getMaxExclusive());
        this.printNumberFacet("totalDigits", type.getTotalDigits());
        this.printNumberFacet("fractionDigits", type.getFractionDigits());
        this.endTable();
        String captionText = "Facets of " + termName;
        Caption caption = new Caption(CaptionType.Table, captionText, termName, type.getUri());
        this.assignNumber(caption);
        this.printCaption(caption);
    }

    private void printNumberFacet(String name, Number value) {
        if (value == null) {
            return;
        }
        this.beginRow();
        this.printTH(name);
        this.printTD(value.toString());
        this.endRow();
    }

    private void printStringFacet(String name, String value) {
        if (value == null) {
            return;
        }
        this.beginRow();
        this.printTH(name);
        this.printTD(value);
        this.endRow();
    }

    protected void beginTable(String className) {
        this.indent().print("<TABLE");
        this.printAttr("class", className);
        this.println(">");
        this.pushIndent();
    }

    protected void endTable() {
        this.popIndent();
        this.indent().println("</TABLE>");
    }

    protected void beginRow() {
        this.indent().println("<TR>");
        this.pushIndent();
    }

    protected void endRow() {
        this.popIndent();
        this.indent().println("</TR>");
    }

    protected void printTH(String value) {
        this.indent().print("<TH>").print(value).println("</TH>");
    }

    protected void printTD(String value) {
        this.indent().print("<TD>").print(value).println("</TD>");
    }

    private void printFrame(Frame frame) throws IOException {
        this.println();
        TreeGenerator generator = new TreeGenerator(this.typeManager, this.context, this.contextProperties);
        List<Frame> graphTypes = this.getGraphTypes();
        boolean isRoot = this.isRoot(frame);
        TreeNode node = isRoot && graphTypes == null ? generator.generateRoot(frame, 1) : generator.generateNode(frame, 1);
        List<TreeNode> fieldList = node.getChildren();
        if (fieldList != null) {
            Collections.sort(fieldList, this.nodeComparatorFactory.getComparator(frame.getUri()));
        }
        Heading heading = this.documentPrinter.createHeading(node.getTypeName());
        String comment = node.getDescription();
        heading.setClassName("rdfType");
        this.documentPrinter.print(heading);
        if (comment.length() > 0) {
            this.print("<div");
            this.printAttr("class", "classComment");
            this.println(">");
            this.print(comment);
            this.println("</div>");
        }
        this.printClassDiagram(frame, node);
        this.printSubtypes(frame);
        this.printProperties(node);
        this.printIndividuals(frame);
    }

    private boolean isRoot(Frame frame) {
        if (frame == this.root) {
            return true;
        }
        List<Frame> list = this.root.listAllSubtypes();
        return list.contains(frame);
    }

    private void printIndividuals(Frame frame) {
        if (frame.getCategory() != RestCategory.ENUMERABLE) {
            return;
        }
        List<NamedIndividual> list = frame.listInstances(false);
        if (list.isEmpty()) {
            return;
        }
        Collections.sort(list, new Comparator<NamedIndividual>(){

            @Override
            public int compare(NamedIndividual a, NamedIndividual b) {
                return a.getLocalName().compareTo(b.getLocalName());
            }
        });
        String typeName = this.context.rewrite(frame.getUri());
        String text = "Known simple names for {0} objects".replace("{0}", typeName);
        Caption caption = new Caption(CaptionType.Table, text, typeName + "-known-sn", frame.getUri());
        this.assignNumber(caption);
        text = "<code>{0}</code> instances are enumerable, and they must be referenced by a simple name. The default vocabulary of simple names for instances of the <code>{0}</code> class are listed in {1}.";
        this.println();
        this.printParagraph(text.replace("{0}", typeName).replace("{1}", caption.getNumber()));
        this.indent().print("<TABLE");
        this.printAttr("class", "enumTable");
        this.println(">");
        this.pushIndent();
        this.indent().println("<TR>");
        this.pushIndent();
        this.indent().print("<TH>Simple Name</TH>");
        this.indent().print("<TH>URI / Description</TH>");
        this.popIndent();
        this.indent().println("</TR>");
        for (NamedIndividual n : list) {
            String localName = n.getLocalName();
            String uri = n.getUri();
            String comment = n.getComment();
            if (comment != null && (comment = comment.trim()).length() == 0) {
                comment = null;
            }
            this.indent().println("<TR>");
            this.pushIndent();
            this.indent().print("<TD>").print(localName).println("</TD>");
            this.indent().print("<TD>");
            this.print("<div class=\"individual-uri\">").print(uri).print("</div>");
            if (comment != null) {
                this.print("<div class=\"enumText\">").print(comment).print("</div>");
            }
            this.println("</TD>");
            this.popIndent();
            this.indent().println("</TR>");
        }
        this.popIndent();
        this.indent().println("</TABLE>");
        this.printCaption(caption);
    }

    private void printClassDiagram(Frame frame, TreeNode node) throws IOException {
        if (!this.includeClassDiagrams) {
            return;
        }
        String src = this.namer.getClassDiagramPath(frame);
        String typeName = this.context.rewrite(frame.getUri());
        Caption caption = new Caption(CaptionType.Figure, typeName, typeName, frame.getUri());
        this.assignNumber(caption);
        String jsonExample = this.getJsonSample(frame);
        if (jsonExample != null) {
            this.print("<PRE");
            this.printAttr("class", "jsonSnippet");
            this.println(">");
            this.println(jsonExample);
            this.println("</PRE>");
        }
        this.indent().print("<DIV");
        this.printAttr("class", "classDiagram");
        this.println(">");
        this.pushIndent();
        this.indent().print("<img");
        this.printAttr("src", src);
        this.println("/>");
        this.printCaption(caption);
        this.popIndent();
        this.indent().println("</DIV>");
        if (this.diagramGenerator == null) {
            return;
        }
        CreateDiagramRequest request = new CreateDiagramRequest(this.context, node, src);
        this.diagramGenerator.generateDiagram(request);
    }

    private String getJsonSample(Frame frame) {
        String text = this.jsonManager.getJsonText(frame.getUri());
        if (text != null) {
            text = text.replaceAll("\\[\\s*\\]", "[ ... ]").replaceAll("\\{\\s*\\}", "{ ... }");
        }
        return text;
    }

    private void printProperties(TreeNode node) {
        List<TreeNode> list = node.getChildren();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.indent().print("<TABLE");
        this.printAttr("class", "propertiesTable");
        this.printAttr("border", "0");
        this.printAttr("width", "100%");
        this.printAttr("cellspacing", "0");
        this.println(">");
        this.pushIndent();
        this.indent().println("<TR>");
        this.pushIndent();
        this.indent().println("<TH>Property</TH>");
        this.indent().println("<TH>Mult</TH>");
        this.indent().println("<TH>Description</TH>");
        this.indent().println("<TH>Type</TH>");
        this.popIndent();
        this.indent().println("</TR>");
        for (TreeNode field : list) {
            this.printField(field);
        }
        this.popIndent();
        this.indent().println("</TABLE>");
        String typeName = node.getTypeName();
        Caption caption = new Caption(CaptionType.Table, typeName + " properties", typeName + "-properties", null);
        this.assignNumber(caption);
        this.printCaption(caption);
    }

    private void printSubtypes(Frame frame) {
        List<Frame> sublist = frame.listAllSubtypes();
        if (sublist.isEmpty()) {
            return;
        }
        this.indent().print("<div");
        this.printAttr("class", "list-heading");
        this.println(">Direct Known Subtypes:</div>");
        this.indent().print("<div");
        this.printAttr("class", "running-list");
        this.println(">");
        this.pushIndent();
        boolean addComma = false;
        for (Frame subtype : sublist) {
            TermInfo info = this.context.getTermInfoByURI(subtype.getUri());
            if (info == null) continue;
            if (addComma) {
                this.println(",");
            }
            addComma = true;
            String href = "#" + info.getTermName();
            String typeName = info.getTermName();
            this.indent().print("<A ");
            this.printAttr("href", href);
            this.print(">");
            this.print(typeName);
            this.print("</a>");
        }
        this.println();
        this.popIndent();
        this.indent().println("</div>");
    }

    private void printField(TreeNode field) {
        String localName = field.getLocalName();
        String mult = this.getMultiplicity(field);
        String description = field.getDescription();
        String typeLabel = field.getTypeName();
        String href = field.getTypeHref();
        this.indent().println("<TR>");
        this.pushIndent();
        this.indent().print("<TD>");
        this.print(localName);
        this.println("</TD>");
        this.indent().print("<TD>");
        this.print(mult);
        if (field.isSequential()) {
            this.print("<DIV");
            this.printAttr("class", "qualifier");
            this.println(">(ordered)</DIV>");
        }
        this.println("</TD>");
        this.indent().print("<TD>");
        this.print(description);
        this.println("</TD>");
        this.indent().print("<TD>");
        if (href != null) {
            this.print("<A");
            this.printAttr("href", href);
            this.print(">");
        }
        this.print(typeLabel);
        if (href != null) {
            this.print("</A>");
        }
        switch (field.getObjectPresentation()) {
            case MIXED_VALUE: {
                this.print("<DIV");
                this.printAttr("class", "qualifier");
                this.println(">(Mixed - URI&nbsp;reference OR Embedded&nbsp;value)</DIV>");
                break;
            }
            case URI_REFERENCE: {
                this.print("<DIV");
                this.printAttr("class", "qualifier");
                this.println(">(URI&nbsp;reference)</DIV>");
                break;
            }
            case SIMPLE_NAME: {
                this.print("<DIV");
                this.printAttr("class", "qualifier");
                this.println(">(Simple&nbsp;Name&nbsp;reference)</DIV>");
            }
        }
        this.println("</TD>");
        this.popIndent();
        this.indent().println("</TR>");
    }

    private String getMultiplicity(TreeNode node) {
        int min = node.getMinCardinality();
        int max = node.getMaxCardinality();
        if (min == 0 && max < 0) {
            return "*";
        }
        if (min == 1 && max == 1) {
            return "1";
        }
        String maxLabel = max < 0 ? "*" : Integer.toString(max);
        return min + ".." + maxLabel;
    }

    private void collectFrames() {
        this.frameList = new ArrayList<Frame>();
        this.datatypeList = new ArrayList<Datatype>();
        if (this.context == null) {
            return;
        }
        Set<String> reachable = this.getReachableTypes();
        List<TermInfo> termList = this.context.getTerms();
        for (TermInfo term : termList) {
            if (term.getCategory() != TermInfo.TermCategory.TYPE) continue;
            String qname = term.getIri();
            String uri = this.context.toAbsoluteIRI(qname);
            Frame frame = this.typeManager.getFrameByUri(uri);
            if (frame == null) {
                if (this.typeManager.isStandard(uri)) continue;
                Datatype type = this.typeManager.getDatatypeByUri(uri);
                if (type != null) {
                    if (!reachable.contains(uri)) continue;
                    this.datatypeList.add(type);
                    continue;
                }
                throw new FrameNotFoundException(uri);
            }
            if (!reachable.contains(frame.getUri())) continue;
            this.frameList.add(frame);
        }
        this.addMissingTypes(reachable);
        Collections.sort(this.frameList);
        Collections.sort(this.datatypeList, new Comparator<Datatype>(){

            @Override
            public int compare(Datatype a, Datatype b) {
                TermInfo aTerm = ContextHtmlPrinter.this.context.getTermInfoByURI(a.getUri());
                TermInfo bTerm = ContextHtmlPrinter.this.context.getTermInfoByURI(b.getUri());
                String aName = aTerm == null ? a.getLocalName() : aTerm.getTermName();
                String bName = bTerm == null ? b.getLocalName() : bTerm.getTermName();
                return aName.compareTo(bName);
            }
        });
    }

    private void addMissingTypes(Set<String> reachable) {
        for (String uri : reachable) {
            Datatype type;
            TermInfo term = this.context.getTermInfoByURI(uri);
            if (term != null || (type = this.typeManager.getDatatypeByUri(uri)) == null) continue;
            this.datatypeList.add(type);
        }
    }

    private Set<String> getReachableTypes() {
        HashSet<String> set = new HashSet<String>();
        List<Frame> graphTypes = this.getGraphTypes();
        if (graphTypes != null) {
            for (Frame frame : graphTypes) {
                this.addReachableTypes(set, frame);
            }
        } else if (this.root != null) {
            this.addReachableTypes(set, this.root);
            this.addSubtypes(set, this.root);
        }
        return set;
    }

    private void addReachableTypes(Set<String> set, Frame frame) {
        String uri = frame.getUri();
        if (set.contains(uri)) {
            return;
        }
        set.add(uri);
        List<Field> fieldList = frame.listAllFields();
        for (Field field : fieldList) {
            if (this.contextProperties.isIdRef(field.getURI()) || !this.isIncluded(frame, field)) continue;
            OntProperty p = field.getProperty();
            String propertyURI = p.getURI();
            TermInfo info = this.context.getTermInfoByURI(propertyURI);
            RdfType type = field.getRdfType();
            if (type.canAsListType()) {
                type = type.asListType().getElementType();
            }
            if (info != null && type.canAsDatatype()) {
                set.add(type.getUri());
                continue;
            }
            if (info != null && info.hasObjectValue() && "@id".equals(info.getObjectValue().getType()) && type != null && type.canAsFrame() && type.asFrame().getCategory() != RestCategory.ENUMERABLE || type == null || !type.canAsFrame()) continue;
            this.addReachableTypes(set, type.asFrame());
            this.addSubtypes(set, type.asFrame());
            this.addSubdatatypes(set, type.asFrame());
        }
    }

    private void addSubdatatypes(Set<String> set, Frame frame) {
        List<Datatype> list = frame.getSubdatatypeList();
        for (Datatype type : list) {
            set.add(type.getUri());
        }
    }

    private void addSubtypes(Set<String> set, Frame baseFrame) {
        List<Frame> list = baseFrame.listAllSubtypes();
        for (Frame frame : list) {
            this.addReachableTypes(set, frame);
        }
    }

    static class CaptionManager {
        Map<String, Caption> uri2FigureCaption = new HashMap<String, Caption>();

        CaptionManager() {
        }

        public void add(Caption caption) {
            if (caption.getUri() == null) {
                return;
            }
            switch (caption.getType()) {
                case Figure: {
                    this.uri2FigureCaption.put(caption.getUri(), caption);
                }
            }
        }

        public Caption getFigureCaptionByURI(String uri) {
            return this.uri2FigureCaption.get(uri);
        }
    }

    class MyClassificationPrinter
    implements ClassificationPrinter {
        MyClassificationPrinter() {
        }

        @Override
        public void printClassifiers() {
            String mediaType = ContextHtmlPrinter.this.contextProperties.getMediaType();
            String rdfType = ContextHtmlPrinter.this.root == null ? null : ContextHtmlPrinter.this.root.getUri();
            String contextURI = ContextHtmlPrinter.this.context == null ? null : ContextHtmlPrinter.this.context.getContextURI();
            String contextHref = ContextHtmlPrinter.this.namer.getJsonContextFileName(ContextHtmlPrinter.this.context);
            String rdfTypeHref = null;
            if (ContextHtmlPrinter.this.umlFileManager != null) {
                String path = ContextHtmlPrinter.this.namer.getIndexFileName();
                File sourceFile = ContextHtmlPrinter.this.streamFactory.getOutputFile(path);
                if (sourceFile != null && ContextHtmlPrinter.this.root != null) {
                    rdfTypeHref = ContextHtmlPrinter.this.umlFileManager.getTypeRelativePath(sourceFile, ContextHtmlPrinter.this.root);
                }
            }
            ContextHtmlPrinter.this.indent().print("<TABLE");
            ContextHtmlPrinter.this.printAttr("class", "mediaTypeProperties");
            ContextHtmlPrinter.this.println(">");
            ContextHtmlPrinter.this.pushIndent();
            ContextHtmlPrinter.this.indent().println("<TR>");
            ContextHtmlPrinter.this.pushIndent();
            ContextHtmlPrinter.this.indent().println("<TH>Media Type</TH>");
            ContextHtmlPrinter.this.indent().print("<TD>").print(mediaType).println("</TD>");
            ContextHtmlPrinter.this.popIndent();
            ContextHtmlPrinter.this.indent().println("</TR>");
            ContextHtmlPrinter.this.indent().println("<TR>");
            ContextHtmlPrinter.this.pushIndent();
            ContextHtmlPrinter.this.indent().println("<TH>RDF Type</TH>");
            ContextHtmlPrinter.this.indent().print("<TD>");
            if (rdfTypeHref == null) {
                ContextHtmlPrinter.this.print(rdfType);
            } else {
                ContextHtmlPrinter.this.print("<a ");
                ContextHtmlPrinter.this.printAttr("href", rdfTypeHref);
                ContextHtmlPrinter.this.print(">");
                ContextHtmlPrinter.this.print(rdfType);
                ContextHtmlPrinter.this.print("</a>");
            }
            ContextHtmlPrinter.this.println("</TD>");
            ContextHtmlPrinter.this.popIndent();
            ContextHtmlPrinter.this.indent().println("</TR>");
            ContextHtmlPrinter.this.indent().println("<TR>");
            ContextHtmlPrinter.this.pushIndent();
            ContextHtmlPrinter.this.indent().println("<TH>JSON-LD</TH>");
            ContextHtmlPrinter.this.indent().print("<TD>");
            ContextHtmlPrinter.this.print("<A");
            ContextHtmlPrinter.this.printAttr("HREF", contextHref);
            ContextHtmlPrinter.this.print(">").print(contextURI).println("</A></TD>");
            ContextHtmlPrinter.this.popIndent();
            ContextHtmlPrinter.this.indent().println("</TR>");
            ContextHtmlPrinter.this.popIndent();
            ContextHtmlPrinter.this.indent().println("</TABLE>");
            ContextHtmlPrinter.this.indent().println("<p></p>");
        }
    }
}

