/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.view;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semantictools.context.renderer.model.BibliographicReference;
import org.semantictools.context.renderer.model.DocumentMetadata;
import org.semantictools.context.renderer.model.Person;
import org.semantictools.context.renderer.model.ReferenceManager;
import org.semantictools.context.view.Caption;
import org.semantictools.context.view.ClassificationPrinter;
import org.semantictools.context.view.DocumentPrinter;
import org.semantictools.context.view.Heading;
import org.semantictools.context.view.Level;
import org.semantictools.context.view.PrintContext;
import org.semantictools.context.view.PrintEngine;
import org.semantictools.frame.api.LinkManager;

public class DefaultDocumentPrinter
extends PrintEngine
implements DocumentPrinter {
    protected static final String TOC_MARKER = "<!-- TOC -->";
    protected DocumentMetadata metadata;
    private ClassificationPrinter classificationPrinter;
    private CaptionManager captionManager;
    private Set<Caption> forwardReferenceList;
    private StringWriter body;
    private Heading topHeading;
    private Heading currentHeading;
    private int h2;
    private int h3;
    private int figureNumber;
    private int tableNumber;

    public DefaultDocumentPrinter() {
        this(null);
    }

    public DefaultDocumentPrinter(PrintContext context) {
        super(context);
        this.clear();
    }

    @Override
    public void clear() {
        this.currentHeading = this.topHeading = new Heading(Level.H1, "", "");
        this.body = new StringWriter();
        if (this.context == null) {
            this.context = new PrintContext();
        }
        this.context.setWriter(new PrintWriter(this.body));
        this.forwardReferenceList = new HashSet<Caption>();
        this.captionManager = new CaptionManager();
    }

    public ClassificationPrinter getClassificationPrinter() {
        return this.classificationPrinter;
    }

    @Override
    public void setClassificationPrinter(ClassificationPrinter classificationPrinter) {
        this.classificationPrinter = classificationPrinter;
    }

    @Override
    public PrintContext getPrintContext() {
        return this.context;
    }

    @Override
    public void setPrintContext(PrintContext context) {
        this.context = context;
    }

    @Override
    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void printTitlePage() {
        this.printStatus();
        this.printLogo();
        this.printTitle();
        this.printSubtitle();
        this.printClassifiers();
        this.printDateIssued();
        this.printLatestVersion();
        this.printVersionHistory();
        this.printTitlePageEditors();
        this.printTitlePageAuthors();
        this.printLegalNotice();
        this.indent().println("<HR/>");
    }

    protected void printStatus() {
        String status = this.metadata.getStatus();
        if (status == null) {
            return;
        }
        this.print("<div ");
        this.printAttr("class", "status");
        this.print(">");
        this.print(status);
        this.println("</div>");
    }

    protected void printTitlePageAuthors() {
        this.printAuthors();
    }

    protected void printAuthors() {
        List<Person> authorList = this.metadata.getAuthors();
        if (authorList != null && !authorList.isEmpty()) {
            this.indent().print("<DIV");
            this.printAttr("class", "contributorLabel");
            this.println(">Authors</DIV>");
            for (Person author : authorList) {
                this.indent().print("<DIV");
                this.printAttr("class", "contributor");
                this.print(">").print(author.getPersonName());
                if (author.getOrgName() != null) {
                    this.print(", ").print(author.getOrgName());
                }
                this.println("</DIV>");
            }
        }
    }

    protected void printTitlePageEditors() {
        this.printEditors();
    }

    protected void printEditors() {
        List<Person> editorList = this.metadata.getEditors();
        if (editorList != null && !editorList.isEmpty()) {
            this.indent().print("<DIV");
            this.printAttr("class", "contributorLabel");
            this.println(">Editors</DIV>");
            for (Person editor : editorList) {
                this.indent().print("<DIV");
                this.printAttr("class", "contributor");
                this.print(">").print(editor.getPersonName());
                if (editor.getOrgName() != null) {
                    this.print(", ").print(editor.getOrgName());
                }
                this.println("</DIV>");
            }
        }
    }

    protected void printVersionHistory() {
        Boolean historyLink = this.metadata.hasHistoryLink();
        if (historyLink != null && historyLink.booleanValue()) {
            this.indent().print("<DIV");
            this.printAttr("class", "contributorLabel");
            this.println(">See Also: <a href=\"index.html?history\">Version History</a></DIV>");
        }
    }

    protected void printClassifiers() {
        if (this.classificationPrinter != null) {
            this.classificationPrinter.printClassifiers();
        }
    }

    protected void printLegalNotice() {
        String legalNotice = this.metadata.getLegalNotice();
        if (legalNotice != null) {
            this.print(legalNotice);
        }
    }

    protected void printLatestVersion() {
        String latestVersionURI = this.metadata.getLatestVersionURI();
        if (latestVersionURI == null) {
            return;
        }
        this.indent().print("<div class=\"titlePageData\">Latest version: ");
        this.print("<a");
        this.printAttr("href", latestVersionURI);
        this.print(">");
        this.print(latestVersionURI);
        this.println("</a></div>");
    }

    protected void printDateIssued() {
        if (this.metadata.getSubtitle() != null) {
            String date = this.metadata.getDate();
            if (date == null) {
                return;
            }
            this.indent().print("<div class=\"titlePageData\">Date Issued: ").print(date);
            this.println("</div>");
        }
    }

    protected void printLogo() {
        String logo = this.metadata.getLogo();
        if (logo == null) {
            return;
        }
        this.print("<p><img ");
        this.printAttr("src", logo);
        this.println("></p>");
    }

    protected void printSubtitle() {
        String subtitle = this.metadata.getSubtitle();
        if (subtitle == null) {
            String status = this.metadata.getStatus();
            String date = this.metadata.getDate();
            String string = status != null && date != null ? status + " " + date : (status != null ? status : (subtitle = date != null ? date : null));
        }
        if (subtitle != null) {
            this.indent().print("<DIV");
            this.printAttr("class", "subtitle");
            this.print(">").print(subtitle).print("</DIV>");
        }
    }

    protected void printTitle() {
        String title = this.metadata.getTitle();
        this.indent().print("<H1>");
        this.print(title);
        this.println("</H1>");
    }

    @Override
    public void printFooter() {
        String footer = this.metadata.getFooter();
        if (footer == null) {
            return;
        }
        this.print(footer);
    }

    @Override
    public Heading createHeading(String text) {
        text = text.trim();
        if (this.currentHeading == null) {
            this.currentHeading = new Heading(Level.H1, text, text.replace(' ', '_'));
            return this.currentHeading;
        }
        Level level = this.currentHeading.getLevel().getNextLevel();
        Heading result = new Heading(level, text, text.replace(' ', '_'));
        this.currentHeading.add(result);
        return result;
    }

    @Override
    public void print(Heading heading) {
        boolean showNumber = heading.isShowNumber();
        Level level = heading.getLevel();
        String className = heading.getClassName();
        String number = null;
        switch (level) {
            case H2: {
                ++this.h2;
                number = this.h2 + ".";
                break;
            }
            case H3: {
                ++this.h3;
                number = this.h2 + "." + this.h3;
            }
        }
        heading.setHeadingNumber(number);
        this.indent().print("<" + (Object)((Object)level));
        this.printAttr("id", heading.getHeadingId());
        if (className != null) {
            this.printAttr("class", className);
        }
        this.print(">");
        if (showNumber) {
            this.print(number);
            this.print(" ");
        }
        this.print(heading.getHeadingText());
        this.println("</" + (Object)((Object)level) + ">");
    }

    @Override
    public void beginSection(Heading heading) {
        this.print(heading);
        this.currentHeading = heading;
    }

    @Override
    public void endSection() {
        switch (this.currentHeading.getLevel()) {
            case H2: {
                this.h3 = 0;
                break;
            }
            case H1: {
                this.h2 = 0;
            }
        }
        this.currentHeading = this.currentHeading.getParent();
    }

    @Override
    public void printTableOfContentsMarker() {
        this.println(TOC_MARKER);
    }

    protected void printHeadings(List<Heading> toc) {
        if (toc == null) {
            return;
        }
        this.indent().print("<UL");
        this.printAttr("class", "toc");
        this.println(">");
        this.pushIndent();
        for (Heading heading : toc) {
            if (!heading.isInToc()) continue;
            String number = heading.getHeadingNumber();
            String text = heading.getHeadingText();
            String href = "#" + heading.getHeadingId();
            this.indent().print("<LI");
            this.printAttr("class", "tocline");
            this.print(">");
            if (heading.isShowNumber()) {
                this.print("<span");
                this.printAttr("class", "secno");
                this.print(">");
                this.print(number);
                this.print("</span>");
            }
            this.print(" <a");
            this.printAttr("href", href);
            this.print(">").print(text).print("</a>");
            this.println("</LI>");
            this.printHeadings(heading.getChildren());
        }
        this.popIndent();
        this.println("</UL>");
    }

    @Override
    public void printReferences() {
        ReferenceManager manager = this.metadata.getReferenceManager();
        if (manager == null) {
            return;
        }
        String text = this.popText();
        ArrayList<BibliographicReference> targetList = new ArrayList<BibliographicReference>();
        List<BibliographicReference> list = manager.listReferences();
        for (BibliographicReference ref : list) {
            String htmlLabel = ref.htmlLabel();
            String textLabel = ref.textLabel();
            if (!text.contains(htmlLabel) && !text.contains(textLabel)) continue;
            targetList.add(ref);
        }
        if (targetList.isEmpty()) {
            this.print(text);
            return;
        }
        this.linkToBibliography(targetList, text);
        Heading heading = this.createHeading("References");
        this.print(heading);
        this.indent().print("<DL");
        this.printAttr("class", "references");
        this.println(">");
        File thisFile = this.metadata.getLocalFile();
        LinkManager linkManager = thisFile == null ? null : new LinkManager(thisFile);
        for (BibliographicReference r : targetList) {
            File otherFile = r.getLocalFile();
            if (otherFile != null && thisFile != null) {
                String uri = linkManager.relativize(otherFile);
                r.setUri(uri);
            }
            String html = r.htmlText();
            this.indent().print("<DT>");
            this.printReferenceAnchor(r).println("</DT>");
            this.indent().print("<DD>").print(html).println("</DD>");
        }
    }

    private DefaultDocumentPrinter printReferenceAnchor(BibliographicReference r) {
        String id = r.getId();
        String label = r.htmlLabel();
        this.print("<a id=\"");
        this.print(id);
        this.print("\">");
        this.print(label);
        this.print("</a>");
        return this;
    }

    private void linkToBibliography(List<BibliographicReference> list, String text) {
        for (BibliographicReference ref : list) {
            String id = ref.getId();
            String htmlLabel = ref.htmlLabel();
            String textLabel = ref.textLabel();
            String link = this.citationLink(htmlLabel, id);
            text = text.replace(htmlLabel, link);
            if (textLabel.equals(htmlLabel)) continue;
            text = text.replace(textLabel, link);
        }
        this.print(text);
    }

    private String citationLink(String label, String id) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href=\"#");
        builder.append(id);
        builder.append("\">");
        builder.append(label);
        builder.append("</a>");
        return builder.toString();
    }

    @Override
    public String getText() {
        this.body.flush();
        String text = this.body.toString();
        text = this.updateReferences(text);
        this.body.getBuffer().setLength(0);
        this.indent().println("<H2>Table of Contents</H2>");
        this.printHeadings(this.topHeading.getChildren());
        String toc = this.body.toString();
        return text.replace(TOC_MARKER, toc);
    }

    @Override
    public String popText() {
        String text = this.body.toString();
        this.body.getBuffer().setLength(0);
        return text;
    }

    @Override
    public void insertTableOfContents() {
        this.body.flush();
        String text = this.popText();
        text = this.updateReferences(text);
        this.indent().println("<H2>Table of Contents</H2>");
        this.printHeadings(this.topHeading.getChildren());
        String toc = this.popText();
        this.print(text.replace(TOC_MARKER, toc));
    }

    private String updateReferences(String text) {
        for (Caption caption : this.forwardReferenceList) {
            String ref = this.createForwardRef(caption);
            text = text.replace(ref, this.createLink(caption));
        }
        return text;
    }

    private String createForwardRef(Caption caption) {
        return "<!-- REF:" + caption.getId() + " -->";
    }

    @Override
    public void printForwardRef(Caption caption) {
        this.print(this.createForwardRef(caption));
        this.forwardReferenceList.add(caption);
    }

    private String createLink(Caption caption) {
        return "<A href=\"#" + caption.getId() + "\">" + caption.getNumber() + "</A>";
    }

    @Override
    public void printLink(Caption caption) {
        this.print(this.createLink(caption));
    }

    @Override
    public Heading getCurrentHeading() {
        return this.currentHeading;
    }

    @Override
    public void printCaption(Caption caption) {
        this.captionManager.add(caption);
        this.indent().print("<DIV");
        this.printAttr("class", "caption");
        this.println(">");
        this.print(caption.getNumber());
        this.print(".&nbsp&nbsp;");
        this.print(caption.getText());
        this.indent().println("</DIV>");
    }

    @Override
    public void printFigure(String src, Caption caption) {
        this.indent().print("<DIV");
        this.printAttr("class", "figure");
        if (caption != null) {
            this.printAttr("id", caption.getId());
        }
        this.println(">");
        this.pushIndent();
        this.indent().print("<IMG");
        this.printAttr("src", src);
        this.println("/>");
        if (caption != null) {
            this.printCaption(caption);
        }
        this.popIndent();
        this.indent().println("</DIV>");
    }

    @Override
    public void assignNumber(Caption caption) {
        String number = null;
        switch (caption.getType()) {
            case Figure: {
                ++this.figureNumber;
                number = "Figure " + this.figureNumber;
                break;
            }
            case Table: {
                ++this.tableNumber;
                number = "Table " + this.tableNumber;
            }
        }
        caption.setNumber(number);
    }

    @Override
    public void beginTable(String className) {
        this.indent().print("<TABLE");
        this.printAttr("class", className);
        this.println(">");
        this.pushIndent();
    }

    @Override
    public void endTable() {
        this.popIndent();
        this.indent().println("</TABLE>");
    }

    @Override
    public void beginRow() {
        this.indent().println("<TR>");
        this.pushIndent();
    }

    @Override
    public void endRow() {
        this.popIndent();
        this.indent().println("</TR>");
    }

    @Override
    public void printTH(String value) {
        this.indent().print("<TH>").print(value).println("</TH>");
    }

    @Override
    public void printTD(String className, String text) {
        this.indent().print("<TD class=\"").print(className).print("\">").print(text).println("</TD>");
    }

    @Override
    public void printTD(String value) {
        this.indent().print("<TD>").print(value).println("</TD>");
    }

    @Override
    public void printAnchor(String href, String text) {
        this.print("<A href=\"").print(href).print("\">").print(text).print("</A>");
    }

    @Override
    public void beginDiv(String className) {
        this.indent().print("<DIV class=\"").print(className).println("\">");
        this.pushIndent();
    }

    @Override
    public void beginDiv(String className, String id) {
        this.indent().print("<DIV class=\"").print(className).print("\" id=\"").print(id).println("\">");
        this.pushIndent();
    }

    @Override
    public void endDiv() {
        this.popIndent();
        this.indent().println("</DIV>");
    }

    @Override
    public void beginCodeSnippet() {
        this.indent().print("<DIV");
        this.printAttr("class", "code-snippet");
        this.println(">");
        this.println("<PRE>");
    }

    @Override
    public void endCodeSnippet() {
        this.println("</PRE>");
        this.indent().println("</DIV>");
    }

    @Override
    public void printDefinition(String termName, String description) {
        this.indent().print("<DT>").print(termName).println("</DT>");
        this.pushIndent();
        this.indent().print("<DD>").print(description).println("</DD>");
        this.popIndent();
    }

    @Override
    public void printParagraph(String text) {
        this.indent().print("<P>").print(text).println("</P>");
    }

    @Override
    public void beginParagraph() {
        this.indent().print("<P>");
    }

    @Override
    public void endParagraph() {
        this.println("</P>");
    }

    @Override
    public void printListItem(String text) {
        this.indent().print("<LI>").print(text).println("</LI>");
    }

    @Override
    public void beginHTML() {
        this.println("<HTML>");
        this.println("<HEAD>");
        this.pushIndent();
        this.printStyleSheetLink();
        this.popIndent();
        this.println("</HEAD>");
        this.println("<BODY>");
    }

    @Override
    public void endHTML() {
        this.println("</BODY>");
        this.println("</HTML>");
    }

    protected void printStyleSheetLink() {
        String href = this.metadata.getCss();
        this.indent().print("<LINK");
        this.printAttr("REL", "StyleSheet");
        this.printAttr("HREF", href);
        this.printAttr("TYPE", "text/css");
        this.println(">");
    }

    @Override
    public Heading createHeading(String text, String id) {
        text = text.trim();
        Level level = this.currentHeading.getLevel().getNextLevel();
        Heading result = new Heading(level, text, id);
        this.currentHeading.add(result);
        return result;
    }

    static class CaptionManager {
        Map<String, Caption> uri2FigureCaption = new HashMap<String, Caption>();

        CaptionManager() {
        }

        public void add(Caption caption) {
            if (caption.getUri() == null) {
                return;
            }
            switch (caption.getType()) {
                case Figure: {
                    this.uri2FigureCaption.put(caption.getUri(), caption);
                }
            }
        }

        public Caption getFigureCaptionByURI(String uri) {
            return this.uri2FigureCaption.get(uri);
        }
    }
}

