/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Set;
import org.semantictools.context.renderer.URLRewriter;
import org.semantictools.context.view.Caption;
import org.semantictools.context.view.Heading;
import org.semantictools.context.view.Level;
import org.semantictools.context.view.PrintContext;
import org.semantictools.context.view.PrintEngine;

public abstract class HtmlPrinter
extends PrintEngine {
    private static final String TOC_MARKER = "<!-- TOC -->";
    private static final String VOWEL = "aeiou";
    private StringWriter body;
    private Heading topHeading;
    private Heading currentHeading;
    private int h2;
    private int h3;
    private URLRewriter urlRewriter;
    private Set<Caption> forwardReferenceList;

    protected HtmlPrinter(URLRewriter rewriter) {
        super(new PrintContext());
        this.urlRewriter = rewriter;
    }

    protected void setPrintContext(PrintContext context) {
        this.context = context;
    }

    protected HtmlPrinter() {
        this(new URLRewriter(){

            @Override
            public String rewrite(String url) {
                return url;
            }
        });
    }

    protected void init() {
        this.h3 = 0;
        this.h2 = 0;
        this.currentHeading = this.topHeading = new Heading(Level.H1, "", "");
        this.body = new StringWriter();
        this.getPrintContext().setWriter(new PrintWriter(this.body));
    }

    protected String createDefaultReference(String key) {
        return null;
    }

    public static String capitalizedArticle(String text) {
        char c = Character.toLowerCase(text.charAt(0));
        return VOWEL.indexOf(c) >= 0 ? "An" : "A";
    }

    public static String article(String text) {
        char c = Character.toLowerCase(text.charAt(0));
        return VOWEL.indexOf(c) >= 0 ? "an" : "a";
    }

    protected String updateReferences(String text) {
        for (Caption caption : this.forwardReferenceList) {
            String ref = this.createForwardRef(caption);
            text = text.replace(ref, this.createLink(caption));
        }
        return text;
    }

    private String createLink(Caption caption) {
        return "<A href=\"#" + caption.getId() + "\">" + caption.getNumber() + "</A>";
    }

    protected void printLink(Caption caption) {
        this.print(this.createLink(caption));
    }

    protected String createForwardRef(Caption caption) {
        return "<!-- REF:" + caption.getId() + " -->";
    }

    protected void printForwardRef(Caption caption) {
        this.print(this.createForwardRef(caption));
    }

    protected void print(Heading heading) {
        Level level = heading.getLevel();
        String className = heading.getClassName();
        String number = null;
        switch (level) {
            case H2: {
                ++this.h2;
                number = this.h2 + ".";
                break;
            }
            case H3: {
                ++this.h3;
                number = this.h2 + "." + this.h3;
            }
        }
        heading.setHeadingNumber(number);
        this.indent().print("<" + (Object)((Object)level));
        this.printAttr("id", heading.getHeadingId());
        if (className != null) {
            this.printAttr("class", className);
        }
        this.print(">");
        this.print(number);
        this.print(" ");
        this.print(heading.getHeadingText());
        this.println("</" + (Object)((Object)level) + ">");
    }

    protected void beginHeading(Heading heading) {
        this.print(heading);
        this.currentHeading = heading;
    }

    protected void endHeading() {
        this.currentHeading = this.currentHeading.getParent();
    }

    protected String format(String pattern, Object ... args) {
        return MessageFormat.format(pattern, args);
    }
}

