/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.view;

import java.util.List;
import org.semantictools.context.renderer.model.Person;
import org.semantictools.context.view.DefaultDocumentPrinter;
import org.semantictools.context.view.Heading;
import org.semantictools.context.view.PrintContext;

public class IMSDocumentPrinter
extends DefaultDocumentPrinter {
    public IMSDocumentPrinter(PrintContext context) {
        super(context);
    }

    @Override
    protected void printTitlePageEditors() {
    }

    @Override
    protected void printTitlePageAuthors() {
    }

    @Override
    public void printFooter() {
        this.println("<hr/>");
        Heading heading = this.createHeading("About this Document");
        heading.setShowNumber(false);
        this.beginSection(heading);
        String title = this.metadata.getTitle().replace("<br>", " ").replace("<br/>", " ");
        this.indent().println("<table class=\"about\">");
        this.pushIndent();
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Title: ").print("</td><td>").print(title).println("</td>");
        this.indent().println("</tr>");
        this.printCoChairs();
        this.printEditors();
        this.printVersion();
        this.printVersionDate();
        this.printRelease();
        this.printAboutStatus();
        this.printPurpose();
        this.printDocumentLocation();
        this.popIndent();
        this.indent().println("</table>");
        this.printContributors();
        super.printFooter();
        this.endSection();
    }

    private void printContributors() {
        List<Person> list = this.metadata.getAuthors();
        if (list == null || list.isEmpty()) {
            return;
        }
        Heading heading = this.createHeading("List of Contributors");
        heading.setInToc(false);
        heading.setShowNumber(false);
        this.beginSection(heading);
        this.println("<p>The following list of individuals contributed to the authoring of this document:</p>");
        this.println("<table class=\"about\">");
        this.pushIndent();
        int max = list.size() / 2 + list.size() % 2;
        for (int i = 0; i < max; ++i) {
            int j = max + i;
            Person left = list.get(i);
            Person right = j < list.size() ? list.get(j) : null;
            this.indent().println("<tr>");
            this.pushIndent();
            this.indent();
            this.printPersonInTable(left);
            this.printPersonInTable(right);
            this.println();
            this.popIndent();
            this.indent().println("</tr>");
        }
        this.popIndent();
        this.println("</table>");
        this.endSection();
    }

    private void printPersonInTable(Person person) {
        this.print("<td>");
        if (person != null) {
            this.print(person.getPersonName());
        }
        this.print("</td><td>");
        if (person != null && person.getOrgName() != null) {
            this.print(person.getOrgName());
        }
        this.print("</td>");
    }

    private void printDocumentLocation() {
        String location = this.metadata.getDocumentLocation();
        if (location == null) {
            return;
        }
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Document Location: ").print("</td><td>").print(location).println("</td>");
        this.indent().println("</tr>");
    }

    private void printPurpose() {
        String purpose = this.metadata.getPurpose();
        if (purpose == null) {
            return;
        }
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Purpose: ").print("</td><td>").print(purpose).println("</td>");
        this.indent().println("</tr>");
    }

    private void printAboutStatus() {
        String status = this.metadata.getStatus();
        if (status == null) {
            return;
        }
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Status: ").print("</td><td>").print(status).println("</td>");
        this.indent().println("</tr>");
    }

    private void printRelease() {
        String release = this.metadata.getRelease();
        if (release == null) {
            return;
        }
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Release: ").print("</td><td>").print(release).println("</td>");
        this.indent().println("</tr>");
    }

    private void printVersion() {
        String version = this.metadata.getVersion();
        if (version == null) {
            return;
        }
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Version: ").print("</td><td>").print(version).println("</td>");
        this.indent().println("</tr>");
    }

    private void printVersionDate() {
        String date = this.metadata.getDate();
        if (date == null) {
            return;
        }
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Version Date: ").print("</td><td>").print(date).println("</td>");
        this.indent().println("</tr>");
    }

    @Override
    public void printEditors() {
        List<Person> list = this.metadata.getEditors();
        if (list == null || list.isEmpty()) {
            return;
        }
        String label = list.size() > 1 ? "Editors: " : "Editor:";
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print(label).print("</td><td>");
        String comma = "";
        for (Person person : list) {
            this.print(comma);
            comma = ", ";
            this.print(person.getPersonName());
            String orgName = person.getOrgName();
            if (orgName == null) continue;
            this.print(" (").print(orgName).print(")");
        }
        this.println("</td>");
        this.indent().println("</tr>");
    }

    private void printCoChairs() {
        List<Person> list = this.metadata.getCoChairs();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.indent().println("<tr>");
        this.pushIndent().print("<th>").print("Co-chairs: ").print("</td><td>");
        String comma = "";
        for (Person person : list) {
            this.print(comma);
            comma = ", ";
            this.print(person.getPersonName());
            String orgName = person.getOrgName();
            if (orgName == null) continue;
            this.print(" (").print(orgName).print(")");
        }
        this.println("</td>");
        this.indent().println("</tr>");
    }
}

