/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.view;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.semantictools.context.renderer.IndexEntry;
import org.semantictools.context.view.PrintContext;
import org.semantictools.context.view.PrintEngine;

public class MediaTypeIndexPrinter
extends PrintEngine {
    private File outDir;

    public MediaTypeIndexPrinter() {
    }

    public MediaTypeIndexPrinter(PrintContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printIndex(File outfile) throws IOException {
        this.outDir = outfile.getParentFile();
        FileWriter writer = new FileWriter(outfile);
        try {
            this.context = new PrintContext();
            this.context.setFileWriter(writer);
            this.doPrintIndex();
        }
        finally {
            this.close();
        }
    }

    private void doPrintIndex() {
        this.println("<HTML>");
        this.println("<HEAD>");
        this.printStyle();
        this.println("</HEAD>");
        this.println("<BODY>");
        this.pushIndent();
        this.printPageHeading();
        this.printMediaTypeList();
        this.popIndent();
        this.println("</BODY>");
        this.println("</HTML>");
    }

    private void printStyle() {
        this.println("<STYLE>");
        this.pushIndent();
        this.indent().println("BODY {");
        this.indent().println("  margin-left: 3%;");
        this.indent().println("}");
        this.indent().println("H1 {");
        this.pushIndent();
        this.indent().println("font-family: sans-serif;");
        this.indent().println("color: #336699;");
        this.indent().println("font-weight: normal;");
        this.popIndent();
        this.indent().println("}");
        this.popIndent();
        this.println("</STYLE>");
    }

    private void printMediaTypeList() {
        List<IndexEntry> list = this.getMediaTypeList();
        this.indent().print("<UL>");
        this.pushIndent();
        for (IndexEntry entry : list) {
            String name = entry.getName();
            String href = entry.getHref();
            this.indent().print("<LI>");
            this.print("<A");
            this.printAttr("href", href);
            this.print(">");
            this.print(name);
            this.println("</A></LI>");
        }
        this.popIndent();
        this.indent().println("</UL>");
    }

    private void printPageHeading() {
        this.indent().println("<H1>Specifications</H1>");
    }

    private List<IndexEntry> getMediaTypeList() {
        File rootDir = new File(this.outDir, "application");
        ArrayList<IndexEntry> list = new ArrayList<IndexEntry>();
        this.addMediaTypes(list, null, rootDir);
        return list;
    }

    private void addMediaTypes(List<IndexEntry> list, String path, File dir) {
        File indexFile;
        File file = indexFile = path == null ? null : new File(dir, "index.html");
        if (indexFile != null && indexFile.exists()) {
            String mediaType = path + "." + dir.getName();
            String parentPath = mediaType.replace(".", "/");
            String href = parentPath + "/index.html";
            IndexEntry entry = new IndexEntry(mediaType + " Media Type", href);
            list.add(entry);
            File parentDir = indexFile.getParentFile();
            File serviceFile = new File(parentDir, "service.html");
            if (serviceFile.exists()) {
                entry = new IndexEntry(mediaType + " REST API", parentPath + "/service.html");
                list.add(entry);
            }
        } else {
            File[] kids = dir.listFiles();
            if (kids == null) {
                return;
            }
            path = path == null ? dir.getName() + "/" : (path.endsWith("/") ? path + dir.getName() : path + "." + dir.getName());
            for (int i = 0; i < kids.length; ++i) {
                if (!kids[i].isDirectory()) continue;
                this.addMediaTypes(list, path, kids[i]);
            }
        }
    }
}

