/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.view;

import java.io.PrintWriter;
import org.semantictools.context.view.PrintContext;

public class PrintEngine {
    protected PrintContext context;

    public PrintEngine() {
    }

    public PrintEngine(PrintContext context) {
        this.context = context;
    }

    protected void setWriter(PrintWriter writer) {
        this.context.setWriter(writer);
    }

    protected PrintWriter getWriter() {
        return this.context.getWriter();
    }

    protected PrintContext getPrintContext() {
        return this.context;
    }

    protected PrintEngine print(String s) {
        this.context.getWriter().print(s);
        return this;
    }

    protected void printAttr(String name, String value) {
        this.print(" ");
        this.print(name);
        this.print("=\"");
        this.print(value);
        this.print("\"");
    }

    protected void print(int n) {
        this.context.getWriter().print(n);
    }

    protected void println() {
        this.context.getWriter().println();
    }

    protected void println(String s) {
        this.context.getWriter().println(s);
    }

    protected PrintEngine pushIndent() {
        this.context.pushIndent();
        return this;
    }

    protected PrintEngine popIndent() {
        this.context.popIndent();
        return this;
    }

    protected PrintEngine indent() {
        int indent = this.context.getIndent();
        for (int i = 0; i < 2 * indent; ++i) {
            this.context.getWriter().print(' ');
        }
        return this;
    }

    protected void flush() {
        this.context.getWriter().flush();
    }

    protected void close() {
        PrintWriter writer = this.context.getWriter();
        writer.flush();
        if (this.context.isFileWriter()) {
            writer.close();
        }
        this.context.setWriter(null);
    }
}

