/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.view;

import java.util.List;
import org.semantictools.context.renderer.URLRewriter;
import org.semantictools.context.renderer.model.HttpHeaderInfo;
import org.semantictools.context.renderer.model.HttpMethod;
import org.semantictools.context.renderer.model.MethodDocumentation;
import org.semantictools.context.renderer.model.QueryParam;
import org.semantictools.context.renderer.model.ResponseInfo;
import org.semantictools.context.renderer.model.ServiceDocumentation;
import org.semantictools.context.view.Caption;
import org.semantictools.context.view.CaptionType;
import org.semantictools.context.view.DocumentPrinter;
import org.semantictools.context.view.DocumentPrinterFactory;
import org.semantictools.context.view.Heading;
import org.semantictools.context.view.HtmlPrinter;

public class ServiceDocumentationPrinter
extends HtmlPrinter {
    private ServiceDocumentation doc;
    private DocumentPrinter printer;

    public ServiceDocumentationPrinter(URLRewriter rewriter) {
        super(rewriter);
    }

    public String print(ServiceDocumentation doc) {
        this.doc = doc;
        this.init();
        String templateName = doc.getTemplateName();
        this.printer = DocumentPrinterFactory.getDefaultFactory().createPrinter(templateName);
        this.printer.setMetadata(doc);
        this.setPrintContext(this.printer.getPrintContext());
        this.printer.beginHTML();
        this.printStatus();
        this.printer.printTitlePage();
        this.printAbstract();
        this.printer.printTableOfContentsMarker();
        this.printIntroduction();
        this.printRepresentation();
        this.printUrlTemplates();
        this.printServiceMethods();
        this.printer.printReferences();
        this.printer.printFooter();
        this.printer.endHTML();
        this.printer.insertTableOfContents();
        return this.printer.popText();
    }

    private void printStatus() {
        String status = this.doc.getStatus();
        if (status == null) {
            return;
        }
        this.print("<div ");
        this.printAttr("class", "status");
        this.print(">");
        this.print(status);
        this.println("</div>");
    }

    private void printUrlTemplates() {
        String text = this.doc.getUrlTemplateText();
        if (text == null) {
            return;
        }
        Heading heading = this.printer.createHeading("URL Templates");
        this.beginHeading(heading);
        this.print(text);
        this.endHeading();
    }

    private void printServiceMethods() {
        Heading heading = this.printer.createHeading("Service Methods");
        this.beginHeading(heading);
        this.printPostMethod();
        this.printGetMethod();
        this.printPutMethod();
        this.printDeleteMethod();
        this.endHeading();
    }

    private void printGetMethod() {
        if (!this.doc.contains(HttpMethod.GET)) {
            return;
        }
        Heading heading = this.printer.createHeading("GET");
        this.print(heading);
        MethodDocumentation method = this.doc.getGetDocumentation();
        this.print(method.getSummary());
        this.indent().print("<UL>");
        this.pushIndent();
        List<HttpHeaderInfo> requestHeaders = method.getRequestHeaders();
        Caption requestHeadersCaption = null;
        Caption queryParamsCaption = null;
        List<QueryParam> paramList = this.doc.getQueryParams();
        if (!paramList.isEmpty()) {
            queryParamsCaption = new Caption(CaptionType.Table, "Query Parameters", "queryParams", null);
            this.printer.assignNumber(queryParamsCaption);
            this.indent().print("<LI>The request may contain the query parameters specified in ");
            this.printLink(queryParamsCaption);
            this.println(".</LI>");
        }
        if (!requestHeaders.isEmpty()) {
            requestHeadersCaption = new Caption(CaptionType.Table, "Required HTTP Headers for GET Request", "getHeader", null);
            this.printer.assignNumber(requestHeadersCaption);
            this.indent().print("<LI>The request must contain the HTTP headers as specified in ");
            this.printer.printLink(requestHeadersCaption);
            this.println(".</LI>");
        }
        this.printer.printListItem(method.getRequestBodyRequirement());
        this.popIndent();
        this.indent().println("</UL>");
        if (!paramList.isEmpty()) {
            this.printer.printParagraph("&nbsp;");
            this.printQueryParams(paramList, queryParamsCaption);
        }
        this.printer.printParagraph("&nbsp;");
        this.printRequestHeaders(method, requestHeadersCaption);
        this.printer.beginParagraph();
        this.printer.printParagraph("&nbsp;");
        this.printResponse(method, "GET");
    }

    private void printPutMethod() {
        if (!this.doc.contains(HttpMethod.PUT)) {
            return;
        }
        Heading heading = this.printer.createHeading("PUT");
        this.print(heading);
        MethodDocumentation method = this.doc.getPutDocumentation();
        this.print(method.getSummary());
        this.indent().print("<UL>");
        this.pushIndent();
        List<HttpHeaderInfo> requestHeaders = method.getRequestHeaders();
        Caption requestHeadersCaption = null;
        List<String> ruleList = this.doc.getPutRules();
        if (!ruleList.isEmpty()) {
            for (String rule : ruleList) {
                this.indent().print("<LI>").print(rule).println("</LI>");
            }
        }
        if (!requestHeaders.isEmpty()) {
            requestHeadersCaption = new Caption(CaptionType.Table, "Required HTTP Headers for PUT Request", "getHeader", null);
            this.printer.assignNumber(requestHeadersCaption);
            this.indent().print("<LI>The request must contain the HTTP Headers listed in ");
            this.printLink(requestHeadersCaption);
            this.println(".</LI>");
        }
        this.printer.printListItem(method.getRequestBodyRequirement());
        this.popIndent();
        this.indent().println("</UL>");
        this.printer.printParagraph("&nbsp;");
        this.printRequestHeaders(method, requestHeadersCaption);
        this.printer.beginParagraph();
        this.printer.printParagraph("&nbsp;");
        String pattern = " describes the possible responses from the {0} method.  In all cases, the response body is empty.";
        this.printResponse(method, pattern, "PUT");
    }

    private void printDeleteMethod() {
        if (!this.doc.contains(HttpMethod.DELETE)) {
            return;
        }
        Heading heading = this.printer.createHeading("DELETE");
        this.print(heading);
        MethodDocumentation method = this.doc.getDeleteDocumentation();
        this.print(method.getSummary());
        this.indent().print("<UL>");
        this.pushIndent();
        List<HttpHeaderInfo> requestHeaders = method.getRequestHeaders();
        Caption requestHeadersCaption = null;
        if (!requestHeaders.isEmpty()) {
            requestHeadersCaption = new Caption(CaptionType.Table, "Required HTTP Headers for DELETE Request", "getHeader", null);
            this.printer.assignNumber(requestHeadersCaption);
            this.indent().print("<LI>The request must contain the HTTP Headers listed in ");
            this.printLink(requestHeadersCaption);
            this.println(".</LI>");
        }
        this.printer.printListItem(method.getRequestBodyRequirement());
        this.popIndent();
        this.indent().println("</UL>");
        this.printer.printParagraph("&nbsp;");
        this.printRequestHeaders(method, requestHeadersCaption);
        this.printer.beginParagraph();
        this.printer.printParagraph("&nbsp;");
        String pattern = " describes the possible responses from the {0} method.  In all cases, the response body is empty.";
        this.printResponse(method, pattern, "DELETE");
    }

    private void printResponse(MethodDocumentation method, String methodName) {
        String pattern = " describes the possible responses from the {0} method.";
        this.printResponse(method, pattern, methodName);
    }

    private void printResponse(MethodDocumentation method, String pattern, String methodName) {
        Caption responseCaption = new Caption(CaptionType.Table, this.format("Possible responses from a {0} method", methodName), "postResponse", null);
        this.printer.assignNumber(responseCaption);
        this.printLink(responseCaption);
        this.print(this.format(pattern, methodName));
        this.printer.endParagraph();
        this.printer.beginTable("propertiesTable");
        this.printer.beginRow();
        this.printer.printTH("HTTP Status");
        this.printer.printTH("Description");
        this.printer.endRow();
        for (ResponseInfo code : method.getStatusCodes()) {
            this.printer.beginRow();
            this.printer.printTD(code.getStatusCode() + "&nbsp;" + code.getLabel().replace(" ", "&nbsp;"));
            this.printer.printTD(code.getDescription());
            this.printer.endRow();
        }
        this.printer.endTable();
        this.printer.printCaption(responseCaption);
    }

    private void printPostMethod() {
        if (!this.doc.contains(HttpMethod.POST)) {
            return;
        }
        Heading heading = this.printer.createHeading("POST");
        this.print(heading);
        MethodDocumentation method = this.doc.getPostDocumentation();
        this.print(method.getSummary());
        this.indent().print("<UL>");
        this.pushIndent();
        List<HttpHeaderInfo> requestHeaders = method.getRequestHeaders();
        Caption requestHeadersCaption = null;
        if (!requestHeaders.isEmpty()) {
            requestHeadersCaption = new Caption(CaptionType.Table, "Required HTTP Headers for POST Request", "postHeader", null);
            this.printer.assignNumber(requestHeadersCaption);
            this.indent().print("<LI>The request must contain the HTTP Headers listed in ");
            this.printLink(requestHeadersCaption);
            this.println(".</LI>");
        }
        this.printer.printListItem(method.getRequestBodyRequirement());
        this.popIndent();
        this.indent().println("</UL>");
        this.printer.printParagraph("&nbsp;");
        this.printRequestHeaders(method, requestHeadersCaption);
        this.printer.printParagraph("&nbsp;");
        this.printResponse(method, "POST");
        String rules = this.doc.getPostProcessingRules();
        if (rules != null) {
            this.print(rules);
        }
    }

    private void printQueryParams(List<QueryParam> paramList, Caption caption) {
        this.indent().print("<TABLE");
        this.printAttr("class", "propertiesTable");
        this.println(">");
        this.pushIndent();
        this.indent().println("<TR>");
        this.pushIndent();
        this.indent().println("<TH>Parameter</TH><TH>Description</TH>");
        this.popIndent();
        this.indent().println("</TR>");
        for (QueryParam param : paramList) {
            this.indent().println("<TR>");
            this.pushIndent();
            this.indent().print("<TD>");
            this.print(param.getName());
            this.print("</TD><TD>");
            this.print(param.getDescription());
            this.println("</TD>");
            this.popIndent();
            this.indent().println("</TR>");
        }
        this.popIndent();
        this.indent().println("</TABLE>");
        this.printer.printCaption(caption);
    }

    private void printRequestHeaders(MethodDocumentation method, Caption caption) {
        List<HttpHeaderInfo> requestHeaders = method.getRequestHeaders();
        if (!requestHeaders.isEmpty()) {
            this.indent().print("<TABLE");
            this.printAttr("class", "propertiesTable");
            this.println(">");
            this.pushIndent();
            this.indent().println("<TR>");
            this.pushIndent();
            this.indent().println("<TH>Request Header Name</TH><TH>Value</TH>");
            this.popIndent();
            this.indent().println("</TR>");
            for (HttpHeaderInfo header : requestHeaders) {
                this.indent().println("<TR>");
                this.pushIndent();
                this.indent().print("<TD>");
                this.print(header.getHeaderName());
                this.print("</TD><TD>");
                this.print(header.getHeaderValue());
                this.println("</TD>");
                this.popIndent();
                this.indent().println("</TR>");
            }
            this.popIndent();
            this.indent().println("</TABLE>");
            this.printer.printCaption(caption);
        }
    }

    private void printRepresentation() {
        Heading heading = this.printer.createHeading(this.doc.getRepresentationHeading());
        this.print(heading);
        this.print(this.doc.getRepresentationText());
        String htmlFormat = this.doc.getHtmlFormatDocumentation();
        if (htmlFormat != null) {
            this.print(htmlFormat);
        }
    }

    private void printIntroduction() {
        Heading heading = this.printer.createHeading("Introduction");
        this.print(heading);
        this.print(this.doc.getIntroduction());
    }

    private void printAbstract() {
        String abstractText = this.doc.getAbstactText();
        if (abstractText == null) {
            return;
        }
        this.indent().println("<H2>Abstract</H2>");
        this.indent().println("<DIV>");
        this.print(abstractText);
        this.println("</DIV>");
    }
}

