/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semantictools.context.renderer.model.Container;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.FrameConstraints;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.context.renderer.model.TermInfo;
import org.semantictools.context.renderer.model.TermValue;
import org.semantictools.frame.api.DublinCoreElements;
import org.semantictools.frame.api.FrameNotFoundException;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.BindVocabulary;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.DublinCoreTerms;
import org.semantictools.frame.model.Enumeration;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.NamedIndividual;
import org.semantictools.frame.model.OntologyInfo;
import org.semantictools.frame.model.RdfType;
import org.semantictools.frame.model.RestCategory;
import org.semantictools.frame.model.VannVocabulary;

public class ContextBuilder {
    private OntModel model;
    private TypeManager typeManager;
    private OntProperty suggestedPrefix;
    private Set<String> history;

    public ContextBuilder(TypeManager typeManager) {
        this.model = typeManager.getOntModel();
        this.typeManager = typeManager;
        this.suggestedPrefix = this.model.getOntProperty("http://purl.org/semantictools/v1/vocab/bind#suggestedPrefix");
    }

    public JsonContext createContext(ContextProperties properties) {
        this.history = new HashSet<String>();
        JsonContext context = new JsonContext();
        context.setContextURI(properties.getContextURI());
        context.setMediaType(properties.getMediaType());
        context.setRootType(properties.getRdfTypeURI());
        String typeURI = properties.getRdfTypeURI();
        if (typeURI == null) {
            return null;
        }
        this.addGraphTypes(context, properties);
        Frame frame = this.typeManager.getFrameByUri(typeURI);
        if (frame == null) {
            throw new FrameNotFoundException(typeURI);
        }
        this.addType(properties, context, frame, false);
        context.expand();
        context.invertRewriteRules();
        this.updateFrameConstraints(properties, context);
        return context;
    }

    private void addGraphTypes(JsonContext context, ContextProperties properties) {
        List<String> graphTypes = properties.getGraphTypes();
        if (!graphTypes.isEmpty()) {
            for (String uri : graphTypes) {
                Frame frame = this.typeManager.getFrameByUri(uri);
                if (frame == null) {
                    throw new FrameNotFoundException(uri);
                }
                this.addType(properties, context, frame, false);
            }
        }
    }

    private void updateFrameConstraints(ContextProperties properties, JsonContext context) {
        List<FrameConstraints> list = properties.listFrameConstraints();
        for (FrameConstraints c : list) {
            String name = c.getClassURI();
            TermInfo term = context.getTermInfoByShortName(name);
            if (term == null) continue;
            String uri = term.getIri();
            uri = context.rewrite(uri);
            c.setClassURI(uri);
            properties.addFrameConstraints(c);
        }
    }

    private boolean isStandard(String uri) {
        return uri != null && uri.startsWith("http://www.w3.org/2001/XMLSchema#");
    }

    private void addType(ContextProperties properties, JsonContext context, RdfType rdfType, boolean stubbed) {
        String iri;
        String typeURI = rdfType.getUri();
        if (properties.getExcludedTypes().contains(typeURI)) {
            return;
        }
        if (rdfType.canAsListType() && this.embedListMembers(properties)) {
            this.addType(properties, context, rdfType.asListType().getElementType(), stubbed);
        }
        if (this.isStandard(typeURI)) {
            return;
        }
        String localName = rdfType.getLocalName();
        String prefix = this.getPrefix(context, rdfType.getNamespace());
        String string = iri = prefix == null ? typeURI : prefix + ":" + localName;
        if (!context.containsTerm(localName)) {
            context.add(localName, iri).setCategory(TermInfo.TermCategory.TYPE);
        }
        if (stubbed || this.history.contains(typeURI)) {
            return;
        }
        Frame frame = this.typeManager.getFrameByUri(typeURI);
        if (frame == null) {
            Datatype datatype = this.typeManager.getDatatypeByUri(typeURI);
            if (datatype == null) {
                throw new FrameNotFoundException(typeURI);
            }
            return;
        }
        this.history.add(typeURI);
        List<Field> fieldList = frame.listAllFields();
        for (Field field : fieldList) {
            this.addField(properties, context, field, frame);
        }
        this.addSubtypes(properties, context, frame);
    }

    private boolean embedListMembers(ContextProperties properties) {
        properties.isIdRef("http://www.w3.org/2000/01/rdf-schema#member");
        return false;
    }

    private void addSubtypes(ContextProperties properties, JsonContext context, Frame frame) {
        FrameConstraints c = properties.getFrameConstraints(frame.getLocalName());
        List<Frame> list = frame.listAllSubtypes();
        for (Frame sub : list) {
            if (c != null) {
                FrameConstraints cc = properties.getFrameConstraints(sub.getLocalName());
                if (cc == null) {
                    cc = new FrameConstraints(sub.getLocalName());
                    properties.addFrameConstraints(cc);
                }
                cc.copyAll(c);
            }
            this.addType(properties, context, sub, false);
        }
    }

    private void addField(ContextProperties properties, JsonContext context, Field field, Frame declaringFrame) {
        OntProperty property = field.getProperty();
        if (!this.isIncluded(field, properties, declaringFrame)) {
            return;
        }
        String localName = property.getLocalName();
        String propertyURI = property.getURI();
        String iriValue = this.iriRef(context, property.getNameSpace(), property.getLocalName(), propertyURI);
        TermInfo info = new TermInfo(localName);
        info.setCategory(TermInfo.TermCategory.PROPERTY);
        RdfType rdfType = field.getRdfType();
        TermValue value = null;
        if (rdfType == null) {
            throw new RuntimeException("RDF type not defined for property: " + field.getLocalName());
        }
        if (rdfType.canAsListType()) {
            value = new TermValue();
            value.setContainer(Container.LIST);
        }
        boolean uriRef = properties.isIdRef(property.getURI());
        boolean enumerable = rdfType != null && rdfType.canAsFrame() && rdfType.asFrame().getCategory() == RestCategory.ENUMERABLE;
        boolean stubbed = false;
        if (enumerable || uriRef) {
            if (value == null) {
                value = new TermValue();
            }
            value.setType("@id");
            stubbed = true;
        }
        if (properties.getOptionalProperties().contains(property.getURI())) {
            if (value == null) {
                value = new TermValue();
            }
            value.setMinCardinality(0);
        }
        if (enumerable) {
            this.addIndividuals(context, rdfType.asFrame());
        }
        if (value != null) {
            value.setId(iriValue);
            info.setObjectValue(value);
        } else {
            info.setIriValue(iriValue);
        }
        this.addNamespace(context, field, property);
        if (!context.containsTerm(localName)) {
            context.add(info);
        }
        if (value != null && value.getContainer() == Container.LIST) {
            this.addType(properties, context, rdfType, stubbed);
        } else if (rdfType.canAsFrame()) {
            this.addType(properties, context, rdfType, stubbed);
        } else {
            this.addNamespace(context, rdfType);
            if (!properties.getExpandedValues().contains(propertyURI)) {
                String propertyTypeURI = rdfType.getUri();
                String typeIRI = this.iriRef(context, rdfType.getNamespace(), rdfType.getLocalName(), propertyTypeURI);
                if (value == null) {
                    value = new TermValue();
                }
                value.setId(iriValue);
                value.setType(typeIRI);
                info.setObjectValue(value);
                this.addNamespace(context, rdfType);
            } else {
                System.out.println("expanded value: " + info.getTermName());
            }
        }
        this.coerceType(info, properties);
    }

    private void coerceType(TermInfo info, ContextProperties properties) {
        String key = info.getTermName() + ".@type";
        String typeURI = properties.getProperty(key);
        if (typeURI == null) {
            return;
        }
    }

    private void addNamespace(JsonContext context, RdfType rdfType) {
        String namespace = rdfType.getNamespace();
        TermInfo term = context.getTermInfoByURI(namespace);
        if (term != null) {
            return;
        }
        OntologyInfo info = this.typeManager.getOntologyByNamespaceUri(namespace);
        String prefix = info == null ? TypeManager.getDefaultNamespacePrefix(namespace) : info.getPrefix();
        term = new TermInfo(prefix);
        term.setIriValue(namespace);
        term.setCategory(TermInfo.TermCategory.NAMESPACE);
        context.add(term);
    }

    private boolean isIncluded(Field field, ContextProperties properties, Frame declaringFrame) {
        String fieldType = field.getRdfType().getUri();
        if (properties.getExcludedTypes().contains(fieldType)) {
            return false;
        }
        FrameConstraints constraints = properties.getFrameConstraints(declaringFrame.getLocalName());
        return constraints == null || constraints.isIncludedProperty(field.getURI());
    }

    private void addIndividuals(JsonContext context, Frame frame) {
        if (frame.canAsEnumeration()) {
            this.addIndividuals(context, frame.asEnumeration());
        } else {
            List<NamedIndividual> list = frame.listInstances(false);
            for (NamedIndividual n : list) {
                String name = n.getLocalName();
                String uri = n.getUri();
                TermInfo term = context.getTermInfoByURI(uri);
                if (term != null) continue;
                term = new TermInfo(name);
                term.setIriValue(uri);
                context.add(term);
            }
        }
    }

    private void addIndividuals(JsonContext context, Enumeration e) {
        List<NamedIndividual> list = e.getIndividualList();
        for (NamedIndividual n : list) {
            String name = n.getLocalName();
            TermInfo term = new TermInfo(name);
            term.setIriValue(n.getUri());
            context.add(term);
        }
    }

    private void addNamespace(JsonContext context, Field field, OntProperty property) {
        String namespace = field.getProperty().getNameSpace();
        String prefix = this.getPrefix(context, namespace);
        TermInfo term = context.getTermInfoByShortName(prefix);
        if (term != null) {
            return;
        }
        term = new TermInfo(prefix);
        term.setCategory(TermInfo.TermCategory.NAMESPACE);
        term.setIriValue(namespace);
        context.add(term);
    }

    private String iriRef(JsonContext context, String namespaceURI, String localName, String uri) {
        String prefix;
        if (this.typeManager.isStandardLiteralType(uri)) {
            namespaceURI = XSD.getURI();
            localName = XSD.xstring.getLocalName();
        }
        if ((prefix = this.getPrefix(context, namespaceURI)) == null) {
            return uri;
        }
        return prefix + ":" + localName;
    }

    private OntologyInfo createOntologyInfo(String namespaceURI) {
        Literal object;
        Model tmp = ModelFactory.createDefaultModel();
        Resource namespaceResource = tmp.createResource(namespaceURI);
        String ontologyURI = null;
        String prefix = null;
        String label = null;
        StmtIterator sequence = this.model.listStatements(namespaceResource, null, (RDFNode)null);
        while (sequence.hasNext()) {
            Statement s = (Statement)sequence.next();
            if (s.getPredicate().equals(RDF.type) && s.getObject().equals(OWL.Ontology)) {
                ontologyURI = namespaceURI;
            }
            if (s.getPredicate().equals(RDFS.label) || s.getPredicate().equals(DublinCoreTerms.title)) {
                label = s.getObject().asLiteral().getString();
            }
            if (s.getPredicate().equals(BindVocabulary.suggestedPrefix) || s.getPredicate().equals(VannVocabulary.preferredNamespacePrefix)) {
                prefix = s.getObject().asLiteral().getString();
            }
            if (ontologyURI == null || prefix == null) continue;
            break;
        }
        if (ontologyURI == null && (sequence = this.model.listStatements(null, null, (RDFNode)(object = tmp.createLiteral(namespaceURI)))).hasNext()) {
            Statement s = (Statement)sequence.next();
            Resource subject = s.getSubject();
            ontologyURI = subject.getURI();
            s = subject.getProperty((Property)VannVocabulary.preferredNamespacePrefix);
            if (s != null) {
                prefix = s.getObject().asLiteral().getString();
            } else {
                s = subject.getProperty((Property)BindVocabulary.suggestedPrefix);
                if (s != null) {
                    prefix = s.getObject().asLiteral().getString();
                }
            }
            if (prefix != null) {
                s = subject.getProperty((Property)DublinCoreTerms.title);
                if (s == null) {
                    s = subject.getProperty(RDFS.label);
                }
                if (s == null) {
                    s = subject.getProperty((Property)DublinCoreElements.title);
                }
                if (s != null) {
                    label = s.getObject().asLiteral().getString();
                }
            }
        }
        OntologyInfo info = new OntologyInfo();
        info.setNamespaceUri(namespaceURI);
        info.setOntologyURI(ontologyURI);
        info.setPrefix(prefix);
        info.setLabel(label);
        return info;
    }

    private String getPrefix(JsonContext context, String namespaceURI) {
        OntologyInfo info;
        String prefix = null;
        if ("http://www.w3.org/2002/07/owl#".equals(namespaceURI)) {
            info = this.typeManager.getOntologyByNamespaceUri(namespaceURI);
            prefix = info.getPrefix();
        } else {
            info = this.typeManager.getOntologyByNamespaceUri(namespaceURI);
            if (info == null) {
                info = this.createOntologyInfo(namespaceURI);
                this.typeManager.add(info);
            } else {
                prefix = info.getPrefix();
            }
        }
        if (prefix == null && namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            prefix = "rdf";
        }
        if (prefix != null && !context.containsTerm(prefix)) {
            String uri = namespaceURI;
            context.add(prefix, uri).setCategory(TermInfo.TermCategory.NAMESPACE);
        }
        return prefix;
    }
}

