/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.semantictools.context.renderer.MediaTypeFileManager;
import org.semantictools.context.renderer.model.BibliographicReference;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.DocumentMetadata;
import org.semantictools.context.renderer.model.FrameConstraints;
import org.semantictools.context.renderer.model.Person;
import org.semantictools.context.renderer.model.ReferenceManager;
import org.semantictools.context.renderer.model.SampleJson;
import org.semantictools.frame.api.ContextPropertiesSyntaxException;
import org.semantictools.frame.api.TypeManager;

public class ContextManager {
    private static final String RDFTYPE = "rdfType";
    private static final String RDFTYPE_REF = "rdfTypeRef";
    private static final String RDF_PROPERTY = "rdfProperty";
    private static final String MEDIATYPE = "mediaType";
    private static final String MEDIATYPEURI = "mediaTypeURI";
    private static final String MEDIATYPEREF = "mediaTypeRef";
    private static final String CONTEXTURI = "contextURI";
    private static final String CONTEXTREF = "contextRef";
    private static final String GRAPH_TYPES = "graphTypes";
    private static final String USE_PREFIX = "usePrefix";
    private static final String SET = "@set";
    private static final String ENABLE_VERSION_HISTORY = "enableVersionHistory";
    private static final String IDREF = "idref";
    private static final String REQUIRES_ID = "requiresId";
    private static final String OPTIONAL = "optional";
    private static final String MIXED_VALUE = "mixedValue";
    private static final String STATUS = "status";
    private static final String DATE = "date";
    private static final String ABSTRACT = "abstract";
    private static final String EDITORS = "editors";
    private static final String AUTHORS = "authors";
    private static final String TITLE = "title";
    private static final String SAMPLE_TEXT = "sampleText";
    private static final String EXCLUDE_TYPE = "excludeType";
    private static final String INTRODUCTION = "introduction";
    private static final String INCLUDES_SUFFIX = ".includes";
    private static final String EXCLUDES_SUFFIX = ".excludes";
    private static final String EXCLUDE_SUBTYPES_SUFFIX = ".excludeSubtypes";
    private static final String PURL_DOMAIN = "purlDomain";
    private static final String EXPANDED_VALUE = "expandedValue";
    private static final String CAPTION_SUFFIX = ".caption";
    private static final String TEMPLATE = "template";
    private static final String VALIDATE_JSON_SAMPLES = "validateJsonSamples";
    private static final String HOW_TO_READ = "includeHowToReadSection";
    private static final String JSON_LD_SECTION = "includeJsonldSection";
    private static final String RESERVED_WORDS = "includeReservedWordsSection";
    private static final String MEDIA_TYPE_SECTION = "includeMediaTypeConformance";
    private static final String OVERVIEW_DIAGRAM = "includeOverviewDiagram";
    private MediaTypeFileManager fileManager;
    private Map<String, ContextProperties> contextMap = new HashMap<String, ContextProperties>();
    private DocumentMetadata defaultMetadata;

    public ContextManager(DocumentMetadata defaultMetadata, MediaTypeFileManager fileManager) {
        this.fileManager = fileManager;
        this.defaultMetadata = defaultMetadata;
    }

    public MediaTypeFileManager getMediaTypeFileManager() {
        return this.fileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadContextProperties(File propertiesFile) throws IOException, ContextPropertiesSyntaxException {
        Properties properties = new Properties();
        FileInputStream input = new FileInputStream(propertiesFile);
        try {
            properties.load(input);
            this.parseProperties(propertiesFile, properties);
        }
        finally {
            input.close();
        }
    }

    public void loadAll(File baseDir) throws ContextPropertiesSyntaxException, IOException {
        File[] list = baseDir.listFiles();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            File file = list[i];
            if (file.isDirectory()) {
                this.loadAll(file);
                continue;
            }
            if (!"context.properties".equals(file.getName())) continue;
            this.loadContextProperties(file);
        }
    }

    public String createIdMediaTypeName(String baseMediaType) {
        int plus = baseMediaType.lastIndexOf(43);
        if (plus < 0) {
            return baseMediaType + ".id";
        }
        return baseMediaType.substring(0, plus) + ".id" + baseMediaType.substring(plus);
    }

    public String createIdMediaTypeRef(String typeName) {
        return "[" + typeName + "-id-media-type]";
    }

    public ContextProperties getContextPropertiesByMediaType(String mediaType) {
        return this.contextMap.get(mediaType);
    }

    public List<ContextProperties> listContextPropertiesForClass(String rdfClassURI) {
        ArrayList<ContextProperties> list = new ArrayList<ContextProperties>();
        for (ContextProperties p : this.contextMap.values()) {
            if (!rdfClassURI.equals(p.getRdfTypeURI())) continue;
            list.add(p);
        }
        return list;
    }

    public List<ContextProperties> listContextProperties() {
        return new ArrayList<ContextProperties>(this.contextMap.values());
    }

    private void parseProperties(File sourceFile, Properties properties) {
        ContextProperties sink = new ContextProperties(this.defaultMetadata, properties);
        sink.setSourceFile(sourceFile);
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            if (key.startsWith("[")) {
                sink.putReference(key, value);
                continue;
            }
            if (CONTEXTURI.equals(key)) {
                sink.setContextURI(value);
                continue;
            }
            if (IDREF.equals(key)) {
                this.setIdref(sink, value);
                continue;
            }
            if (REQUIRES_ID.equals(key)) {
                this.setRequiresId(sink, value);
                continue;
            }
            if (MIXED_VALUE.equals(key)) {
                this.setMixedValue(sink, value);
                continue;
            }
            if (MEDIATYPE.equals(key)) {
                sink.setMediaType(value);
                continue;
            }
            if (OPTIONAL.equals(key)) {
                this.addOptionalProperties(sink, value);
                continue;
            }
            if (MEDIATYPEURI.equals(key)) {
                sink.setMediaTypeURI(value);
                continue;
            }
            if (MEDIATYPEREF.equals(key)) {
                sink.setMediaTypeRef(value);
                continue;
            }
            if (USE_PREFIX.equals(key)) {
                this.setUsePrefix(sink, value);
                continue;
            }
            if (RDFTYPE.equals(key)) {
                sink.setRdfTypeURI(value);
                continue;
            }
            if (RDFTYPE_REF.equals(key)) {
                sink.setRdfTypeRef(value);
                continue;
            }
            if (RDF_PROPERTY.equals(key)) {
                sink.setRdfProperty(value);
                continue;
            }
            if (GRAPH_TYPES.equals(key)) {
                this.setGraphTypes(sink, value);
                continue;
            }
            if (SET.equals(key)) {
                this.setSetProperties(sink, value);
                continue;
            }
            if (CONTEXTREF.equals(key)) {
                sink.setContextRef(value);
                continue;
            }
            if (STATUS.equals(key)) {
                sink.setStatus(value);
                continue;
            }
            if (DATE.equals(key)) {
                sink.setDate(value);
                continue;
            }
            if (ABSTRACT.equals(key)) {
                sink.setAbstactText(value);
                continue;
            }
            if (ENABLE_VERSION_HISTORY.equals(key)) {
                sink.setHistoryLink("true".equalsIgnoreCase(value));
                continue;
            }
            if (EDITORS.equals(key)) {
                this.setEditors(sink, value);
                continue;
            }
            if (AUTHORS.equals(key)) {
                this.setAuthors(sink, value);
                continue;
            }
            if (INTRODUCTION.equals(key)) {
                sink.setIntroduction(value);
                continue;
            }
            if (TITLE.equals(key)) {
                sink.setTitle(value);
                continue;
            }
            if (SAMPLE_TEXT.equals(key)) {
                sink.setSampleText(value);
                continue;
            }
            if (EXCLUDE_TYPE.equals(key)) {
                this.setExcludedTypes(sink, value);
                continue;
            }
            if (key.endsWith(INCLUDES_SUFFIX)) {
                this.addIncludesConstraint(sink, key, value);
                continue;
            }
            if (key.endsWith(EXCLUDES_SUFFIX)) {
                this.addExcludesConstraint(sink, key, value);
                continue;
            }
            if (key.endsWith(EXCLUDE_SUBTYPES_SUFFIX)) {
                this.addExcludeSubtypesConstraint(sink, key, value);
                continue;
            }
            if (key.endsWith(CAPTION_SUFFIX)) {
                this.addCaption(sink, key, value);
                continue;
            }
            if (PURL_DOMAIN.equals(key)) {
                sink.setPurlDomain(value);
                continue;
            }
            if (EXPANDED_VALUE.equals(key)) {
                this.setExpandedValue(sink, value);
                continue;
            }
            if (TEMPLATE.equals(key)) {
                sink.setTemplateName(value);
                continue;
            }
            if (VALIDATE_JSON_SAMPLES.equals(key)) {
                sink.setValidateJsonSamples("true".equalsIgnoreCase(value));
                continue;
            }
            if (HOW_TO_READ.equals(key)) {
                sink.setHowToReadThisDocument(this.toBoolean(value));
                continue;
            }
            if (RESERVED_WORDS.equals(key)) {
                sink.setReservedTermsSection(this.toBoolean(value));
                continue;
            }
            if (JSON_LD_SECTION.equals(key)) {
                sink.setReservedTermsSection(this.toBoolean(value));
                continue;
            }
            if (MEDIA_TYPE_SECTION.equals(key)) {
                sink.setMediaTypeSection(this.toBoolean(value));
                continue;
            }
            if (!OVERVIEW_DIAGRAM.equals(key)) continue;
            sink.setOverviewDiagram(this.toBoolean(value));
        }
        this.validate(sink);
        this.setDefaults(sink);
    }

    boolean toBoolean(String text) {
        return "true".equalsIgnoreCase(text);
    }

    private void addOptionalProperties(ContextProperties sink, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\r\n");
        while (tokenizer.hasMoreElements()) {
            sink.addOptional(tokenizer.nextToken());
        }
    }

    private void setUsePrefix(ContextProperties sink, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\r\n");
        while (tokenizer.hasMoreElements()) {
            sink.addUsePrefix(tokenizer.nextToken());
        }
    }

    private void setSetProperties(ContextProperties sink, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\r\n");
        while (tokenizer.hasMoreElements()) {
            sink.addSetProperty(tokenizer.nextToken());
        }
    }

    private void setGraphTypes(ContextProperties sink, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\r\n");
        while (tokenizer.hasMoreElements()) {
            sink.addGraphType(tokenizer.nextToken());
        }
    }

    private void setRequiresId(ContextProperties sink, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\r\n");
        while (tokenizer.hasMoreElements()) {
            sink.getRequiresId().add(tokenizer.nextToken());
        }
    }

    private void setExcludedTypes(ContextProperties sink, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\r\n");
        while (tokenizer.hasMoreElements()) {
            sink.getExcludedTypes().add(tokenizer.nextToken());
        }
    }

    private void addCaption(ContextProperties sink, String key, String value) {
        int dot = key.lastIndexOf(46);
        String fileName = key.substring(0, dot);
        for (SampleJson sample : sink.getSampleJsonList()) {
            if (!fileName.equals(sample.getFileName())) continue;
            sample.setFileName(value);
            return;
        }
        SampleJson sample = new SampleJson();
        sample.setFileName(fileName);
        sample.setCaption(value);
        sink.getSampleJsonList().add(sample);
    }

    private void setExpandedValue(ContextProperties sink, String value) {
        StringTokenizer tokens = new StringTokenizer(value, " \t\r\n");
        while (tokens.hasMoreTokens()) {
            String propertyURI = tokens.nextToken();
            sink.getExpandedValues().add(propertyURI);
        }
    }

    private void addIncludesConstraint(ContextProperties sink, String key, String value) {
        int dot = key.lastIndexOf(46);
        String name = key.substring(0, dot);
        FrameConstraints constraints = sink.fetchFrameConstraints(name);
        StringTokenizer tokens = new StringTokenizer(value, " \r\n\t");
        while (tokens.hasMoreTokens()) {
            String propertyURI = tokens.nextToken();
            constraints.addIncludedProperty(propertyURI);
        }
    }

    private void addExcludesConstraint(ContextProperties sink, String key, String value) {
        int dot = key.lastIndexOf(46);
        String name = key.substring(0, dot);
        FrameConstraints constraints = sink.fetchFrameConstraints(name);
        StringTokenizer tokens = new StringTokenizer(value, " \r\n\t");
        while (tokens.hasMoreTokens()) {
            String propertyURI = tokens.nextToken();
            constraints.addExcludedProperty(propertyURI);
        }
    }

    private void addExcludeSubtypesConstraint(ContextProperties sink, String key, String value) {
        int dot = key.lastIndexOf(46);
        String name = key.substring(0, dot);
        FrameConstraints constraints = sink.fetchFrameConstraints(name);
        StringTokenizer tokens = new StringTokenizer(value, " \r\n\t");
        while (tokens.hasMoreTokens()) {
            String propertyURI = tokens.nextToken();
            constraints.addExcludesSubtype(propertyURI);
        }
    }

    private void setDefaults(ContextProperties sink) {
        this.setTitle(sink);
        this.setMediaTypeDocFile(sink);
        this.setMediaTypeReference(sink);
    }

    private void setMediaTypeReference(ContextProperties properties) {
        ReferenceManager manager = properties.getReferenceManager();
        if (manager == null) {
            return;
        }
        String mediaType = properties.getMediaType();
        String mediaTypeRef = properties.getMediaTypeRef();
        if (mediaTypeRef == null) {
            String[] array = mediaType.split("\\./\\+");
            String rdfType = properties.getRdfTypeURI();
            if (rdfType != null) {
                String localName = TypeManager.getLocalName(rdfType);
                String suffix = this.getSuffix(localName, array);
                mediaTypeRef = "[" + localName + suffix + "-Media-Type" + "]";
                properties.setMediaTypeRef(mediaTypeRef);
            }
        }
        if (mediaTypeRef == null) {
            mediaTypeRef = "[" + mediaType + "]";
        }
        File localFile = this.fileManager.getMediaTypeDocumentationFile(mediaType);
        properties.setLocalFile(localFile);
        BibliographicReference ref = new BibliographicReference();
        ref.setLabel(mediaTypeRef);
        ref.setAuthor(properties.getEditors());
        ref.setTitle(properties.getTitle());
        ref.setDate(properties.getDate());
        ref.setEdition(properties.getStatus());
        ref.setLocalFile(localFile);
        manager.add(ref);
    }

    private String getSuffix(String localName, String[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            if (!localName.equals(array[i])) continue;
            return "-" + array[i + 1];
        }
        return "";
    }

    private void setMediaTypeDocFile(ContextProperties sink) {
        File file = this.fileManager.getIndexFile(sink.getMediaType());
        sink.setMediaTypeDocFile(file);
    }

    private String getLocalName(String uri) {
        return TypeManager.getLocalName(uri);
    }

    private void setTitle(ContextProperties sink) {
        if (sink.getTitle() == null) {
            String typeURI = sink.getRdfTypeURI();
            String mediaType = sink.getMediaType();
            String title = null;
            if (typeURI == null) {
                title = "The <code>" + mediaType + "</code> format";
            } else {
                String typeName = this.getLocalName(typeURI);
                title = typeName + " JSON Binding<br>in the <code>" + mediaType + "</code> format";
            }
            sink.setTitle(title);
        }
    }

    private void setEditors(ContextProperties sink, String value) {
        StringTokenizer tokens = new StringTokenizer(value, "\n");
        while (tokens.hasMoreTokens()) {
            String text = tokens.nextToken().trim();
            if (text.length() <= 0) continue;
            sink.addEditor(this.parsePerson(text));
        }
    }

    private Person parsePerson(String line) {
        String personName = line;
        String orgName = null;
        int comma = line.indexOf(44);
        if (comma > 0) {
            personName = line.substring(0, comma).trim();
            orgName = line.substring(comma + 1).trim();
        }
        Person person = new Person();
        person.setPersonName(personName);
        person.setOrgName(orgName);
        return person;
    }

    private void setAuthors(ContextProperties sink, String value) {
        StringTokenizer tokens = new StringTokenizer(value, "\n");
        while (tokens.hasMoreTokens()) {
            String text = tokens.nextToken().trim();
            if (text.length() <= 0) continue;
            sink.addAuthor(this.parsePerson(text));
        }
    }

    private void validate(ContextProperties p) {
        StringBuilder error = new StringBuilder();
        this.validate(error, p);
        if (error.length() > 0) {
            throw new ContextPropertiesSyntaxException(error.toString());
        }
        this.contextMap.put(p.getMediaType(), p);
    }

    private void validate(StringBuilder error, ContextProperties p) {
        if (p.getMediaType() == null) {
            this.append(error, MEDIATYPE);
        }
    }

    private void append(StringBuilder error, String propertyName) {
        if (error.length() > 0) {
            error.append("\n");
        } else {
            error.append("Missing properties:\n");
        }
        error.append("  ");
        error.append(propertyName);
    }

    private void setMixedValue(ContextProperties sink, String value) {
        StringTokenizer tokens = new StringTokenizer(value, " \t\r\n");
        while (tokens.hasMoreTokens()) {
            String propertyURI = tokens.nextToken();
            sink.addMixed(propertyURI);
        }
    }

    private void setIdref(ContextProperties sink, String value) {
        StringTokenizer tokens = new StringTokenizer(value, " \t\r\n");
        while (tokens.hasMoreTokens()) {
            String idref = tokens.nextToken();
            sink.addIdRef(idref);
        }
    }
}

