/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWL2;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.api.impl.DatatypeReader;
import org.semantictools.frame.model.BindVocabulary;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Enumeration;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.ListType;
import org.semantictools.frame.model.NamedIndividual;
import org.semantictools.frame.model.RdfType;
import org.semantictools.frame.model.RestCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FrameBuilder {
    private static Logger logger = LoggerFactory.getLogger(FrameBuilder.class);
    private static final OntModel owlModel = ModelFactory.createOntologyModel();
    private static final OntClass THING = owlModel.createClass("http://www.w3.org/2002/07/owl#Thing");
    private static final String[] STANDARD_URI = new String[]{"http://www.w3.org/2001/XMLSchema#", "http://www.w3.org/2002/07/owl#", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "http://www.w3.org/2000/01/rdf-schema#", "http://purl.org/semantictools/v1/vocab/bind#"};
    private TypeManager manager;
    private OntModel model;
    private DatatypeReader datatypeReader;

    public FrameBuilder(TypeManager manager) {
        this.manager = manager;
        this.datatypeReader = new DatatypeReader(manager);
    }

    public OntModel getOntModel() {
        return this.model;
    }

    public void setOntModel(OntModel model) {
        this.model = model;
    }

    private static boolean isStandard(String uri) {
        for (int i = 0; i < STANDARD_URI.length; ++i) {
            if (!uri.startsWith(STANDARD_URI[i])) continue;
            return true;
        }
        return false;
    }

    public void buildFrames(OntModel model) {
        this.model = model;
        this.applyInverseOfReasoning();
        this.createFrames();
        this.addSupertypesAndRestrictions();
        this.addFields();
        this.addFieldsFromRestrictions();
    }

    private void applyInverseOfReasoning() {
        List list = this.model.listStatements(null, OWL.inverseOf, (RDFNode)null).toList();
        for (Statement s : list) {
            Resource subject = s.getSubject();
            Resource object = s.getObject().asResource();
            Statement newStatement = this.model.createStatement(object, OWL.inverseOf, (RDFNode)subject);
            this.model.add(newStatement);
        }
    }

    private void addFieldsFromRestrictions() {
        for (Frame frame : this.manager.listFrames()) {
            this.addFieldsFromRestrictions(frame);
        }
    }

    private void addFieldsFromRestrictions(Frame frame) {
        Map<String, Field> fieldMap = this.createFieldMap(frame);
        for (OntClass restriction : frame.listRestrictions()) {
            this.addFieldFromRestriction(fieldMap, frame, restriction);
        }
    }

    private void addFieldFromRestriction(Map<String, Field> fieldMap, Frame frame, OntClass restriction) {
        Resource valueType;
        int minCardinality = 0;
        int maxCardinality = -1;
        OntResource range = null;
        Resource resource = restriction.getPropertyResourceValue(OWL2.onProperty);
        String uri = resource.getURI();
        Field priorField = fieldMap.get(uri);
        OntProperty property = null;
        property = restriction.getPropertyResourceValue(OWL2.onProperty).canAs(OntProperty.class) ? (OntProperty)resource.as(OntProperty.class) : this.model.createOntProperty(resource.getURI());
        if (restriction.hasProperty(OWL.minCardinality)) {
            minCardinality = restriction.getProperty(OWL.minCardinality).getInt();
        }
        if (restriction.hasProperty(OWL.maxCardinality)) {
            maxCardinality = restriction.getProperty(OWL.maxCardinality).getInt();
        }
        if ((valueType = restriction.getPropertyResourceValue(OWL.allValuesFrom)) != null) {
            range = (OntResource)valueType.as(OntResource.class);
        }
        if (range == null) {
            Resource value = property.getPropertyResourceValue(RDFS.range);
            if (value == null) {
                logger.warn("Ignoring field " + resource.getLocalName() + " on class " + frame.getLocalName() + ": the range is not defined.");
                return;
            }
            range = (OntResource)property.getPropertyResourceValue(RDFS.range).as(OntResource.class);
        }
        String comment = restriction.getComment(null);
        if (priorField != null) {
            priorField.setComment(comment);
            priorField.setMinCardinality(minCardinality);
            priorField.setMaxCardinality(maxCardinality);
            return;
        }
        Field field = new Field(frame, property, range, minCardinality, maxCardinality);
        field.setComment(comment);
        fieldMap.put(uri, field);
        frame.getDeclaredFields().add(field);
    }

    private Map<String, Field> createFieldMap(Frame frame) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : frame.listAllFields()) {
            map.put(field.getURI(), field);
        }
        return map;
    }

    private void addFields() {
        List<OntProperty> list = this.listProperties();
        for (OntProperty p : list) {
            if (FrameBuilder.isStandard(p.getURI())) continue;
            this.addFields(p);
        }
    }

    private void addFields(OntProperty p) {
        OntResource domainResource = p.getDomain();
        if (domainResource == null) {
            this.handleNullDomain(p);
            return;
        }
        OntClass domain = (OntClass)domainResource.as(OntClass.class);
        List<OntResource> domainList = this.listUnionMembers(p, (OntResource)domain);
        if (domainList.isEmpty()) {
            domainList.add((OntResource)domain);
        }
        for (OntResource type : domainList) {
            this.addField(type, p);
        }
    }

    private void handleNullDomain(OntProperty p) {
        List list = p.listPropertyValues(RDFS.subClassOf).toList();
        block0: for (RDFNode node : list) {
            Resource someValuesFrom;
            Resource resource;
            Resource onPropertyValue;
            if (!node.canAs(Resource.class) || !RDFS.domain.equals(onPropertyValue = (resource = node.asResource()).getPropertyResourceValue(OWL.onProperty)) || (someValuesFrom = resource.getPropertyResourceValue(OWL.someValuesFrom)) == null) continue;
            String uri = someValuesFrom.getURI();
            if (uri != null) {
                OntResource type = (OntResource)someValuesFrom.as(OntResource.class);
                this.addField(type, p);
                continue;
            }
            Resource unionList = someValuesFrom.getPropertyResourceValue(OWL.unionOf);
            while (unionList != null) {
                Resource first = unionList.getPropertyResourceValue(RDF.first);
                if (first != null) {
                    String typeURI = first.getURI();
                    if (typeURI == null) {
                        logger.warn("Cannot handle union that contains an anonymous class in the domain of " + p.getURI());
                    } else {
                        OntResource type = (OntResource)first.as(OntResource.class);
                        this.addField(type, p);
                    }
                }
                if (!RDF.nil.equals((Object)(unionList = unionList.getPropertyResourceValue(RDF.rest)))) continue;
                continue block0;
            }
        }
    }

    private void addField(OntResource type, OntProperty p) {
        Resource rawInverse;
        int minCardinality = 0;
        int maxCardinality = -1;
        OntResource range = null;
        String typeURI = type.getURI();
        if (typeURI == null) {
            return;
        }
        Frame frame = this.manager.getFrameByUri(typeURI);
        if (frame == null) {
            if (FrameBuilder.isStandard(typeURI)) {
                return;
            }
            logger.warn("Ignoring property " + p.getLocalName() + " on class " + type.getLocalName() + ": frame not found");
            return;
        }
        if (p.hasRDFType(OWL.FunctionalProperty)) {
            maxCardinality = 1;
        }
        OntClass restriction = frame.getRestriction(p.getURI());
        range = p.getRange();
        if (range == null) {
            range = THING;
        }
        if (restriction != null) {
            Resource onClass = restriction.getPropertyResourceValue(OWL2.allValuesFrom);
            if (onClass != null) {
                range = (OntResource)onClass.as(OntResource.class);
                if (restriction.hasProperty(OWL2.minQualifiedCardinality)) {
                    minCardinality = restriction.getProperty(OWL2.minQualifiedCardinality).getInt();
                }
                if (restriction.hasProperty(OWL2.maxQualifiedCardinality)) {
                    maxCardinality = restriction.getProperty(OWL2.maxQualifiedCardinality).getInt();
                }
            } else {
                if (restriction.hasProperty(OWL.minCardinality)) {
                    minCardinality = restriction.getProperty(OWL.minCardinality).getInt();
                }
                if (restriction.hasProperty(OWL.maxCardinality)) {
                    maxCardinality = restriction.getProperty(OWL.maxCardinality).getInt();
                }
            }
        }
        Field field = null;
        String rangeURI = range.getURI();
        if (rangeURI == null) {
            field = this.createListField(frame, p, range);
            if (field == null) {
                logger.warn("Ignoring property " + p.getLocalName() + " on class " + type.getLocalName() + ": range has no URI");
                return;
            }
        } else {
            field = new Field(frame, p, range, minCardinality, maxCardinality);
            if (field.getRdfType() == null) {
                logger.warn("Failed to create RdfType for field " + field.getLocalName() + " of type " + field.getType().getURI());
            }
        }
        if ((rawInverse = p.getPropertyResourceValue(OWL.inverseOf)) != null && rawInverse.canAs(OntProperty.class)) {
            field.setInverseOf((OntProperty)rawInverse.as(OntProperty.class));
        }
        frame.getDeclaredFields().add(field);
    }

    private Field createListField(Frame frame, OntProperty p, OntResource range) {
        Resource intersection = range.getPropertyResourceValue(OWL.intersectionOf);
        if (intersection == null) {
            return null;
        }
        if (intersection.canAs(RDFList.class)) {
            List intersectionList = ((RDFList)intersection.as(RDFList.class)).asJavaList();
            for (RDFNode node : intersectionList) {
                RdfType elementType;
                String elementTypeURI;
                Resource elementRdfType;
                OntClass intersectionMember;
                if (!node.canAs(OntClass.class) || !RDF.first.equals((intersectionMember = (OntClass)node.as(OntClass.class)).getPropertyResourceValue(OWL.onProperty)) || (elementRdfType = intersectionMember.getPropertyResourceValue(OWL.allValuesFrom)) == null || (elementTypeURI = elementRdfType.getURI()) == null || (elementType = this.manager.getTypeByURI(elementTypeURI)) == null) continue;
                ListType listType = this.manager.getListTypeByElementUri(elementTypeURI);
                if (listType == null) {
                    listType = new ListType(this.manager, intersectionMember, elementType);
                    this.manager.add(listType);
                }
                return new Field(frame, p, listType);
            }
        }
        return null;
    }

    private List<OntClass> listRestrictions(OntClass type) {
        ArrayList<OntClass> list = new ArrayList<OntClass>();
        ExtendedIterator sequence = type.listSuperClasses(true);
        while (sequence.hasNext()) {
            OntClass supertype = (OntClass)sequence.next();
            if (!supertype.hasRDFType(OWL.Restriction, false)) continue;
            list.add(supertype);
        }
        return list;
    }

    private List<OntResource> listUnionMembers(OntProperty p, OntResource domain) {
        ArrayList<OntResource> list = new ArrayList<OntResource>();
        Resource union = domain.getPropertyResourceValue(OWL.unionOf);
        if (union != null && union.canAs(RDFList.class)) {
            RDFList rdfList = (RDFList)union.as(RDFList.class);
            ExtendedIterator sequence = rdfList.iterator();
            while (sequence.hasNext()) {
                list.add((OntResource)((RDFNode)sequence.next()).as(OntResource.class));
            }
        }
        return list;
    }

    private List<OntProperty> listProperties() {
        ArrayList<OntProperty> list = new ArrayList<OntProperty>();
        ExtendedIterator sequence = this.model.listAllOntProperties();
        while (sequence.hasNext()) {
            list.add((OntProperty)sequence.next());
        }
        return list;
    }

    private void addSupertypesAndRestrictions() {
        Collection<Frame> frameList = this.manager.listFrames();
        for (Frame frame : frameList) {
            this.addSupertypes(frame);
            this.addRestrictions(frame);
            this.addSubtypes(frame);
        }
    }

    private void addRestrictions(Frame frame) {
        List<OntClass> restrictionList = this.listRestrictions(frame.asOntClass());
        for (OntClass restriction : restrictionList) {
            frame.addRestriction(restriction);
        }
    }

    private void addSubtypes(Frame frame) {
        ExtendedIterator sequence = frame.asOntClass().listSubClasses(true);
        while (sequence.hasNext()) {
            OntClass type = (OntClass)sequence.next();
            String subURI = type.getURI();
            if (subURI == null) continue;
            Frame subFrame = this.manager.getFrameByUri(subURI);
            if (subFrame == null) {
                subFrame = this.manager.getListTypeByListUri(subURI);
            }
            if (subFrame != null) {
                frame.getSubtypeList().add(subFrame);
                continue;
            }
            Datatype datatype = this.manager.getDatatypeByUri(subURI);
            if (datatype != null) {
                frame.addSubdatatype(datatype);
                continue;
            }
            if (FrameBuilder.isStandard(subURI)) continue;
            logger.warn("Ignoring supertype of " + type.getLocalName() + " because frame not found: " + subURI);
        }
    }

    private void addSupertypes(Frame frame) {
        ExtendedIterator sequence = frame.asOntClass().listSuperClasses(true);
        while (sequence.hasNext()) {
            OntClass type = (OntClass)sequence.next();
            String superURI = type.getURI();
            if (superURI == null) continue;
            Frame superframe = this.manager.getFrameByUri(superURI);
            if (superframe != null) {
                frame.getSupertypeList().add(superframe);
                continue;
            }
            if (FrameBuilder.isStandard(superURI)) continue;
            logger.warn("Ignoring supertype of " + type.getLocalName() + " because frame not found: " + superURI);
        }
    }

    private void createFrames() {
        List<OntClass> list = this.listNamedClasses();
        for (OntClass type : list) {
            Frame frame;
            if (this.isProperty(type) || (frame = this.createFrame(type)) == null) continue;
            this.setRestCategory(frame);
            this.setAbstract(frame);
        }
        this.addStandardFrames();
    }

    private boolean isProperty(OntClass type) {
        return type.canAs(OntProperty.class);
    }

    private List<OntClass> listNamedClasses() {
        String uri;
        Resource type;
        ArrayList<OntClass> result = new ArrayList<OntClass>();
        StmtIterator classes = this.model.listStatements(null, RDF.type, (RDFNode)OWL.Class);
        while (classes.hasNext()) {
            type = ((Statement)classes.next()).getSubject();
            uri = type.getURI();
            if (uri == null || FrameBuilder.isStandard(uri)) continue;
            result.add((OntClass)type.as(OntClass.class));
        }
        classes = this.model.listStatements(null, RDF.type, (RDFNode)RDFS.Class);
        while (classes.hasNext()) {
            type = ((Statement)classes.next()).getSubject();
            uri = type.getURI();
            if (uri == null || FrameBuilder.isStandard(uri)) continue;
            result.add((OntClass)type.as(OntClass.class));
        }
        List rdfsClassList = this.model.listResourcesWithProperty(RDF.type, (RDFNode)RDFS.Class).toList();
        for (Resource r : rdfsClassList) {
            if (!r.canAs(OntClass.class) || r.getURI() == null || FrameBuilder.isStandard(r.getURI()) || this.manager.getDatatypeByUri(r.getURI()) != null) continue;
            result.add((OntClass)r.as(OntClass.class));
        }
        return result;
    }

    private Frame createFrame(OntClass type) {
        if (this.manager.isStandardDatatype(type.getNameSpace())) {
            this.manager.getDatatypeByUri(type.getURI());
            return null;
        }
        if (this.manager.isStandard(type.getNameSpace())) {
            return null;
        }
        String uri = type.getURI();
        if (uri == null) {
            throw new RuntimeException("URI of type is not defined");
        }
        Frame frame = this.manager.getFrameByUri(uri);
        if (frame != null) {
            return frame;
        }
        OntClass elemType = this.manager.getElementType(type);
        if (elemType != null) {
            String elemURI = elemType.getURI();
            ListType listType = this.manager.getListTypeByElementUri(elemURI);
            if (listType == null) {
                RdfType elemRdfType = this.manager.getTypeByURI(elemURI);
                if (elemRdfType == null) {
                    elemRdfType = this.createFrame(elemType);
                }
                listType = new ListType(this.manager, type, elemRdfType);
                this.manager.add(listType);
            }
            return null;
        }
        List<OntResource> individuals = this.getEnumeratedIndividuals(type);
        if (individuals == null) {
            frame = new Frame(this.manager, type);
        } else {
            Enumeration enumFrame = new Enumeration(this.manager, type);
            frame = enumFrame;
            for (OntResource item : individuals) {
                NamedIndividual value = new NamedIndividual(item);
                enumFrame.add(value);
            }
        }
        this.manager.add(frame);
        return frame;
    }

    private List<OntResource> getEnumeratedIndividuals(OntClass type) {
        Resource equivalentClass = type.getPropertyResourceValue(OWL.equivalentClass);
        if (equivalentClass == null) {
            return null;
        }
        Resource oneOf = equivalentClass.getPropertyResourceValue(OWL.oneOf);
        if (oneOf == null) {
            return null;
        }
        List nodeList = ((RDFList)oneOf.as(RDFList.class)).asJavaList();
        ArrayList<OntResource> result = new ArrayList<OntResource>();
        for (RDFNode node : nodeList) {
            result.add((OntResource)node.as(OntResource.class));
        }
        return result;
    }

    private void setAbstract(Frame frame) {
        if (frame.getType().hasRDFType((Resource)BindVocabulary.AbstractClass, true)) {
            frame.setAbstract(true);
        }
    }

    private void addStandardFrames() {
        this.addOwlClass();
    }

    private void addOwlClass() {
        String typeURI = OWL2.Class.getURI();
        OntClass type = this.manager.getOntModel().getOntClass(typeURI);
        if (type == null) {
            OntModel model = ModelFactory.createOntologyModel();
            type = model.createClass(typeURI);
        }
        Frame frame = new Frame(this.manager, type);
        frame.setCategory(RestCategory.ADDRESSABLE);
        this.manager.add(frame);
    }

    private void setRestCategory(Frame frame) {
        OntClass type = frame.asOntClass();
        ExtendedIterator sequence = type.listRDFTypes(false);
        while (sequence.hasNext()) {
            Resource resource = (Resource)sequence.next();
            if (BindVocabulary.Addressable.equals(resource)) {
                frame.setCategory(RestCategory.ADDRESSABLE);
                continue;
            }
            if (BindVocabulary.Enum.equals(resource)) {
                frame.setCategory(RestCategory.ENUMERABLE);
                continue;
            }
            if (!BindVocabulary.EmbeddableClass.equals(resource)) continue;
            frame.setCategory(RestCategory.EMBEDDABLE);
        }
    }

    public void loadDir(File dir) throws IOException, ParserConfigurationException, SAXException {
        File[] list = dir.listFiles();
        if (list == null) {
            logger.warn("no files found in directory: " + dir.getPath());
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            this.loadFile(list[i]);
        }
        this.buildFrames(this.model);
    }

    private void loadFile(File file) throws IOException, ParserConfigurationException, SAXException {
        String name = file.getName();
        if (name.endsWith(".ttl")) {
            this.readOntology(file, "TURTLE");
        }
        if (name.endsWith(".xsd")) {
            this.readXmlSchema(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXmlSchema(File file) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream input = new FileInputStream(file);
        try {
            this.datatypeReader.read(input);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOntology(File file, String format) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            if (this.model == null) {
                this.model = ModelFactory.createOntologyModel();
            }
            this.model.read((InputStream)input, null, format);
        }
        finally {
            input.close();
        }
    }
}

