/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api;

import java.io.File;

public class LinkManager {
    private String baseURI;

    public LinkManager() {
    }

    public LinkManager(String baseURI) {
        this.baseURI = baseURI;
    }

    public LinkManager(File baseFile) {
        this(LinkManager.toUnixStyle(baseFile));
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    private static String toUnixStyle(File file) {
        return file.toString().replace('\\', '/');
    }

    public String relativize(File file) {
        String path = LinkManager.toUnixStyle(file);
        return this.relativize(path);
    }

    public String relativize(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith(this.baseURI)) {
            return uri.substring(this.baseURI.length());
        }
        int hash = uri.lastIndexOf(35);
        int end = hash > 0 ? hash : uri.length();
        String baseURI = uri.substring(0, end);
        if (this.baseURI.equals(baseURI)) {
            return uri.substring(hash);
        }
        int slash = this.baseURI.lastIndexOf(47);
        int count = 0;
        while (slash > 0) {
            String prefix = this.baseURI.substring(0, slash + 1);
            if (uri.startsWith(prefix)) {
                return this.generateRelative(prefix, count, slash, uri);
            }
            slash = this.baseURI.lastIndexOf(47, slash - 1);
            ++count;
        }
        return uri;
    }

    private String generateRelative(String prefix, int count, int slash, String uri) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append("../");
        }
        String tail = uri.substring(slash + 1);
        builder.append(tail);
        return builder.toString();
    }
}

