/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.semantictools.context.renderer.MediaTypeFileManager;
import org.semantictools.context.renderer.URLRewriter;
import org.semantictools.context.renderer.impl.DiagramGeneratorImpl;
import org.semantictools.context.renderer.impl.FileStreamFactory;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.GlobalProperties;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.context.view.ContextHtmlPrinter;
import org.semantictools.context.view.MediaTypeIndexPrinter;
import org.semantictools.frame.api.ContextBuilder;
import org.semantictools.frame.api.ContextManager;
import org.semantictools.frame.api.ContextPropertiesSyntaxException;
import org.semantictools.frame.api.ContextWriter;
import org.semantictools.frame.api.GeneratorProperties;
import org.semantictools.frame.api.MediaTypeNotFoundException;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.uml.api.UmlFileManager;
import org.semantictools.web.upload.AppspotUploadClient;
import org.xml.sax.SAXException;

public class MediaTypeDocumenter {
    private TypeManager typeManager;
    private ContextManager contextManager;
    private MediaTypeFileManager fileManager;
    private GeneratorProperties generatorProperties;
    private GlobalProperties global;
    private ContextProperties currentContext;
    private AppspotUploadClient uploadClient;
    private UmlFileManager umlFileManager;
    private boolean publish = false;

    public MediaTypeDocumenter(ContextManager contextManager, UmlFileManager umlFileManager, GlobalProperties global) {
        this.fileManager = contextManager.getMediaTypeFileManager();
        this.contextManager = contextManager;
        this.umlFileManager = umlFileManager;
        this.global = global == null ? new GlobalProperties() : global;
        this.typeManager = new TypeManager();
        this.uploadClient = new AppspotUploadClient();
    }

    public AppspotUploadClient getUploadClient() {
        return this.uploadClient;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public void loadAll(File directory) throws IOException, ParserConfigurationException, SAXException, ContextPropertiesSyntaxException {
        this.loadSchemas(directory);
        this.scan(directory);
    }

    private void scan(File directory) throws ContextPropertiesSyntaxException, IOException {
        File[] fileList = directory.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (file.getName().equals("context.properties")) {
                this.loadContextProperties(file);
            } else if (file.getName().equals("generator.properties")) {
                this.createGeneratorProperties(file);
            }
            if (!file.isDirectory()) continue;
            this.scan(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGeneratorProperties(File file) throws IOException {
        Properties p = new Properties();
        FileInputStream input = new FileInputStream(file);
        try {
            p.load(input);
            this.generatorProperties = new GeneratorProperties(p);
        }
        finally {
            input.close();
        }
    }

    private void loadSchemas(File directory) throws IOException, ParserConfigurationException, SAXException {
        this.typeManager.loadDir(directory);
    }

    private void loadContextProperties(File contextProperties) throws ContextPropertiesSyntaxException, IOException {
        this.contextManager.loadContextProperties(contextProperties);
    }

    public void produceAllDocumentation(File outDir) throws IOException {
        List<ContextProperties> list = this.contextManager.listContextProperties();
        for (ContextProperties p : list) {
            String ontologyURI;
            String typeURI = p.getRdfTypeURI();
            if (typeURI != null && this.global.isIgnoredOntology(ontologyURI = TypeManager.getNamespace(typeURI))) continue;
            this.produceDocumentation(p, outDir);
        }
        this.copyMediaTypeStylesheet(outDir);
        this.updateMediaTypeIndex(outDir);
    }

    private void updateMediaTypeIndex(File outDir) throws IOException {
        File indexFile = new File(outDir, "index.html");
        MediaTypeIndexPrinter printer = new MediaTypeIndexPrinter();
        printer.printIndex(indexFile);
    }

    private void copyMediaTypeStylesheet(File outDir) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("mediaType.css");
        if (stream != null) {
            File cssFile = new File(outDir, "mediaType.css");
            this.copyFile(stream, cssFile);
            if (this.publish && this.uploadClient != null) {
                this.uploadClient.upload("text/css", "mediatype/mediaType.css", cssFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream stream, File cssFile) throws IOException {
        File parent = cssFile.getParentFile();
        parent.mkdirs();
        FileOutputStream out = new FileOutputStream(cssFile);
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            out.close();
        }
    }

    public void produceDocumentation(String mediaType, File outDir) throws MediaTypeNotFoundException, IOException {
        ContextProperties properties = this.contextManager.getContextPropertiesByMediaType(mediaType);
        if (properties == null) {
            throw new MediaTypeNotFoundException(mediaType);
        }
        this.produceDocumentation(properties, outDir);
    }

    private void produceDocumentation(ContextProperties properties, File outDir) throws IOException {
        this.currentContext = properties;
        String mediaType = properties.getMediaType();
        File baseDir = new File(outDir, this.fileManager.pathToMediaTypeDir(mediaType));
        baseDir.mkdirs();
        ContextBuilder contextBuilder = new ContextBuilder(this.typeManager);
        JsonContext context = contextBuilder.createContext(properties);
        if (context != null) {
            ContextWriter contextWriter = new ContextWriter();
            File contextFile = new File(baseDir, this.fileManager.getJsonContextFileName(context));
            properties.setContextFile(contextFile);
            PrintWriter printWriter = new PrintWriter(new FileWriter(contextFile));
            contextWriter.writeContext(printWriter, context);
            printWriter.close();
        }
        File inputDir = properties.getSourceFile().getParentFile();
        FileStreamFactory streamFactory = new FileStreamFactory(inputDir, baseDir);
        DiagramGeneratorImpl diagramManager = new DiagramGeneratorImpl(streamFactory);
        ContextHtmlPrinter contextPrinter = new ContextHtmlPrinter(this.global, this.generatorProperties, this.typeManager, this.fileManager, streamFactory, diagramManager, this.umlFileManager);
        contextPrinter.setIncludeOverviewDiagram(true);
        contextPrinter.setIncludeClassDiagrams(true);
        contextPrinter.printHtml(context, properties);
        if (this.publish) {
            this.uploadClient.upload(baseDir, properties);
        }
    }

    class MyURLRewriter
    implements URLRewriter {
        MyURLRewriter() {
        }

        @Override
        public String rewrite(String url) {
            if (MediaTypeDocumenter.this.generatorProperties == null || MediaTypeDocumenter.this.fileManager == null || MediaTypeDocumenter.this.currentContext == null) {
                return url;
            }
            String baseURL = MediaTypeDocumenter.this.generatorProperties.getBaseURL();
            String mediaType = MediaTypeDocumenter.this.currentContext.getMediaType();
            return MediaTypeDocumenter.this.fileManager.toRelativeURL(url, baseURL, mediaType);
        }
    }
}

