/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.OntologyEntity;
import org.semantictools.frame.api.SchemaParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OntologyManager {
    private static final String PROPERTIES_FILENAME = "asset.properties";
    private static final String URI = "uri";
    private static final String DEFAULT = "default";
    private static final String TURTLE_FORMAT = "text/turtle";
    private static final String XML_FORMAT = "text/xml";
    private static final Logger logger = LoggerFactory.getLogger(OntologyManager.class);
    private String ontologyServiceURI;
    private Map<String, OntologyEntity> uri2OntologyEntity = new HashMap<String, OntologyEntity>();
    private List<String> uploadList = new ArrayList<String>();
    private File localRepository;

    public String getOntologyServiceURI() {
        return this.ontologyServiceURI;
    }

    public File getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(File localRepository) {
        this.localRepository = localRepository;
    }

    public void publishToLocalRepository(List<ContextProperties> contextList) {
        if (this.localRepository == null) {
            return;
        }
        this.publishSchemasToLocalRepo();
        this.publishJsonLdContextsToLocalRepo(contextList);
    }

    private void publishJsonLdContextsToLocalRepo(List<ContextProperties> contextList) {
        for (ContextProperties p : contextList) {
            File contextFile = p.getContextFile();
            String uri = p.getContextURI();
            if (contextFile == null || uri == null) continue;
            File repoDir = this.repoDir(uri);
            File targetFile = this.writeAssetPropertiesFile(repoDir, uri, LdContentType.JSON_LD_CONTEXT);
            try {
                this.copyFile(contextFile, targetFile);
            }
            catch (IOException e) {
                logger.error("Failed to copy file " + contextFile, (Throwable)e);
            }
        }
    }

    private void publishSchemasToLocalRepo() {
        for (OntologyEntity entity : this.uri2OntologyEntity.values()) {
            String uri = entity.getOntologyURI();
            File repoDir = this.repoDir(uri);
            LdContentType format = this.contentType(entity);
            File targetFile = this.writeAssetPropertiesFile(repoDir, uri, format);
            try {
                this.copyFile(entity.getFile(), targetFile);
            }
            catch (IOException e) {
                logger.error("Failed to copy file " + entity.getFile().getName(), (Throwable)e);
            }
        }
    }

    private LdContentType contentType(OntologyEntity entity) {
        return TURTLE_FORMAT.equals(entity.getContentType()) ? LdContentType.TURTLE : (XML_FORMAT.equals(entity.getContentType()) ? LdContentType.XSD : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeAssetPropertiesFile(File repoDir, String uri, LdContentType contentType) {
        repoDir.mkdirs();
        String format = contentType.name();
        String fileName = contentType.repoFileName();
        Properties properties = new Properties();
        properties.setProperty(URI, uri);
        properties.setProperty(DEFAULT, format);
        properties.setProperty(format, fileName);
        FileWriter writer = null;
        try {
            File file = new File(repoDir, PROPERTIES_FILENAME);
            writer = new FileWriter(file);
            properties.store(writer, null);
            this.safeClose(writer);
        }
        catch (Throwable oops) {
            try {
                logger.error("Failed to save properties at " + repoDir, oops);
                this.safeClose(writer);
            }
            catch (Throwable throwable) {
                this.safeClose(writer);
                throw throwable;
            }
        }
        return new File(repoDir, fileName);
    }

    private void safeClose(FileWriter writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (Throwable oops) {
            logger.warn("failed to close writer", oops);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File targetFile) throws IOException {
        FileInputStream input = new FileInputStream(sourceFile);
        File parent = targetFile.getParentFile();
        parent.mkdirs();
        FileOutputStream out = new FileOutputStream(targetFile);
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)input).read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            out.close();
        }
        ((InputStream)input).close();
    }

    private File repoDir(String assetURI) {
        try {
            URI uri = new URI(assetURI);
            String path = uri.getAuthority() + "/" + uri.getPath();
            return new File(this.localRepository, path);
        }
        catch (Throwable oops) {
            return null;
        }
    }

    public void setOntologyServiceURI(String ontologyServiceURI) {
        this.ontologyServiceURI = ontologyServiceURI;
    }

    public List<String> getUploadList() {
        return this.uploadList;
    }

    public void uploadJsonLdContextFiles(List<ContextProperties> list) {
        if (this.ontologyServiceURI == null) {
            return;
        }
        for (ContextProperties p : list) {
            File file = p.getContextFile();
            if (file == null) continue;
            try {
                this.uploadFile(file, "application/ld+json");
            }
            catch (Throwable e) {
                logger.warn("Failed to upload file", e);
            }
        }
    }

    public int upload() throws SchemaParseException, IOException {
        if (this.ontologyServiceURI == null || this.uploadList.isEmpty()) {
            return 0;
        }
        Collections.sort(this.uploadList);
        int count = 0;
        for (String ontologyURI : this.uploadList) {
            OntologyEntity entity = this.uri2OntologyEntity.get(ontologyURI);
            if (entity == null) {
                logger.warn("Cannot upload ontology because file not found: " + ontologyURI);
                continue;
            }
            try {
                this.uploadFile(entity.getFile(), entity.getContentType());
                ++count;
            }
            catch (Throwable oops) {
                logger.warn("Failed to upload " + entity.getFile(), oops);
            }
        }
        return count;
    }

    private void uploadFile(File file, String contentType) throws ClientProtocolException, IOException {
        System.out.println("Uploading... " + file);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.ontologyServiceURI);
        FileEntity fileEntity = new FileEntity(file, contentType);
        post.setEntity((HttpEntity)fileEntity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        switch (status) {
            case 200: 
            case 201: {
                break;
            }
            default: {
                System.out.println(" ERROR: " + status);
            }
        }
    }

    public void scan(File file) throws SchemaParseException {
        if (this.localRepository == null && this.ontologyServiceURI == null) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.scan(child);
            }
        } else {
            String fileName = file.getName();
            if (fileName.endsWith(".xsd")) {
                this.loadXsd(file);
            } else if (fileName.endsWith(".ttl")) {
                this.loadTurtle(file);
            }
        }
    }

    private void loadTurtle(File file) throws SchemaParseException {
        if (file.getName().endsWith("_binding.ttl")) {
            return;
        }
        try {
            OntModel model = ModelFactory.createOntologyModel();
            FileReader reader = new FileReader(file);
            model.read((Reader)reader, null, "TURTLE");
            List list = model.listOntologies().toList();
            if (list.isEmpty()) {
                logger.warn("Ignoring file because it contains no ontology declarations: " + file);
            } else if (list.size() == 1) {
                Ontology onto = (Ontology)list.get(0);
                String ontologyURI = onto.getURI();
                OntologyEntity entity = new OntologyEntity(TURTLE_FORMAT, file, ontologyURI);
                this.uri2OntologyEntity.put(ontologyURI, entity);
            } else {
                logger.warn("Ignoring file because it contains more than one ontology: " + file);
            }
        }
        catch (Throwable oops) {
            throw new SchemaParseException(oops);
        }
    }

    private void loadXsd(File file) throws SchemaParseException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            NamespaceReader handler = new NamespaceReader();
            reader.setContentHandler(handler);
            parser.parse(file, (DefaultHandler)handler);
            String namespace = handler.getTargetNamespace();
            if (namespace == null) {
                logger.warn("Ignoring schema since targetNamespace is not declared: " + file.getPath());
            } else {
                OntologyEntity entity = new OntologyEntity(XML_FORMAT, file, namespace);
                this.uri2OntologyEntity.put(namespace, entity);
            }
        }
        catch (Throwable oops) {
            throw new SchemaParseException(oops);
        }
    }

    public static enum LdContentType {
        XSD("xsd"),
        TURTLE("ttl"),
        JSON_LD_CONTEXT("json"),
        ENHANCED_CONTEXT("json", JSON_LD_CONTEXT),
        UNKNOWN("???");

        private String extension;
        private LdContentType defaultType;

        private LdContentType(String extension) {
            this.extension = extension;
        }

        private LdContentType(String extension, LdContentType defaultType) {
            this.extension = extension;
            this.defaultType = defaultType;
        }

        public String getExtension() {
            return this.extension;
        }

        public LdContentType getDefaultType() {
            return this.defaultType == null ? this : this.defaultType;
        }

        public boolean isDefaultType() {
            return this.defaultType == null || this.defaultType == this;
        }

        public String repoFileName() {
            return this.name() + "." + this.extension;
        }

        public static LdContentType guessContentType(String fileName) {
            int dot = fileName.lastIndexOf(46);
            if (dot < 0) {
                return UNKNOWN;
            }
            String suffix = fileName.substring(dot + 1);
            if (XSD.getExtension().equals(suffix)) {
                return XSD;
            }
            if (TURTLE.getExtension().equals(suffix)) {
                return TURTLE;
            }
            if (JSON_LD_CONTEXT.getExtension().equals(suffix)) {
                return JSON_LD_CONTEXT;
            }
            return UNKNOWN;
        }
    }

    private class NamespaceReader
    extends DefaultHandler {
        private String targetNamespace;

        private NamespaceReader() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("schema".equals(localName)) {
                this.targetNamespace = attributes.getValue("targetNamespace");
            }
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }
    }
}

