/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api;

import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWL2;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.semantictools.frame.api.DublinCoreElements;
import org.semantictools.frame.api.FrameBuilder;
import org.semantictools.frame.model.BindVocabulary;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.DublinCoreTerms;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.ListType;
import org.semantictools.frame.model.OntologyInfo;
import org.semantictools.frame.model.OntologyType;
import org.semantictools.frame.model.RdfType;
import org.semantictools.frame.model.VannVocabulary;
import org.xml.sax.SAXException;

public class TypeManager {
    private static OntologyInfo XSD_INFO = new OntologyInfo("http://www.w3.org/2001/XMLSchema#", "xs", "http://www.w3.org/2001/XMLSchema#", OntologyType.XSD);
    private static OntologyInfo OWL_INFO = new OntologyInfo("http://www.w3.org/2002/07/owl", "owl", "http://www.w3.org/2002/07/owl#", OntologyType.RDF);
    private static OntologyInfo RDFS_INFO = new OntologyInfo("http://www.w3.org/2000/01/rdf-schema#", "rdfs", "http://www.w3.org/2000/01/rdf-schema#", OntologyType.RDF);
    private static OntologyInfo XDT_INFO = new OntologyInfo("http://www.w3.org/2004/10/xpath-datatypes#", "xdt", "http://www.w3.org/2004/10/xpath-datatypes#", OntologyType.XSD);
    private static OntologyInfo BIND = new OntologyInfo("http://purl.org/semantictools/v1/vocab/bind#", "bind", "http://purl.org/semantictools/v1/vocab/bind#", OntologyType.RDF);
    private Map<String, Frame> uri2Frame = new HashMap<String, Frame>();
    private Map<String, Datatype> uri2Datatype = new HashMap<String, Datatype>();
    private Map<String, OntologyInfo> uri2Ontology = new HashMap<String, OntologyInfo>();
    private Map<String, ListType> elemURI2ListType = new HashMap<String, ListType>();
    private Map<String, ListType> listURI2ListType = new HashMap<String, ListType>();
    private Set<String> standard = new HashSet<String>();
    private Set<String> standardDatatype = new HashSet<String>();
    private Set<String> standardLiteralType = new HashSet<String>();
    private OntModel ontModel = ModelFactory.createOntologyModel();

    public TypeManager() {
        this.addStandard(XSD_INFO);
        this.addStandard(OWL_INFO);
        this.addStandard(RDFS_INFO);
        this.addStandard(XDT_INFO);
        this.addStandard(BIND);
        this.addDayTimeDuration();
        this.addOwlThing();
        this.addResource();
        this.addStandardLiteralTypes();
    }

    private void addStandardLiteralTypes() {
        this.standardLiteralType.add(RDFS.Literal.getURI());
        this.standardLiteralType.add(RDFS.Datatype.getURI());
        this.standardLiteralType.add(XMLLiteralType.theXMLLiteralType.getURI());
    }

    public boolean isStandardLiteralType(String typeURI) {
        return this.standardLiteralType.contains(typeURI);
    }

    private void addDayTimeDuration() {
        Datatype duration = this.getDatatypeByUri(XSD.duration.getURI());
        Datatype dayTimeDuration = new Datatype();
        dayTimeDuration.setLocalName("dayTimeDuration");
        dayTimeDuration.setUri(XDT_INFO.getNamespaceUri() + "dayTimeDuration");
        dayTimeDuration.setBase(duration);
        this.add(dayTimeDuration);
    }

    public void analyzeOntologies() {
        this.markOntologiesWithClasses(this.ontModel.listStatements(null, RDF.type, (RDFNode)RDFS.Class));
        this.markOntologiesWithClasses(this.ontModel.listStatements(null, RDF.type, (RDFNode)OWL.Class));
    }

    private void markOntologiesWithClasses(StmtIterator sequence) {
        while (sequence.hasNext()) {
            OntologyInfo info;
            String uri = ((Statement)sequence.next()).getSubject().getNameSpace();
            if (uri == null || (info = this.getOntologyByNamespaceUri(uri)) == null) continue;
            info.setHasClasses(true);
        }
    }

    public String getXsdBaseURI(Datatype type) {
        if (RDFS.Literal.getURI().equals(type.getUri())) {
            return XSD.xstring.getURI();
        }
        String xsdURI = XSD.getURI();
        while (type != null) {
            if (type.getUri().startsWith(xsdURI)) {
                return type.getUri();
            }
            type = type.getBase();
        }
        return null;
    }

    public boolean isStandard(String ontologyURI) {
        return this.standard.contains(ontologyURI);
    }

    public boolean isStandardDatatype(String namespaceURI) {
        return this.standardDatatype.contains(namespaceURI);
    }

    private void addStandard(OntologyInfo info) {
        this.add(info);
        if (info.getType() == OntologyType.XSD) {
            this.standardDatatype.add(info.getNamespaceUri());
        }
        this.standard.add(info.getNamespaceUri());
    }

    private void addResource() {
        OntClass resourceClass = this.ontModel.createClass(RDFS.Resource.getURI());
        Frame resourceFrame = new Frame(this, resourceClass);
        this.add(resourceFrame);
    }

    private void addOwlThing() {
        OntClass thingClass = this.ontModel.createClass(OWL2.Thing.getURI());
        Frame thingFrame = new Frame(this, thingClass);
        this.add(thingFrame);
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    public void loadDir(File dir) throws IOException, ParserConfigurationException, SAXException {
        FrameBuilder builder = new FrameBuilder(this);
        builder.setOntModel(this.ontModel);
        builder.loadDir(dir);
    }

    public void processOntologies() {
        List list = this.ontModel.listOntologies().toList();
        for (Ontology ontology : list) {
            String prefix = null;
            RDFNode prefixNode = ontology.getPropertyValue((Property)VannVocabulary.preferredNamespacePrefix);
            if (prefixNode != null) {
                prefix = prefixNode.asLiteral().getString();
            } else {
                prefixNode = ontology.getPropertyValue((Property)BindVocabulary.suggestedPrefix);
                String string = prefix = prefixNode == null ? null : prefixNode.asLiteral().getString();
            }
            if (prefix == null) continue;
            RDFNode namespaceNode = ontology.getPropertyValue((Property)VannVocabulary.preferredNamespaceUri);
            String namespaceURI = namespaceNode == null ? ontology.getURI() : namespaceNode.asLiteral().getString();
            String label = ontology.getLabel(null);
            String ontologyURI = ontology.getURI();
            if (label == null) {
                RDFNode labelNode = ontology.getPropertyValue((Property)DublinCoreTerms.title);
                if (labelNode == null) {
                    labelNode = ontology.getPropertyValue((Property)DublinCoreElements.title);
                }
                if (labelNode != null) {
                    label = labelNode.asLiteral().getString();
                }
            }
            OntologyInfo info = new OntologyInfo();
            info.setOntologyURI(ontologyURI);
            info.setPrefix(prefix);
            info.setNamespaceUri(namespaceURI);
            info.setLabel(label);
            this.add(info);
        }
    }

    public String getQName(String uri) {
        int slash;
        int hash = uri.lastIndexOf(35);
        int delim = Math.max(hash, slash = uri.lastIndexOf(47));
        String namespaceURI = uri.substring(0, delim + 1);
        OntologyInfo info = this.getOntologyByNamespaceUri(namespaceURI);
        if (info == null) {
            return null;
        }
        String localName = uri.substring(delim + 1);
        return info.getPrefix() + ":" + localName;
    }

    public static String getLocalName(String uri) {
        int hash = uri.lastIndexOf(35);
        int slash = uri.lastIndexOf(47);
        int delim = Math.max(hash, slash);
        String localName = uri.substring(delim + 1);
        return localName;
    }

    public static String getDefaultNamespacePrefix(String uri) {
        int end = uri.length() - 1;
        int start = uri.lastIndexOf(47, end);
        return uri.substring(start + 1, end);
    }

    public static String getNamespace(String uri) {
        int hash = uri.lastIndexOf(35);
        int slash = uri.lastIndexOf(47);
        int delim = Math.max(hash, slash);
        String namespaceURI = uri.substring(0, delim + 1);
        return namespaceURI;
    }

    public OntClass getElementType(OntClass listType) {
        List superList = listType.listSuperClasses(true).toList();
        for (OntClass superType : superList) {
            Restriction restriction;
            if (!superType.isRestriction() || !(restriction = superType.asRestriction()).isAllValuesFromRestriction() || !restriction.onProperty(RDF.first)) continue;
            AllValuesFromRestriction allValues = restriction.asAllValuesFromRestriction();
            return (OntClass)allValues.getAllValuesFrom().as(OntClass.class);
        }
        return null;
    }

    public void add(ListType listType) {
        this.add((Frame)listType);
        this.listURI2ListType.put(listType.getUri(), listType);
        this.elemURI2ListType.put(listType.getElementType().getUri(), listType);
    }

    public ListType getListTypeByElementUri(String uri) {
        return this.elemURI2ListType.get(uri);
    }

    public ListType getListTypeByListUri(String uri) {
        return this.listURI2ListType.get(uri);
    }

    public void add(OntologyInfo info) {
        OntologyInfo oldInfo = this.uri2Ontology.get(info.getNamespaceUri());
        if (oldInfo != null) {
            OntologyType type = oldInfo.getType() == OntologyType.XSD || info.getType() == OntologyType.XSD ? OntologyType.XSD : OntologyType.RDF;
            info.setType(type);
            oldInfo.setType(type);
        } else {
            this.uri2Ontology.put(info.getNamespaceUri(), info);
        }
    }

    public OntologyInfo getOntologyByNamespaceUri(String uri) {
        return this.uri2Ontology.get(uri);
    }

    public Collection<OntologyInfo> listOntologies() {
        return this.uri2Ontology.values();
    }

    public void add(Frame frame) {
        this.uri2Frame.put(frame.getUri(), frame);
    }

    public void add(Datatype datatype) {
        this.uri2Datatype.put(datatype.getUri(), datatype);
    }

    public Datatype getDatatypeByUri(String uri) {
        Datatype type = this.uri2Datatype.get(uri);
        if (type == null) {
            String namespace = TypeManager.getNamespace(uri);
            if (type == null && (this.isStandardDatatype(namespace) || uri.startsWith(RDFS_INFO.getNamespaceUri()))) {
                OntClass ontClass;
                type = new Datatype();
                type.setUri(uri);
                type.setLocalName(TypeManager.getLocalName(uri));
                if (!namespace.equals(XSD_INFO) && !namespace.equals((Object)OntologyType.RDF) && (ontClass = this.ontModel.getOntClass(uri)) != null) {
                    List superList = ontClass.listSuperClasses().toList();
                    for (OntClass superClass : superList) {
                        Datatype base;
                        String superNamespace = superClass.getNameSpace();
                        if (this.isStandard(superNamespace) && !this.isStandardDatatype(superNamespace) || superClass == null || (base = this.getDatatypeByUri(superClass.getURI())) == null) continue;
                        type.setBase(base);
                    }
                }
                this.add(type);
            }
        }
        return type;
    }

    public Collection<Datatype> listDatatypes() {
        return this.uri2Datatype.values();
    }

    public Frame getFrameByUri(String uri) {
        return this.uri2Frame.get(uri);
    }

    public RdfType getTypeByURI(String uri) {
        RdfType type = this.getFrameByUri(uri);
        if (type == null) {
            type = this.getDatatypeByUri(uri);
        }
        return type;
    }

    public Collection<Frame> listFrames() {
        return this.uri2Frame.values();
    }

    public Collection<ListType> listListTypes() {
        return this.listURI2ListType.values();
    }

    public List<Frame> listFramesInOntology(String ontologyURI) {
        ArrayList<Frame> result = new ArrayList<Frame>();
        for (Frame frame : this.listFrames()) {
            if (!frame.getUri().startsWith(ontologyURI)) continue;
            result.add(frame);
        }
        return result;
    }
}

