/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.api.impl;

import com.hp.hpl.jena.vocabulary.XSD;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.OntologyInfo;
import org.semantictools.frame.model.OntologyType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DatatypeReader {
    private TypeManager typeManager;

    public DatatypeReader(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void read(InputStream input) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        XmlHandler handler = new XmlHandler();
        reader.setContentHandler(handler);
        parser.parse(input, (DefaultHandler)handler);
    }

    class XmlHandler
    extends DefaultHandler {
        private Map<String, String> namespaceMap = new HashMap<String, String>();
        private String targetNamespace;
        private String shortName;
        private String typeURI;
        private String baseURI;
        private Integer length;
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private Number maxInclusive;
        private Number minInclusive;
        private Number maxExclusive;
        private Number minExclusive;
        private Integer totalDigits;
        private Integer fractionDigits;
        private NumberType numberType = NumberType.NONE;
        private StringBuilder characters;
        private OntologyInfo ontInfo;

        XmlHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("schema".equals(localName)) {
                this.targetNamespace = this.toRdfNamespace(attributes.getValue("targetNamespace"));
                this.ontInfo = new OntologyInfo();
                this.ontInfo.setOntologyURI(this.targetNamespace);
                this.ontInfo.setNamespaceUri(this.targetNamespace);
                this.ontInfo.setType(OntologyType.XSD);
                this.parseNamespaces(attributes);
            } else if ("simpleType".equals(localName)) {
                this.shortName = attributes.getValue("name");
                this.typeURI = this.toURI(this.shortName);
            } else if ("restriction".equals(localName)) {
                this.baseURI = this.toURI(attributes.getValue("base"));
                this.setNumberType();
            } else if ("length".equals(localName)) {
                this.length = Integer.valueOf(attributes.getValue("value"));
            } else if ("maxExclusive".equals(localName)) {
                this.maxExclusive = this.getNumber(attributes.getValue("value"));
            } else if ("minExclusive".equals(localName)) {
                this.minExclusive = this.getNumber(attributes.getValue("value"));
            } else if ("maxInclusive".equals(localName)) {
                this.maxInclusive = this.getNumber(attributes.getValue("value"));
            } else if ("minInclusive".equals(localName)) {
                this.minInclusive = this.getNumber(attributes.getValue("value"));
            } else if ("factionDigits".equals(localName)) {
                this.fractionDigits = Integer.valueOf(attributes.getValue("value"));
            } else if ("maxLength".equals(localName)) {
                this.maxLength = Integer.valueOf(attributes.getValue("value"));
            } else if ("minLength".equals(localName)) {
                this.minLength = Integer.valueOf(attributes.getValue("value"));
            } else if ("totalDigits".equals(localName)) {
                this.totalDigits = Integer.valueOf(attributes.getValue("value"));
            } else if ("pattern".equals(localName)) {
                this.pattern = attributes.getValue("value");
            } else if ("label".equals(localName) || "prefix".equals(localName)) {
                this.characters = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.characters != null) {
                this.characters.append(ch, start, length);
            }
        }

        private void setNumberType() {
            if (XSD.decimal.getURI().equals(this.baseURI) || XSD.xdouble.getURI().equals(this.baseURI)) {
                this.numberType = NumberType.DOUBLE;
            } else if (XSD.xfloat.getURI().equals(this.baseURI)) {
                this.numberType = NumberType.FLOAT;
            } else if (XSD.integer.getURI().equals(this.baseURI) || XSD.nonPositiveInteger.getURI().equals(this.baseURI) || XSD.nonNegativeInteger.getURI().equals(this.baseURI) || XSD.unsignedInt.getURI().equals(this.baseURI)) {
                this.numberType = NumberType.INT;
            } else if (XSD.xlong.getURI().equals(this.baseURI) || XSD.unsignedLong.getURI().equals(this.baseURI)) {
                this.numberType = NumberType.LONG;
            } else if (XSD.xshort.getURI().equals(this.baseURI) || XSD.unsignedShort.getURI().equals(this.baseURI)) {
                this.numberType = NumberType.SHORT;
            } else if (XSD.xbyte.getURI().equals(this.baseURI) || XSD.unsignedByte.getURI().equals(this.baseURI)) {
                this.numberType = NumberType.BYTE;
            }
        }

        private Number getNumber(String value) {
            Number number = null;
            switch (this.numberType) {
                case BYTE: {
                    number = Byte.valueOf(value);
                    break;
                }
                case DOUBLE: {
                    number = Double.valueOf(value);
                    break;
                }
                case FLOAT: {
                    number = Float.valueOf(value);
                    break;
                }
                case INT: {
                    number = Integer.valueOf(value);
                    break;
                }
                case LONG: {
                    number = Long.valueOf(value);
                    break;
                }
                case SHORT: {
                    number = Short.valueOf(value);
                }
            }
            return number;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("label".equals(localName) && this.characters != null) {
                this.ontInfo.setLabel(this.characters.toString());
            }
            if ("prefix".equals(localName) && this.characters != null) {
                this.ontInfo.setPrefix(this.characters.toString());
            }
            if (this.typeURI != null && "simpleType".equals(localName)) {
                Datatype type = new Datatype();
                type.setLocalName(this.shortName);
                type.setUri(this.typeURI);
                type.setLength(this.length);
                type.setFractionDigits(this.fractionDigits);
                type.setMaxExclusive(this.maxExclusive);
                type.setMaxInclusive(this.maxInclusive);
                type.setMinInclusive(this.minInclusive);
                type.setMinExclusive(this.minExclusive);
                type.setMaxExclusive(this.maxExclusive);
                type.setMinLength(this.minLength);
                type.setMaxLength(this.maxLength);
                type.setPattern(this.pattern);
                type.setTotalDigits(this.totalDigits);
                if (this.baseURI != null) {
                    Datatype base = DatatypeReader.this.typeManager.getDatatypeByUri(this.baseURI);
                    if (base == null) {
                        String baseName = this.getLocalName(this.baseURI);
                        base = new Datatype();
                        base.setLocalName(baseName);
                        base.setUri(this.baseURI);
                        DatatypeReader.this.typeManager.add(base);
                    }
                    type.setBase(base);
                }
                DatatypeReader.this.typeManager.add(type);
                this.pattern = null;
                this.shortName = null;
                this.baseURI = null;
                this.typeURI = null;
                this.totalDigits = null;
                this.minLength = null;
                this.maxLength = null;
                this.fractionDigits = null;
                this.length = null;
                this.minInclusive = null;
                this.maxInclusive = null;
                this.minExclusive = null;
                this.maxExclusive = null;
                this.numberType = NumberType.NONE;
            }
            this.characters = null;
        }

        @Override
        public void endDocument() {
            DatatypeReader.this.typeManager.add(this.ontInfo);
            this.ontInfo = null;
        }

        private String getLocalName(String uri) {
            int hash = uri.lastIndexOf(35);
            int slash = uri.lastIndexOf(47);
            int delim = Math.max(hash, slash);
            return uri.substring(delim + 1);
        }

        private String toURI(String value) {
            int colon = value.indexOf(58);
            return colon < 0 ? this.targetNamespace + value : this.namespaceMap.get(value.substring(0, colon)) + value.substring(colon + 1);
        }

        private String toRdfNamespace(String uri) {
            return uri.endsWith("/") || uri.endsWith("#") ? uri : uri + "#";
        }

        private void parseNamespaces(Attributes attributes) {
            String targetNamespacePrefix = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                if (!name.startsWith("xmlns:")) continue;
                String prefix = name.substring(6);
                String value = this.toRdfNamespace(attributes.getValue(i));
                this.namespaceMap.put(prefix, value);
                if (!value.equals(this.targetNamespace)) continue;
                targetNamespacePrefix = prefix;
            }
            if (targetNamespacePrefix == null) {
                targetNamespacePrefix = this.defaultNamespacePrefix(this.targetNamespace);
            }
            this.ontInfo.setPrefix(targetNamespacePrefix);
        }

        private String defaultNamespacePrefix(String uri) {
            char last = uri.charAt(uri.length() - 1);
            int end = last == '#' || last == '/' ? uri.length() - 1 : uri.length();
            int start = uri.lastIndexOf(47, end - 1) + 1;
            String prefix = uri.substring(start, end);
            return prefix;
        }
    }

    static enum NumberType {
        FLOAT,
        DOUBLE,
        INT,
        LONG,
        SHORT,
        BYTE,
        NONE;

    }
}

