/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.model;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;
import org.semantictools.bind.BindOntology;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Encapsulation;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.FrameUtil;
import org.semantictools.frame.model.InverseProperty;
import org.semantictools.frame.model.ListType;
import org.semantictools.frame.model.RdfType;

public class Field {
    private Frame frame;
    private OntProperty property;
    private OntResource type;
    private String comment;
    private int minCardinality = 0;
    private int maxCardinality = -1;
    private OntProperty inverseOf;
    private RdfType rdfType;
    private Encapsulation encapsulation = null;
    private InverseProperty inverse;

    public Field(Frame frame, OntProperty property, OntResource type, int minCardinality, int maxCardinality) {
        this.frame = frame;
        this.property = property;
        this.type = type;
        this.minCardinality = minCardinality;
        this.maxCardinality = maxCardinality;
    }

    public Field(Frame frame, OntProperty property, ListType listType) {
        this(frame, property, (OntResource)listType.getOntClass(), 0, 1);
        this.rdfType = listType;
    }

    public Frame getDeclaringFrame() {
        return this.frame;
    }

    public OntProperty getInverseOf() {
        return this.inverseOf;
    }

    public Field getInverseField() {
        if (this.inverseOf != null) {
            Frame otherFrame = this.frame.getTypeManager().getFrameByUri(this.type.getURI());
            if (otherFrame == null) {
                return null;
            }
            String inverseURI = this.inverseOf.getURI();
            List<Field> otherFields = otherFrame.getDeclaredFields();
            for (Field field : otherFields) {
                OntProperty p = field.getProperty();
                if (p == null || !p.getURI().equals(inverseURI)) continue;
                return field;
            }
        }
        return null;
    }

    public InverseProperty getInverseProperty() {
        if (this.inverse == null) {
            this.analyzeAssociationQualifier();
        }
        return this.inverse;
    }

    public void setInverseOf(OntProperty inverseOf) {
        this.inverseOf = inverseOf;
    }

    public Encapsulation getEncapsulation() {
        if (this.encapsulation == null) {
            this.analyzeAssociationQualifier();
        }
        return this.encapsulation;
    }

    private void analyzeAssociationQualifier() {
        this.encapsulation = Encapsulation.NONE;
        this.inverse = new InverseProperty();
        if (this.property == null) {
            return;
        }
        OntClass ontClass = this.frame.getType();
        List list = ontClass.listSuperClasses().toList();
        for (OntClass superClass : list) {
            RDFNode unbounded;
            RDFNode max;
            RDFNode min;
            Resource inverseType;
            Resource onProperty;
            if (!superClass.hasRDFType((Resource)BindOntology.AssociationQualifier, true) || !this.property.equals(onProperty = superClass.getPropertyResourceValue((Property)BindOntology.onProperty))) continue;
            Resource associationType = superClass.getPropertyResourceValue((Property)BindOntology.associationType);
            if (BindOntology.Aggregation.equals(associationType)) {
                this.encapsulation = Encapsulation.AGGREGATION;
            }
            if (BindOntology.Composition.equals(associationType)) {
                this.encapsulation = Encapsulation.COMPOSITION;
            }
            if (BindOntology.Aggregation.equals(inverseType = superClass.getPropertyResourceValue((Property)BindOntology.inverseAssociationType))) {
                this.inverse.setEncapsulation(Encapsulation.AGGREGATION);
            }
            if (BindOntology.Composition.equals(inverseType)) {
                this.inverse.setEncapsulation(Encapsulation.COMPOSITION);
            }
            if ((min = superClass.getPropertyValue((Property)BindOntology.inverseMinCardinality)) != null) {
                this.inverse.setMinCardinality(min.asLiteral().getInt());
            }
            if ((max = superClass.getPropertyValue((Property)BindOntology.inverseMinCardinality)) != null) {
                this.inverse.setMaxCardinality(max.asLiteral().getInt());
            }
            if ((unbounded = superClass.getPropertyValue((Property)BindOntology.inverseUnboundedCardinality)) == null) continue;
            this.inverse.setUnboundedCardinality(unbounded.asLiteral().getBoolean());
        }
    }

    public void setEncapsulation(Encapsulation encapsulation) {
        this.encapsulation = encapsulation;
    }

    public String getLocalName() {
        return this.property.getLocalName();
    }

    public String getComment() {
        if (this.comment == null) {
            this.comment = FrameUtil.getPropertyDescription(this.property);
            if (this.comment == null) {
                this.comment = "";
            }
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getURI() {
        return this.property.getURI();
    }

    public OntProperty getProperty() {
        return this.property;
    }

    public RdfType getRdfType() {
        if (this.rdfType == null) {
            TypeManager manager = this.frame.getTypeManager();
            this.rdfType = manager.getFrameByUri(this.type.getURI());
            if (this.rdfType == null) {
                this.rdfType = manager.getDatatypeByUri(this.type.getURI());
            }
            if (this.rdfType == null) {
                this.rdfType = manager.getListTypeByListUri(this.type.getURI());
            }
            if (this.type.getURI().startsWith(RDF.getURI())) {
                Frame f = new Frame(this.frame.getTypeManager(), (OntClass)this.type.as(OntClass.class));
                this.frame.getTypeManager().add(f);
                this.rdfType = f;
            }
        }
        return this.rdfType;
    }

    public OntResource getType() {
        return this.type;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMinCardinality(int value) {
        this.minCardinality = value;
    }

    public void setMaxCardinality(int value) {
        this.maxCardinality = value;
    }

    public String getMultiplicity() {
        return this.minCardinality == 0 && this.maxCardinality < 0 ? "*" : (this.minCardinality == this.maxCardinality ? Integer.toString(this.minCardinality) : (this.maxCardinality < 0 ? this.minCardinality + "..*" : this.minCardinality + ".." + this.maxCardinality));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLocalName());
        builder.append(":");
        builder.append(this.type.getLocalName());
        builder.append("[");
        builder.append(this.getMultiplicity());
        builder.append("]");
        return builder.toString();
    }
}

