/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.model;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Enumeration;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.FrameUtil;
import org.semantictools.frame.model.ListType;
import org.semantictools.frame.model.NamedIndividual;
import org.semantictools.frame.model.RdfType;
import org.semantictools.frame.model.RestCategory;

public class Frame
implements Comparable<Frame>,
RdfType {
    private TypeManager typeManager;
    protected OntClass type;
    private RestCategory category = RestCategory.UNKNOWN;
    private List<Frame> supertypeList = new ArrayList<Frame>();
    private List<Frame> subtypeList = new ArrayList<Frame>();
    private List<Field> declaredFields = new ArrayList<Field>();
    private List<Datatype> subdatatypeList = new ArrayList<Datatype>();
    private boolean isAbstract = false;
    private Map<String, OntClass> propertyUri2Restriction = new HashMap<String, OntClass>();

    public Frame(TypeManager typeManager, OntClass type) {
        this.typeManager = typeManager;
        this.type = type;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public RestCategory getCategory() {
        return this.category;
    }

    public void setCategory(RestCategory category) {
        this.category = category;
    }

    public List<NamedIndividual> listInstances(boolean direct) {
        ArrayList<NamedIndividual> list = new ArrayList<NamedIndividual>();
        ExtendedIterator sequence = this.type.listInstances(direct);
        while (sequence.hasNext()) {
            list.add(new NamedIndividual((OntResource)sequence.next()));
        }
        return list;
    }

    public String getComment() {
        String result = FrameUtil.getClassDescription((OntResource)this.type);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getUri() {
        return this.type.getURI();
    }

    public void addRestriction(OntClass restriction) {
        Resource property = restriction.getPropertyResourceValue(OWL.onProperty);
        this.propertyUri2Restriction.put(property.getURI(), restriction);
    }

    public OntClass getRestriction(String propertyURI) {
        return this.propertyUri2Restriction.get(propertyURI);
    }

    public List<OntClass> listRestrictions() {
        return new ArrayList<OntClass>(this.propertyUri2Restriction.values());
    }

    @Override
    public String getLocalName() {
        return this.type.getLocalName();
    }

    public OntClass getType() {
        return this.type;
    }

    public void setType(OntClass type) {
        this.type = type;
    }

    public List<Frame> getSubtypeList() {
        return this.subtypeList;
    }

    public List<Frame> listAllSubtypes() {
        ArrayList<Frame> list = new ArrayList<Frame>();
        this.addSubtypes(list, this);
        return list;
    }

    private void addSubtypes(List<Frame> list, Frame frame) {
        for (Frame sub : frame.getSubtypeList()) {
            if (list.contains(sub)) continue;
            list.add(sub);
            this.addSubtypes(list, sub);
        }
    }

    public List<Frame> listAllSupertypes() {
        HashSet<Frame> set = new HashSet<Frame>();
        this.addSupertypes(this, set);
        ArrayList<Frame> list = new ArrayList<Frame>(set);
        return list;
    }

    private void addSupertypes(Frame frame, Set<Frame> set) {
        for (Frame type : frame.getSupertypeList()) {
            if (set.contains(type)) continue;
            set.add(type);
            this.addSupertypes(type, set);
        }
    }

    public List<Frame> getSupertypeList() {
        return this.supertypeList;
    }

    public List<Field> getDeclaredFields() {
        return this.declaredFields;
    }

    public List<Field> listAllFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        this.addFields(this.declaredFields, fieldMap, list);
        this.addSuperFields(fieldMap, list, this);
        return list;
    }

    public boolean hasFields() {
        if (!this.declaredFields.isEmpty()) {
            return true;
        }
        for (Frame superType : this.supertypeList) {
            if (!superType.hasFields()) continue;
            return true;
        }
        return false;
    }

    private void addSuperFields(Map<String, Field> fieldMap, List<Field> list, Frame frame) {
        for (Frame parent : frame.supertypeList) {
            this.addFields(parent.declaredFields, fieldMap, list);
            this.addSuperFields(fieldMap, list, parent);
        }
    }

    private void addFields(List<Field> source, Map<String, Field> fieldMap, List<Field> sink) {
        for (Field field : source) {
            if (fieldMap.containsKey(field.getURI())) continue;
            fieldMap.put(field.getURI(), field);
            sink.add(field);
        }
    }

    public String toMultilineString() {
        return this.toString(true);
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean multiline) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLocalName());
        builder.append("{");
        String comma = multiline ? "\n  " : "";
        List<Field> list = this.listAllFields();
        for (Field field : list) {
            builder.append(comma);
            builder.append(field.toString());
            comma = multiline ? ",\n  " : ", ";
        }
        if (multiline) {
            builder.append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int compareTo(Frame peer) {
        String yourName;
        String myName = this.getLocalName();
        int result = myName.compareTo(yourName = peer.getLocalName());
        if (result == 0) {
            String myURI = this.getUri();
            String yourURI = peer.getUri();
            result = myURI.compareTo(yourURI);
        }
        return result;
    }

    @Override
    public boolean canAsOntClass() {
        return true;
    }

    @Override
    public boolean canAsFrame() {
        return true;
    }

    @Override
    public boolean canAsDatatype() {
        return false;
    }

    @Override
    public OntClass asOntClass() {
        return this.type;
    }

    @Override
    public Frame asFrame() {
        return this;
    }

    @Override
    public Datatype asDatatype() {
        return null;
    }

    @Override
    public boolean canAsListType() {
        return false;
    }

    @Override
    public ListType asListType() {
        return null;
    }

    @Override
    public String getNamespace() {
        return this.type.getNameSpace();
    }

    public void addSubdatatype(Datatype value) {
        this.subdatatypeList.add(value);
    }

    public List<Datatype> getSubdatatypeList() {
        return this.subdatatypeList;
    }

    @Override
    public boolean canAsEnumeration() {
        return false;
    }

    @Override
    public Enumeration asEnumeration() {
        return null;
    }
}

