/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.frame.model;

import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;
import org.semantictools.vocab.SKOS;

public class FrameUtil {
    public static String getClassDescription(OntResource resource) {
        String value = FrameUtil.getDescription(resource);
        if (value == null) {
            ArrayList<OntResource> list = new ArrayList<OntResource>();
            list.add(resource);
            value = FrameUtil.breadthFirstDescription(RDFS.subClassOf, list);
        }
        return value;
    }

    public static String getPropertyDescription(OntProperty property) {
        String value = FrameUtil.getDescription((OntResource)property);
        if (value == null) {
            ArrayList<OntResource> list = new ArrayList<OntResource>();
            list.add((OntResource)property);
            value = FrameUtil.breadthFirstDescription(RDFS.subPropertyOf, list);
        }
        return value;
    }

    private static String breadthFirstDescription(Property relation, List<OntResource> list) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<OntResource> next = new ArrayList<OntResource>();
        for (OntResource type : list) {
            StmtIterator sequence = type.listProperties(relation);
            while (sequence.hasNext()) {
                Statement s = (Statement)sequence.next();
                Resource subject = s.getSubject();
                if (subject.equals((Object)type) || !subject.canAs(OntResource.class)) continue;
                OntResource superType = (OntResource)subject.as(OntResource.class);
                String value = FrameUtil.getDescription(superType);
                if (value == null) {
                    next.add(superType);
                    continue;
                }
                return value;
            }
        }
        return FrameUtil.breadthFirstDescription(relation, next);
    }

    public static String getDescription(OntResource resource) {
        RDFNode node = resource.getPropertyValue(DCTerms.description);
        if (node != null && node.canAs(Literal.class)) {
            return node.asLiteral().getString();
        }
        node = resource.getPropertyValue((Property)SKOS.definition);
        if (node != null && node.canAs(Literal.class)) {
            return node.asLiteral().getString();
        }
        return resource.getComment(null);
    }
}

