/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.graphics;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.semantictools.graphics.ArcEnd;
import org.semantictools.graphics.GraphicsUtil;
import org.semantictools.graphics.Style;
import org.semantictools.graphics.Transformer;

public class Arc {
    private ArcEnd[] ends;

    public Arc(ArcEnd a, ArcEnd b) {
        this.ends = new ArcEnd[]{a, b};
        a.setArc(this);
        b.setArc(this);
    }

    public ArcEnd[] getEnds() {
        return this.ends;
    }

    public ArcEnd getOtherEnd(ArcEnd end) {
        return end == this.ends[0] ? this.ends[1] : (end == this.ends[1] ? this.ends[0] : null);
    }

    public void paint(Graphics2D g) {
        switch (this.ends[0].getEdge()) {
            case RIGHT: {
                this.paintFromRightEdge(g);
                break;
            }
            case TOP: {
                this.paintFromTopEdge(g);
                break;
            }
            case LEFT: {
                this.paintFromLeftEdge(g);
                break;
            }
            case BOTTOM: {
                this.paintFromBottomEdge(g);
            }
        }
    }

    private void paintFromBottomEdge(Graphics2D g) {
        switch (this.ends[1].getEdge()) {
            case TOP: {
                this.paintFromBottomToTop(g);
            }
        }
    }

    private void paintFromTopEdge(Graphics2D g) {
        switch (this.ends[1].getEdge()) {
            case BOTTOM: {
                this.paintFromTopToBottom(g);
            }
        }
    }

    private void paintFromRightEdge(Graphics2D g) {
        switch (this.ends[1].getEdge()) {
            case LEFT: {
                this.paintFromRightToLeft(g);
            }
        }
    }

    private void paintFromLeftEdge(Graphics2D g) {
        switch (this.ends[1].getEdge()) {
            case RIGHT: {
                this.paintFromLeftToRight(g);
            }
        }
    }

    private void paintFromBottomToTop(Graphics2D g) {
        g.setTransform(new AffineTransform());
        Transformer t0 = new Transformer(this.ends[0].getParent());
        Transformer t1 = new Transformer(this.ends[1].getParent());
        int xe0 = this.ends[0].getArcX();
        int ye0 = this.ends[0].getArcY();
        int xe1 = this.ends[1].getArcX();
        int ye1 = this.ends[1].getArcY();
        int x1 = t0.x(xe0, ye0);
        int y1 = t0.y(xe0, ye0);
        int x4 = t1.x(xe1, ye1);
        int y4 = t1.y(xe1, ye1);
        int x2 = x1;
        int y2 = (y1 + y4) / 2;
        int x3 = x4;
        int y3 = y2;
        Style style = this.ends[0].getStyle();
        g.setColor(style.getBorderColor());
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, x3, y3);
        g.drawLine(x3, y3, x4, y4);
        this.paintEnd(g, this.ends[0]);
        this.paintEnd(g, this.ends[1]);
    }

    private void paintFromTopToBottom(Graphics2D g) {
        g.setTransform(new AffineTransform());
        Transformer t0 = new Transformer(this.ends[0].getParent());
        Transformer t1 = new Transformer(this.ends[1].getParent());
        int xe0 = this.ends[0].getArcX();
        int ye0 = this.ends[0].getArcY();
        int xe1 = this.ends[1].getArcX();
        int ye1 = this.ends[1].getArcY();
        int x1 = t0.x(xe0, ye0);
        int y1 = t0.y(xe0, ye0);
        int x4 = t1.x(xe1, ye1);
        int y4 = t1.y(xe1, ye1);
        int x2 = x1;
        int y2 = (y1 + y4) / 2;
        int x3 = x4;
        int y3 = y2;
        Style style = this.ends[0].getStyle();
        g.setColor(style.getBorderColor());
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, x3, y3);
        g.drawLine(x3, y3, x4, y4);
        this.paintEnd(g, this.ends[0]);
        this.paintEnd(g, this.ends[1]);
    }

    private void paintFromLeftToRight(Graphics2D g) {
        AffineTransform save = new AffineTransform(g.getTransform());
        g.setTransform(new AffineTransform());
        ArcEnd e0 = this.ends[0];
        ArcEnd e1 = this.ends[1];
        Transformer t0 = new Transformer(e0.getParent());
        Transformer t1 = new Transformer(e1.getParent());
        int xe0 = this.ends[0].getArcX();
        int ye0 = this.ends[0].getArcY();
        int xe1 = this.ends[1].getArcX();
        int ye1 = this.ends[1].getArcY();
        int x1 = t0.x(xe0, ye0);
        int y1 = t0.y(xe0, ye0);
        int x4 = t1.x(xe1, ye1);
        int y4 = t1.y(xe1, ye1);
        if (x4 < x1) {
            int temp = x4;
            x4 = x1;
            x1 = temp;
            temp = y4;
            y4 = y1;
            y1 = temp;
            ArcEnd e = e1;
            e1 = e0;
            e0 = e;
            t0 = t1;
        }
        int x2e0 = e0.getX() + e0.getBounds().getWidth();
        int y2e0 = e0.getY();
        int x2 = t0.x(x2e0, y2e0);
        int y2 = t0.y(x2e0, y2e0);
        int x3 = x2;
        int y3 = y4;
        Style style = this.ends[0].getStyle();
        g.setColor(style.getBorderColor());
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, x3, y3);
        g.drawLine(x3, y3, x4, y4);
        this.paintEnd(g, this.ends[0]);
        this.paintEnd(g, this.ends[1]);
        g.setTransform(save);
    }

    private void paintFromRightToLeft(Graphics2D g) {
        AffineTransform save = new AffineTransform(g.getTransform());
        Transformer t0 = new Transformer(this.ends[0].getParent());
        Transformer t1 = new Transformer(this.ends[1].getParent());
        int xe0 = this.ends[0].getArcX();
        int ye0 = this.ends[0].getArcY();
        int x2e0 = this.ends[0].getX() + this.ends[0].getBounds().getWidth();
        int y2e0 = this.ends[0].getY();
        int x1 = t0.x(xe0, ye0);
        int y1 = t0.y(xe0, ye0);
        int x2 = t0.x(x2e0, y2e0);
        int y2 = t0.y(x2e0, y2e0);
        int xe1 = this.ends[1].getArcX();
        int ye1 = this.ends[1].getArcY();
        int x3 = x2;
        int y3 = t1.y(xe1, ye1);
        int x4 = t1.x(xe1, ye1);
        int y4 = y3;
        Style style = this.ends[0].getStyle();
        g.setColor(style.getBorderColor());
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, x3, y3);
        g.drawLine(x3, y3, x4, y4);
        this.paintEnd(g, this.ends[0]);
        this.paintEnd(g, this.ends[1]);
        g.setTransform(save);
    }

    private void paintEnd(Graphics2D g, ArcEnd end) {
        GraphicsUtil.setTransform(g, end.getParent());
        end.paint(g);
    }
}

