/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.graphics;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.semantictools.graphics.Arc;
import org.semantictools.graphics.BaseRect;
import org.semantictools.graphics.Edge;
import org.semantictools.graphics.Rect;
import org.semantictools.graphics.Style;
import org.semantictools.graphics.Widget;

public class ArcEnd
implements Widget {
    public static final Shape DIAMOND = ArcEnd.createDiamond();
    public static final Shape TRIANGLE = ArcEnd.createTriangle();
    private Arc arc;
    private Shape shape;
    private boolean filled;
    private int tipX;
    private int tipY;
    private int arcX;
    private int arcY;
    private Edge edge;
    private String title;
    private String subtitle;
    private int titleX;
    private int titleY;
    private int subtitleX;
    private int subtitleY;
    private Style style;
    private Rect bounds = new BaseRect();
    private Widget attachedWidget;

    private static Shape createDiamond() {
        int height = 4;
        int width = 22;
        int center = width / 2;
        int[] x = new int[]{0, center, width, center};
        int[] y = new int[]{0, -height, 0, height};
        return new Polygon(x, y, 4);
    }

    private static Shape createTriangle() {
        int[] x = new int[]{0, 20, 20};
        int[] y = new int[]{0, -8, 8};
        return new Polygon(x, y, 3);
    }

    public ArcEnd(String title, String subtitle, Style style) {
        this.title = title;
        this.subtitle = subtitle;
        this.style = style;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public int getArcX() {
        return this.arcX;
    }

    public void setArcX(int arcX) {
        this.arcX = arcX;
    }

    public int getArcY() {
        return this.arcY;
    }

    public void setArcY(int arcY) {
        this.arcY = arcY;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }

    public int getX() {
        return this.tipX;
    }

    public void setX(int x) {
        this.tipX = x;
    }

    public int getY() {
        return this.tipY;
    }

    public void setY(int y) {
        this.tipY = y;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public Arc getArc() {
        return this.arc;
    }

    public void setArc(Arc arc) {
        this.arc = arc;
    }

    public int getAscent() {
        int result = 0;
        if (this.title != null) {
            int padTop = this.style.getPadTop();
            int padBottom = this.style.getPadBottom();
            int ascent = this.style.getMetrics().getMaxAscent();
            result += padBottom + ascent + padTop;
        }
        return result;
    }

    public int getDescent() {
        int result = 0;
        if (this.subtitle != null) {
            int padTop = this.style.getPadTop();
            int padBottom = this.style.getPadBottom();
            int ascent = this.style.getMetrics().getMaxAscent();
            result += padBottom + ascent + padTop;
        }
        return result;
    }

    public void attachAt(int x, int y) {
        this.tipX = x;
        this.tipY = y;
        Edge edge = this.getEdge();
        switch (edge) {
            case RIGHT: {
                this.attachRight();
                break;
            }
            case LEFT: {
                this.attachLeft();
                break;
            }
            case TOP: {
                this.attachTop();
                break;
            }
            case BOTTOM: {
                this.attachBottom();
            }
        }
    }

    public Widget getAttachedWidget() {
        return this.attachedWidget;
    }

    public void attachTo(Widget attachedWidget) {
        this.attachedWidget = attachedWidget;
    }

    private void attachLeft() {
        FontMetrics metrics = this.style.getMetrics();
        int shapeWidth = 0;
        int width = 0;
        int top = this.tipY;
        int bottom = this.tipY;
        this.arcX = this.tipX;
        this.arcY = this.tipY;
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            shapeWidth = (int)bounds.getWidth();
            int height = (int)(bounds.getHeight() / 2.0);
            top = this.tipY - height - this.style.getPadTop();
            bottom = this.tipY + height + this.style.getPadBottom();
            this.arcX = this.tipX - shapeWidth;
        }
        if (this.title != null) {
            int textWidth = metrics.stringWidth(this.title);
            this.titleX = this.arcX - this.style.getPadRight() - textWidth;
            this.titleY = this.arcY - this.style.getPadBottom();
            width = textWidth;
            top = Math.min(top, this.titleY - metrics.getMaxAscent() - this.style.getPadTop());
        }
        if (this.subtitle != null) {
            int textWidth = metrics.stringWidth(this.subtitle);
            this.subtitleX = this.arcX - this.style.getPadRight() - textWidth;
            this.subtitleY = this.arcY + this.style.getPadTop() + metrics.getMaxAscent();
            width = Math.max(width, textWidth);
            bottom = Math.max(bottom, this.subtitleY + metrics.getMaxDescent() + this.style.getPadBottom());
        }
        width = shapeWidth + width + this.style.getPadLeft() + this.style.getPadRight();
        int height = bottom - top;
        this.bounds.setTop(top);
        this.bounds.setLeft(this.tipX);
        this.bounds.setHeight(height);
        this.bounds.setWidth(width);
    }

    private void attachTop() {
        this.arcX = this.tipX;
        this.arcY = this.tipY;
        this.bounds.setPosition(this.tipX, this.tipY);
        this.bounds.setWidth(0);
        this.bounds.setHeight(0);
    }

    private void attachBottom() {
        this.arcX = this.tipX;
        this.arcY = this.tipY;
        this.bounds.setPosition(this.tipX, this.tipY);
        this.bounds.setWidth(0);
        this.bounds.setHeight(0);
        if (this.shape != null) {
            int width = (int)this.shape.getBounds2D().getHeight();
            int height = (int)this.shape.getBounds2D().getWidth();
            this.arcY += height;
            this.bounds.setHeight(height);
            this.bounds.setWidth(width);
        }
    }

    public void translate(int dx, int dy) {
        this.arcX += dx;
        this.arcY += dy;
        this.bounds.setPosition(this.bounds.getLeft() + dx, this.bounds.getTop() + dy);
        this.subtitleX += dx;
        this.subtitleY += dy;
        this.tipX += dx;
        this.tipY += dy;
        this.titleX += dx;
        this.titleY += dy;
    }

    private void attachRight() {
        FontMetrics metrics = this.style.getMetrics();
        int shapeWidth = 0;
        int width = 0;
        int top = this.tipY;
        int bottom = this.tipY;
        this.arcX = this.tipX;
        this.arcY = this.tipY;
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            shapeWidth = (int)bounds.getWidth();
            int height = (int)(bounds.getHeight() / 2.0);
            this.arcX = this.tipX + shapeWidth;
            top = this.tipY - height - this.style.getPadTop();
            bottom = this.tipY + height + this.style.getPadBottom();
        }
        if (this.title != null) {
            this.titleX = this.arcX + this.style.getPadLeft();
            this.titleY = this.arcY - this.style.getPadBottom();
            width = metrics.stringWidth(this.title);
            top = Math.min(top, this.arcY - metrics.getMaxAscent() - this.style.getPadTop());
        }
        if (this.subtitle != null) {
            this.subtitleX = this.arcX + this.style.getPadLeft();
            this.subtitleY = this.arcY + this.style.getPadTop() + metrics.getMaxAscent();
            width = Math.max(width, metrics.stringWidth(this.subtitle));
            bottom = Math.max(bottom, this.subtitleY + metrics.getMaxDescent() + this.style.getPadBottom());
        }
        int height = bottom - top;
        this.bounds.setTop(top);
        this.bounds.setLeft(this.tipX);
        this.bounds.setHeight(height);
        this.bounds.setWidth(width += shapeWidth + this.style.getPadLeft() + this.style.getPadRight());
    }

    public Edge getEdge() {
        if (this.attachedWidget == null) {
            throw new RuntimeException("ArcEnd is not attached to any widget");
        }
        if (this.edge == null) {
            Rect bounds = this.attachedWidget.getBounds();
            this.edge = this.tipX == 0 ? Edge.LEFT : (this.tipX == bounds.getWidth() ? Edge.RIGHT : (this.tipY == 0 ? Edge.TOP : Edge.BOTTOM));
        }
        return this.edge;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.title != null) {
            g.setColor(this.style.getColor());
            g.setFont(this.style.getFont());
            g.drawString(this.title, this.titleX, this.titleY);
        }
        if (this.subtitle != null) {
            g.setColor(this.style.getColor());
            g.setFont(this.style.getFont());
            g.drawString(this.subtitle, this.subtitleX, this.subtitleY);
        }
        if (this.shape != null) {
            this.paintShape(g);
        }
    }

    private void paintShape(Graphics2D g) {
        g.setColor(this.style.getBorderColor());
        AffineTransform tx = new AffineTransform(g.getTransform());
        g.translate(this.tipX, this.tipY);
        switch (this.edge) {
            case BOTTOM: {
                g.rotate(1.5707963267948966);
                break;
            }
            case TOP: {
                g.rotate(-1.5707963267948966);
            }
        }
        g.draw(this.shape);
        if (this.filled) {
            g.fill(this.shape);
        }
        g.setTransform(tx);
    }

    @Override
    public Rect getBounds() {
        return this.bounds;
    }

    @Override
    public void layout() {
        this.attachAt(this.tipX, this.tipY);
    }

    @Override
    public void setPosition(int left, int top) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Widget getParent() {
        return this.attachedWidget;
    }

    @Override
    public void setParent(Widget parent) {
        this.attachedWidget = parent;
    }

    public String toString() {
        return "ArcEnd(x=" + this.tipX + ", y=" + this.tipY + ")";
    }
}

