/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.semantictools.graphics.ArcEnd;
import org.semantictools.graphics.BaseRect;
import org.semantictools.graphics.GraphicsUtil;
import org.semantictools.graphics.HasConnectors;
import org.semantictools.graphics.Rect;
import org.semantictools.graphics.Style;
import org.semantictools.graphics.Transformer;
import org.semantictools.graphics.Widget;

public class ConnectableWidget
extends BaseRect
implements HasConnectors,
Widget {
    private Style style;
    private ArcList leftArcs;
    private ArcList rightArcs;
    private ArcList topArcs;
    private ArcList bottomArcs;
    private Widget body;
    private Widget parent;
    private int routeSpacing = 10;

    public ConnectableWidget(Widget body, Style style) {
        this.style = style;
        this.body = body;
        body.setParent(this);
    }

    public Widget getBody() {
        return this.body;
    }

    @Override
    public List<ArcEnd> listLeftArcs() {
        return this.leftArcs;
    }

    @Override
    public List<ArcEnd> listTopArcs() {
        return this.topArcs;
    }

    @Override
    public List<ArcEnd> listRightArcs() {
        return this.rightArcs;
    }

    @Override
    public List<ArcEnd> listBottomArcs() {
        return this.bottomArcs;
    }

    @Override
    public void addLeftArc(ArcEnd end) {
        if (this.leftArcs == null) {
            this.leftArcs = new ArcList();
        }
        this.leftArcs.add(end);
        end.attachTo(this);
    }

    @Override
    public void addRightArc(ArcEnd end) {
        if (this.rightArcs == null) {
            this.rightArcs = new ArcList();
        }
        this.rightArcs.add(end);
        end.attachTo(this);
    }

    @Override
    public void addTopArc(ArcEnd end) {
        if (this.topArcs == null) {
            this.topArcs = new ArcList();
        }
        this.topArcs.add(end);
        end.attachTo(this);
    }

    @Override
    public void addBottomArc(ArcEnd end) {
        if (this.bottomArcs == null) {
            this.bottomArcs = new ArcList();
        }
        this.bottomArcs.add(end);
        end.attachTo(this);
    }

    @Override
    public void layout() {
        this.body.layout();
        int bodyWidth = this.body.getBounds().getWidth();
        int bodyHeight = this.body.getBounds().getHeight();
        this.setWidth(bodyWidth);
        this.setHeight(bodyHeight);
        int height = this.computeArcHeight(this.rightArcs, bodyWidth);
        height = Math.max(height, this.computeArcHeight(this.leftArcs, 0));
        int width = this.computeArcWidth(this.topArcs, 0);
        width = Math.max(width, this.computeArcWidth(this.bottomArcs, bodyHeight));
        if (height > bodyHeight) {
            this.setHeight(height);
        }
        this.attachRight();
        this.attachLeft();
        this.attachTop();
        this.attachBottom();
    }

    private void attachTop() {
        if (this.topArcs == null || this.topArcs.isEmpty()) {
            return;
        }
        this.attachHorizontal(this.topArcs, 0);
    }

    private void attachBottom() {
        if (this.bottomArcs == null || this.bottomArcs.isEmpty()) {
            return;
        }
        this.attachHorizontal(this.bottomArcs, this.getHeight());
    }

    private void attachLeft() {
        if (this.leftArcs == null || this.leftArcs.isEmpty()) {
            return;
        }
        this.attachVertical(this.leftArcs, 0);
    }

    private void attachRight() {
        if (this.rightArcs == null || this.rightArcs.isEmpty()) {
            return;
        }
        this.attachVertical(this.rightArcs, this.getWidth());
    }

    public void setEndWidths(List<ArcEnd> arcList) {
        this.setEndWidthsFromTop(arcList);
        this.setEndWidthsFromBottom(arcList);
    }

    private void setEndWidthsFromBottom(List<ArcEnd> arcList) {
        if (arcList == null) {
            return;
        }
        int w = 0;
        for (int index = arcList.size() - 1; index >= 0; --index) {
            ArcEnd e0 = arcList.get(index);
            ArcEnd e1 = e0.getArc().getOtherEnd(e0);
            Transformer t0 = new Transformer(e0.getAttachedWidget());
            Transformer t1 = new Transformer(e1.getAttachedWidget());
            int ex0 = e0.getArcX();
            int ey0 = e0.getArcY();
            int ex1 = e1.getArcX();
            int ey1 = e1.getArcY();
            int x0 = t0.x(ex0, ey0);
            int y0 = t0.y(ex0, ey0);
            int x1 = t1.x(ex1, ey1);
            int y1 = t1.y(ex1, ey1);
            if (x1 < x0) {
                int y = y1;
                y1 = y0;
                y0 = y;
                e0 = e1;
            }
            if (y1 < y0) break;
            w = Math.max(w, e0.getBounds().getWidth());
            if (index != arcList.size() - 1) {
                w += this.routeSpacing;
            }
            e0.getBounds().setWidth(w);
        }
    }

    private void setEndWidthsFromTop(List<ArcEnd> arcList) {
        if (arcList == null) {
            return;
        }
        int w = 0;
        for (int index = 0; index < arcList.size(); ++index) {
            ArcEnd e0 = arcList.get(index);
            ArcEnd e1 = e0.getArc().getOtherEnd(e0);
            Transformer t0 = new Transformer(e0.getAttachedWidget());
            Transformer t1 = new Transformer(e1.getAttachedWidget());
            int ex0 = e0.getArcX();
            int ey0 = e0.getArcY();
            int ex1 = e1.getArcX();
            int ey1 = e1.getArcY();
            int x0 = t0.x(ex0, ey0);
            int y0 = t0.y(ex0, ey0);
            int x1 = t1.x(ex1, ey1);
            int y1 = t1.y(ex1, ey1);
            if (x1 < x0) {
                int y = y1;
                y1 = y0;
                y0 = y;
                e0 = e1;
            }
            if (y1 >= y0) break;
            w = Math.max(w, e0.getBounds().getWidth());
            if (index > 0) {
                w += this.routeSpacing;
            }
            e0.getBounds().setWidth(w);
        }
    }

    private void attachVertical(ArcList arcList, int x) {
        int middle = this.getHeight() / 2;
        int halfSpan = arcList.getHalfSpan();
        int y = middle - halfSpan;
        int marginBottom = 0;
        int delta = 0;
        for (ArcEnd end : arcList) {
            int marginTop = end.getStyle().getMarginTop();
            int margin = Math.max(marginBottom, marginTop);
            int ascent = end.getAscent();
            if (delta != 0) {
                y += margin + ascent;
            }
            end.attachAt(x, y);
            if ((y += end.getDescent()) >= middle && delta > 0) {
                delta = 0;
            }
            if (y <= middle) {
                delta = this.routeSpacing;
                continue;
            }
            delta -= this.routeSpacing;
        }
    }

    private void attachHorizontal(ArcList arcList, int yEdge) {
        int center = this.getWidth() / 2;
        int halfSpan = arcList.getHalfSpan();
        int x = center - halfSpan;
        int dy = 0;
        int marginRight = 0;
        int delta = 0;
        for (ArcEnd end : arcList) {
            int marginLeft = end.getStyle().getMarginLeft();
            int margin = Math.max(marginRight, marginLeft);
            int dx = end.getX() - end.getBounds().getLeft();
            if (delta != 0) {
                x += margin + dx;
            }
            end.attachAt(x, yEdge);
            end.layout();
            if (x >= center && delta > 0) {
                delta = 0;
            }
            int endHeight = end.getBounds().getHeight() + (dy += delta);
            end.getBounds().setHeight(endHeight);
            if (x <= center) {
                delta = this.routeSpacing;
                continue;
            }
            delta -= this.routeSpacing;
        }
    }

    private int computeArcWidth(ArcList arcList, int yEdge) {
        if (arcList == null || arcList.isEmpty()) {
            return 0;
        }
        int marginRight = 0;
        int center = this.getWidth() / 2;
        int x = 0;
        int x1 = 0;
        int x2 = 0;
        for (ArcEnd end : arcList) {
            int marginLeft = end.getStyle().getMarginLeft();
            int margin = Math.max(marginLeft, marginRight);
            end.attachAt(center, yEdge);
            end.layout();
            int endLeft = end.getBounds().getLeft();
            int endRight = end.getBounds().getRight();
            int endX = end.getX();
            int dx = endX - endLeft;
            x2 = x + margin + dx;
            if (x1 == 0) {
                x1 = x2;
            }
            x = x2 + endRight - endX;
            marginRight = end.getStyle().getMarginRight();
        }
        int width = x2 - x1;
        arcList.setSpan(width);
        this.setHorizontalHalfSpan(arcList);
        return width += 2 * this.routeSpacing;
    }

    private void setHorizontalHalfSpan(ArcList arcList) {
        int size = arcList.size();
        int span = arcList.getSpan();
        int halfSpan = span / 2;
        boolean even = size % 2 == 0;
        int x0 = ((ArcEnd)arcList.get(0)).getX();
        int middle = x0 + halfSpan;
        for (int i = 0; i < size; ++i) {
            ArcEnd end = (ArcEnd)arcList.get(i);
            int x = end.getX();
            if (x == middle) {
                halfSpan = x - x0;
                break;
            }
            if (x <= middle) continue;
            if (even) {
                halfSpan = (x + ((ArcEnd)arcList.get(i - 1)).getX()) / 2 - x0;
                break;
            }
            halfSpan = x - x0;
            break;
        }
        arcList.setHalfSpan(halfSpan);
    }

    private int computeArcHeight(ArcList arcList, int x) {
        if (arcList == null || arcList.isEmpty()) {
            return 0;
        }
        int marginBottom = 0;
        int y = 0;
        int y1 = 0;
        int y2 = 0;
        int tempY = this.getTop() + 1;
        int maxEndSpan = 0;
        for (ArcEnd end : arcList) {
            int marginTop = end.getStyle().getMarginTop();
            int margin = Math.max(marginBottom, marginTop);
            y2 = y + margin + end.getAscent();
            if (y1 == 0) {
                y1 = y2;
            }
            end.attachAt(x, tempY);
            maxEndSpan = Math.max(maxEndSpan, end.getBounds().getWidth());
            end.setY(y2);
            y = y2 + end.getDescent();
            marginBottom = end.getStyle().getMarginBottom();
        }
        int height = y2 - y1;
        arcList.setMaxEndSpan(maxEndSpan);
        arcList.setSpan(height);
        this.setVerticalHalfSpan(arcList);
        return height += 2 * this.routeSpacing;
    }

    private void setVerticalHalfSpan(ArcList arcList) {
        int size = arcList.size();
        int span = arcList.getSpan();
        int halfSpan = span / 2;
        boolean even = size % 2 == 0;
        int y0 = ((ArcEnd)arcList.get(0)).getY();
        int middle = y0 + halfSpan;
        int titleCount = 0;
        for (int i = 0; i < size; ++i) {
            int y;
            ArcEnd end = (ArcEnd)arcList.get(i);
            if (end.getTitle() != null) {
                ++titleCount;
            }
            if ((y = end.getY()) == middle) {
                halfSpan = y - y0;
                break;
            }
            if (y <= middle) continue;
            if (even) {
                halfSpan = (y + ((ArcEnd)arcList.get(i - 1)).getY()) / 2 - y0;
                break;
            }
            halfSpan = y - y0;
            break;
        }
        if (titleCount == 0 || titleCount == size) {
            arcList.setHalfSpan(halfSpan);
        } else {
            arcList.setHalfSpan(span / 2);
        }
    }

    @Override
    public void setPosition(int left, int top) {
        this.setLeft(left);
        this.setTop(top);
    }

    public void paintArcs(Graphics2D g, List<ArcEnd> list) {
        if (list == null) {
            return;
        }
        for (ArcEnd end : list) {
            end.getArc().paint(g);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Color bgColor = this.style.getBgColor();
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(0, 0, width, height);
        }
        GraphicsUtil.paint(g, this.body);
        Color borderColor = this.style.getBorderColor();
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawRect(0, 0, width, height);
        }
    }

    @Override
    public Rect getBounds() {
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public Widget getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Widget parent) {
        this.parent = parent;
    }

    static class ArcList
    extends ArrayList<ArcEnd> {
        private int span;
        private int halfSpan;
        private int maxEndSpan;

        ArcList() {
        }

        public int getSpan() {
            return this.span;
        }

        public void setSpan(int span) {
            this.span = span;
        }

        public void setHalfSpan(int s) {
            this.halfSpan = s;
        }

        public int getHalfSpan() {
            return this.halfSpan;
        }

        public int getMaxEndSpan() {
            return this.maxEndSpan;
        }

        public void setMaxEndSpan(int maxEndSpan) {
            this.maxEndSpan = maxEndSpan;
        }
    }
}

