/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.graphics;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.semantictools.graphics.BaseRect;
import org.semantictools.graphics.GraphicsUtil;
import org.semantictools.graphics.Rect;
import org.semantictools.graphics.Style;
import org.semantictools.graphics.Widget;

public class HorizontalPanel
extends BaseRect
implements Widget {
    private List<Widget> children = new ArrayList<Widget>();
    private Style style;
    private Widget parent;

    public void add(Widget child) {
        this.children.add(child);
        child.setParent(this);
    }

    public Widget getWidget(int index) {
        return this.children.get(index);
    }

    @Override
    public void paint(Graphics2D g) {
        for (Widget w : this.children) {
            GraphicsUtil.paint(g, w);
        }
    }

    @Override
    public Rect getBounds() {
        return this;
    }

    @Override
    public void layout() {
        int top = 0;
        int x = 0;
        int height = 0;
        if (this.children.isEmpty()) {
            return;
        }
        int marginRight = 0;
        for (Widget w : this.children) {
            int marginLeft = w.getStyle().getMarginLeft();
            int margin = Math.max(marginLeft, marginRight);
            if (x == 0) {
                margin = 0;
            }
            w.setPosition(x += margin, top);
            w.layout();
            marginRight = w.getStyle().getMarginRight();
            height = w.getBounds().getHeight();
            if (height > this.getHeight()) {
                this.setHeight(height);
            }
            if ((x += w.getBounds().getWidth()) <= this.getWidth()) continue;
            this.setWidth(x);
        }
    }

    public int getWidgetCount() {
        return this.children.size();
    }

    public List<Widget> getChildren() {
        return this.children;
    }

    @Override
    public void setPosition(int left, int top) {
        this.setLeft(left);
        this.setTop(top);
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public Widget getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Widget parent) {
        this.parent = parent;
    }
}

