/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.graphics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import org.semantictools.graphics.BaseRect;
import org.semantictools.graphics.Rect;
import org.semantictools.graphics.Style;
import org.semantictools.graphics.Widget;

public class Label
extends BaseRect
implements Widget {
    private String text;
    private int textX;
    private int textY;
    private Style style;
    private Widget parent;

    public Label(String text, Style style) {
        this.text = text;
        this.style = style;
    }

    @Override
    public void layout() {
        FontMetrics metrics = this.style.getMetrics();
        int ascent = metrics.getMaxAscent();
        int padLeft = this.style.getPadLeft();
        int padTop = this.style.getPadTop();
        int padRight = this.style.getPadRight();
        int padBottom = this.style.getPadBottom();
        int textWidth = metrics.stringWidth(this.text);
        int height = padTop + ascent + padBottom;
        int width = padLeft + textWidth + padRight;
        this.setWidth(width);
        this.setHeight(height);
        this.textX = padLeft;
        this.textY = padTop + ascent;
    }

    @Override
    public void setPosition(int left, int top) {
        this.setLeft(left);
        this.setTop(top);
    }

    @Override
    public void paint(Graphics2D g) {
        Font font = this.getStyle().getFont();
        if (font != null) {
            g.setFont(font);
        }
        g.setColor(this.getStyle().getColor());
        g.drawString(this.text, this.textX, this.textY);
    }

    @Override
    public Rect getBounds() {
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public Widget getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Widget parent) {
        this.parent = parent;
    }

    @Override
    public String toString() {
        return "Label(text='" + this.text + "', x=" + this.textX + ", y=" + this.textY + ", left=" + this.getBounds().getLeft() + ", top=" + this.getBounds().getTop() + ", width=" + this.getBounds().getWidth() + ", height=" + this.getBounds().getHeight() + ")";
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }
}

