/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.graphics;

import org.semantictools.graphics.Widget;

public class Transformer {
    private int dx;
    private int dy;

    public Transformer(int dx, int dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public Transformer(Widget w) {
        this.set(w);
    }

    public int x(int x0, int y0) {
        return x0 + this.dx;
    }

    public int y(int x0, int y0) {
        return y0 + this.dy;
    }

    public int getDx() {
        return this.dx;
    }

    public void setDx(int dx) {
        this.dx = dx;
    }

    public int getDy() {
        return this.dy;
    }

    public void setDy(int dy) {
        this.dy = dy;
    }

    public void translate(int dx, int dy) {
        this.dx += dx;
        this.dy += dy;
    }

    public void push(Widget widget) {
        int dx = widget.getBounds().getLeft();
        int dy = widget.getBounds().getTop();
        this.translate(dx, dy);
    }

    public void pop(Widget widget) {
        int dx = -widget.getBounds().getLeft();
        int dy = -widget.getBounds().getTop();
        this.translate(dx, dy);
    }

    public void setTranslation(int dx, int dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void set(Widget widget) {
        while (widget != null) {
            this.push(widget);
            widget = widget.getParent();
        }
    }

    public String toString() {
        return "Transformer(dx=" + this.dx + ", dy=" + this.dy + ")";
    }
}

