/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.graphics;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.semantictools.graphics.BaseRect;
import org.semantictools.graphics.GraphicsUtil;
import org.semantictools.graphics.Rect;
import org.semantictools.graphics.Style;
import org.semantictools.graphics.Widget;

public class VerticalPanel
extends BaseRect
implements Widget {
    private List<Widget> children = new ArrayList<Widget>();
    private Style style;
    private Widget parent;

    public void add(Widget child) {
        this.children.add(child);
        child.setParent(this);
    }

    public Widget getWidget(int index) {
        return this.children.get(index);
    }

    @Override
    public void paint(Graphics2D graphics) {
        for (Widget w : this.children) {
            GraphicsUtil.paint(graphics, w);
        }
    }

    @Override
    public Rect getBounds() {
        return this;
    }

    @Override
    public void layout() {
        int y = 0;
        int marginBottom = 0;
        boolean addMargin = false;
        for (Widget w : this.children) {
            int marginTop = w.getStyle().getMarginTop();
            int margin = Math.max(marginBottom, marginTop);
            if (addMargin) {
                y += margin;
            }
            addMargin = true;
            w.setPosition(0, y);
            w.layout();
            y += w.getBounds().getHeight();
            int width = w.getBounds().getWidth();
            if (width > this.getWidth()) {
                this.setWidth(width);
            }
            this.setHeight(y);
            marginBottom = w.getStyle().getMarginBottom();
        }
        if (this.style != null) {
            int height = this.getHeight() + this.style.getPadBottom();
            this.setHeight(height);
        }
    }

    public int getWidgetCount() {
        return this.children.size();
    }

    public List<Widget> getChildren() {
        return this.children;
    }

    @Override
    public void setPosition(int left, int top) {
        this.setLeft(left);
        this.setTop(top);
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public Widget getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Widget parent) {
        this.parent = parent;
    }
}

