/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.gwt.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.semantictools.gwt.generator.ConfigParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GwtTypeConfig {
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String USE_JAVASCRIPT_OBJECT = "useJavaScriptObject";
    private Set<String> includes = new HashSet<String>();
    private Set<String> useJavaScriptObject = new HashSet<String>();
    private Set<String> excludeProperty = new HashSet<String>();

    public Set<String> getIncludes() {
        return this.includes;
    }

    public boolean includeType(String typeURI) {
        return this.includes.isEmpty() || this.includes.contains(typeURI);
    }

    public void addType(String typeURI) {
        this.includes.add(typeURI);
    }

    public boolean useJavaScriptObject(String typeURI, String propertyLocalName) {
        return this.useJavaScriptObject.contains(typeURI + "!" + propertyLocalName);
    }

    public boolean excludeProperty(String typeURI, String propertyLocalName) {
        return this.excludeProperty.contains(typeURI + "!" + propertyLocalName);
    }

    public void load(File file) throws IOException, ConfigParseException {
        String name = file.getName();
        if (name.endsWith(".properties")) {
            this.parseProperties(file);
        } else if (name.endsWith(".xml")) {
            try {
                this.parseXml(file);
            }
            catch (ParserConfigurationException e) {
                throw new ConfigParseException(e);
            }
            catch (SAXException e) {
                throw new ConfigParseException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseProperties(File file) throws IOException {
        Properties properties = new Properties();
        FileInputStream input = new FileInputStream(file);
        try {
            properties.load(input);
            this.parseProperties(properties);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    private void parseXml(File file) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document doc = builder.parse(file);
        this.parseXml(doc);
    }

    private void parseXml(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            String name;
            Node n = list.item(i);
            if (!(n instanceof Element) || !INCLUDE.equals(name = (e = (Element)n).getTagName())) continue;
            this.parseInclude(e);
        }
    }

    private void parseInclude(Element e) {
        NodeList list = e.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            Element child = (Element)n;
            StringBuilder buffer = new StringBuilder();
            buffer.append(child.getNamespaceURI());
            buffer.append(child.getLocalName());
            String uri = buffer.toString();
            this.addType(uri);
            this.parseTypeConfig(uri, child);
        }
    }

    private void parseTypeConfig(String typeURI, Element type) {
        NodeList list = type.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            String name = n.getNodeName();
            if (USE_JAVASCRIPT_OBJECT.equals(name)) {
                this.parseUseJavaScriptObject(typeURI, (Element)n);
            }
            if (!EXCLUDE.equals(name)) continue;
            this.parseExcludeProperties(typeURI, (Element)n);
        }
    }

    private void parseExcludeProperties(String typeURI, Element container) {
        NodeList list = container.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String localName = e.getLocalName();
            StringBuilder builder = new StringBuilder();
            builder.append(typeURI);
            builder.append('!');
            builder.append(localName);
            String path = builder.toString();
            this.excludeProperty.add(path);
        }
    }

    private void parseUseJavaScriptObject(String typeURI, Element container) {
        NodeList list = container.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String localName = e.getLocalName();
            StringBuilder builder = new StringBuilder();
            builder.append(typeURI);
            builder.append('!');
            builder.append(localName);
            String path = builder.toString();
            this.useJavaScriptObject.add(path);
        }
    }

    public void scan(File dir) throws IOException, ConfigParseException {
        if (dir.isDirectory()) {
            File[] list = dir.listFiles();
            for (int i = 0; i < list.length; ++i) {
                this.scan(list[i]);
            }
        } else if ("gwt.properties".equals(dir.getName()) || "gwt.xml".equals(dir.getName())) {
            this.load(dir);
        }
    }

    private void parseProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getKey().toString();
            if (!INCLUDE.equals(key)) continue;
            this.setInclude(value);
        }
    }

    private void setInclude(String value) {
        StringTokenizer tokens = new StringTokenizer(value, " \t\r\n");
        while (tokens.hasMoreTokens()) {
            this.includeType(tokens.nextToken());
        }
    }
}

