/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.gwt.generator;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.semantictools.frame.api.DatatypeUtil;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.BindVocabulary;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Enumeration;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.NamedIndividual;
import org.semantictools.frame.model.RdfType;
import org.semantictools.gwt.generator.GwtTypeConfig;
import org.semantictools.gwt.generator.GwtTypeGeneratorListener;
import org.semantictools.gwt.generator.StringUtil;
import org.semantictools.gwt.generator.WriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtTypeGenerator {
    private static Logger logger = LoggerFactory.getLogger(GwtTypeGenerator.class);
    private TypeManager typeManager;
    private WriterFactory writerFactory;
    private Map<String, String> uri2JavaName = new HashMap<String, String>();
    private Map<String, ClassInfo> classInfoMap = new HashMap<String, ClassInfo>();
    private Map<String, ModuleInfo> moduleInfoMap = new HashMap<String, ModuleInfo>();
    private GwtTypeGeneratorListener listener;
    private GwtTypeConfig config;

    public GwtTypeGenerator(GwtTypeConfig config, TypeManager typeManager, WriterFactory writerFactory) {
        this.config = config;
        this.typeManager = typeManager;
        this.writerFactory = writerFactory;
    }

    public GwtTypeGeneratorListener getListener() {
        return this.listener;
    }

    public void setListener(GwtTypeGeneratorListener listener) {
        this.listener = listener;
    }

    public void generateAll() throws IOException {
        for (Frame frame : this.typeManager.listFrames()) {
            String uri = frame.getUri();
            if (!this.config.includeType(uri)) {
                if (this.listener == null) continue;
                this.listener.ignoreType(uri);
                continue;
            }
            if (this.listener != null) {
                this.listener.beginType(uri);
            }
            if (frame.canAsEnumeration()) {
                this.generateEnum(frame.asEnumeration());
                continue;
            }
            this.generateFrame(frame);
        }
        this.generateModules();
    }

    private void generateModules() throws IOException {
        for (ModuleInfo module : this.moduleInfoMap.values()) {
            this.generateModule(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModule(ModuleInfo module) throws IOException {
        String path = module.getModuleName().replace(".", "/") + ".gwt.xml";
        PrintWriter writer = this.writerFactory.getPrintWriter(path);
        try {
            ModuleWriter worker = new ModuleWriter(writer, module);
            worker.printModule();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateEnum(Enumeration type) throws IOException {
        logger.debug("Generate... " + type.getUri());
        ClassInfo info = this.getClassInfo(type);
        String filePath = info.getJavaName().replace('.', '/') + ".java";
        PrintWriter out = this.writerFactory.getPrintWriter(filePath);
        try {
            ClassWriter writer = new ClassWriter(out, info);
            writer.printEnum();
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFrame(Frame frame) throws IOException {
        logger.debug("Generate... " + frame.getUri());
        ClassInfo info = this.getClassInfo(frame);
        this.collectImports(info);
        String filePath = info.getJavaName().replace('.', '/') + ".java";
        PrintWriter out = this.writerFactory.getPrintWriter(filePath);
        try {
            ClassWriter writer = new ClassWriter(out, info);
            writer.printClass();
        }
        finally {
            out.close();
        }
    }

    private void collectImports(ClassInfo info) {
        info.addImport("com.google.gwt.core.client.JavaScriptObject");
        if (info.hasSingleSupertype()) {
            Frame superType = info.getSingleSupertype();
            ClassInfo superInfo = this.getClassInfo(superType);
            info.addImport(superInfo);
        }
        Frame frame = info.getRdfType().asFrame();
        String frameURI = frame.getUri();
        List<Field> fieldList = frame.getDeclaredFields();
        for (Field field : fieldList) {
            String typeURI;
            RdfType type = field.getRdfType();
            String fieldName = field.getLocalName();
            if (field.getMaxCardinality() != 1 && !this.config.excludeProperty(frameURI, fieldName)) {
                info.addImport("com.google.gwt.core.client.JsArray");
            }
            if (!type.canAsFrame() || !this.config.includeType(typeURI = type.getUri()) || this.config.useJavaScriptObject(frameURI, fieldName)) continue;
            ClassInfo fieldInfo = this.getClassInfo(type);
            info.addImport(fieldInfo);
        }
    }

    private ClassInfo getClassInfo(RdfType frame) {
        ClassInfo info = this.classInfoMap.get(frame.getUri());
        if (info == null) {
            ModuleInfo moduleInfo = this.getModuleInfo(frame.getNamespace());
            String packageName = moduleInfo.getPackageName() + ".client";
            info = new ClassInfo(moduleInfo, packageName, frame);
            this.classInfoMap.put(frame.getUri(), info);
        }
        return info;
    }

    private ModuleInfo getModuleInfo(String namespaceURI) {
        ModuleInfo info = this.moduleInfoMap.get(namespaceURI);
        if (info == null) {
            String modulePackage = this.toJavaName(namespaceURI);
            info = new ModuleInfo(modulePackage, "DataModel");
            this.moduleInfoMap.put(namespaceURI, info);
        }
        return info;
    }

    private String toJavaName(String uri) {
        String javaName = this.uri2JavaName.get(uri);
        if (javaName == null) {
            Statement statement;
            OntModel model = this.typeManager.getOntModel();
            Resource resource = model.getResource(uri);
            if (resource != null && (statement = resource.getProperty((Property)BindVocabulary.javaName)) != null && statement.getObject().isLiteral()) {
                javaName = statement.getString();
            }
            if (javaName == null) {
                javaName = this.defaultJavaName(uri);
            }
            this.uri2JavaName.put(uri, javaName);
        }
        return javaName;
    }

    private List<String> listParts(String uri) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(uri, "/#");
        String protocol = tokenizer.nextToken();
        if (!protocol.endsWith(":")) {
            list.add(protocol);
        }
        if (tokenizer.hasMoreTokens()) {
            String domain = tokenizer.nextToken();
            String[] array = domain.split("\\.");
            for (int i = array.length - 1; i >= 0; --i) {
                list.add(array[i]);
            }
        }
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    String defaultJavaName(String namespace) {
        StringBuilder builder = new StringBuilder();
        List<String> list = this.listParts(namespace);
        for (String part : list) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
        return builder.toString();
    }

    static class ClassInfo {
        private ModuleInfo moduleInfo;
        private String packageName;
        private String javaName;
        private RdfType rdfType;
        private Set<String> imports = new HashSet<String>();
        private List<Frame> supertypeList = null;

        public ClassInfo(ModuleInfo moduleInfo, String packageName, RdfType rdfType) {
            this.moduleInfo = moduleInfo;
            this.packageName = packageName;
            this.rdfType = rdfType;
            this.javaName = packageName + "." + rdfType.getLocalName();
        }

        public ModuleInfo getModuleInfo() {
            return this.moduleInfo;
        }

        public List<String> listImports() {
            ArrayList<String> list = new ArrayList<String>(this.imports);
            Collections.sort(list);
            return list;
        }

        public List<Frame> listSupertypes() {
            if (this.supertypeList == null) {
                List<Frame> sourceList = this.rdfType.asFrame().getSupertypeList();
                this.supertypeList = new ArrayList<Frame>();
                for (Frame frame : sourceList) {
                    String uri = frame.getUri();
                    if ("http://www.w3.org/2000/01/rdf-schema#Resource".equals(uri)) continue;
                    this.supertypeList.add(frame);
                }
            }
            return this.supertypeList;
        }

        public boolean hasSingleSupertype() {
            return this.listSupertypes().size() == 1;
        }

        public boolean hasMultipleSupertypes() {
            return this.listSupertypes().size() > 1;
        }

        public Frame getSingleSupertype() {
            List<Frame> list = this.listSupertypes();
            return list.size() > 0 ? list.get(0) : null;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public RdfType getRdfType() {
            return this.rdfType;
        }

        public void addImport(String className) {
            if (className.startsWith(this.packageName) && className.indexOf(46, this.packageName.length()) > 0) {
                return;
            }
            this.imports.add(className);
        }

        public void addImport(ClassInfo importedClass) {
            if (importedClass.getModuleInfo() != this.moduleInfo) {
                String javaName = importedClass.getJavaName();
                this.imports.add(javaName);
                this.moduleInfo.addInherits(importedClass.getModuleInfo());
            }
        }
    }

    static class ModuleInfo {
        private String packageName;
        private String localName;
        private String moduleName;
        private Set<String> inheritSet = new HashSet<String>();

        public ModuleInfo(String packageName, String localName) {
            this.packageName = packageName;
            this.localName = localName;
            this.moduleName = packageName + "." + localName;
            this.inheritSet.add("com.google.gwt.user.User");
            this.inheritSet.add("com.google.gwt.json.JSON");
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void addInherits(ModuleInfo info) {
            if (info != this) {
                this.inheritSet.add(info.getModuleName());
            }
        }

        public Set<String> getInheritSet() {
            return this.inheritSet;
        }
    }

    class ClassWriter
    extends BaseWriter {
        ClassInfo info;

        public ClassWriter(PrintWriter out, ClassInfo info) {
            super(out);
            this.info = info;
        }

        public void printEnum() {
            this.print("package ").print(this.info.getPackageName()).println(";");
            Enumeration type = this.info.getRdfType().asEnumeration();
            this.println();
            this.print("public enum ").print(type.getLocalName()).println(" {");
            this.pushIndent();
            List<NamedIndividual> list = type.getIndividualList();
            for (int i = 0; i < list.size() - 1; ++i) {
                this.indent(list.get(i).getLocalName()).println(",");
            }
            if (!list.isEmpty()) {
                this.indent().println(list.get(list.size() - 1).getLocalName());
            }
            this.popIndent();
            this.println("}");
        }

        public void printClass() {
            this.print("package ").print(this.info.getPackageName()).println(";");
            this.println();
            this.printImports();
            this.beginClass();
            this.pushIndent();
            this.printConstructor();
            this.printCreateMethod();
            this.printFields();
            this.popIndent();
            this.endClass();
        }

        private void printFields() {
            String frameType = this.info.getRdfType().asFrame().getUri();
            if (!this.info.hasSingleSupertype()) {
                this.printLdContextField();
                this.printRdfTypeField();
                this.printResourceUriField();
            }
            List<Field> list = !this.info.hasMultipleSupertypes() ? this.info.getRdfType().asFrame().getDeclaredFields() : this.info.getRdfType().asFrame().listAllFields();
            for (Field field : list) {
                if (GwtTypeGenerator.this.config.excludeProperty(frameType, field.getLocalName())) continue;
                this.printField(field);
            }
        }

        private void printResourceUriField() {
            this.printResourceUriGetter();
            this.printResourceUriSetter();
        }

        private void printResourceUriSetter() {
            this.println();
            this.indent().println("public final native void setResourceUri(String uri) /*-{");
            this.indent().println("  this[\"@id\"] = uri;");
            this.indent().println("}-*/;");
        }

        private void printResourceUriGetter() {
            this.println();
            this.indent().println("public final native String getResourceUri() /*-{");
            this.indent().println("  return this[\"@id\"];");
            this.indent().println("}-*/;");
        }

        private void printRdfTypeField() {
            this.printRdfTypeGetter();
            this.printRdfTypeSetter();
        }

        private void printRdfTypeSetter() {
            this.println();
            this.indent().println("public final native void setRdfType(String type) /*-{");
            this.indent().println("  this[\"@type\"]=type;");
            this.indent().println("}-*/;");
        }

        private void printRdfTypeGetter() {
            this.println();
            this.indent().println("public final native String getRdfType() /*-{");
            this.pushIndent();
            this.indent().println("return this[\"@type\"]");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printLdContextField() {
            this.printLdContextGetter();
            this.printLdContextSetter();
        }

        private void printLdContextSetter() {
            this.println();
            this.indent().println("public final native void setLdContextUri(String uri) /*-{");
            this.pushIndent();
            this.indent().println("this[\"@context\"]=uri;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printLdContextGetter() {
            this.println();
            this.indent().println("public final native String getLdContextUri() /*-{");
            this.pushIndent();
            this.indent().println("if (typeof this[\"@context\"] == \"string\") {");
            this.indent().println("  return this[\"@context\"];");
            this.indent().println("}");
            this.indent().println("return null;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printField(Field field) {
            RdfType type = field.getRdfType();
            if (type.canAsEnumeration()) {
                this.printEnumField(field);
            } else if (type.canAsFrame()) {
                int maxCardinality = field.getMaxCardinality();
                if (maxCardinality == 1) {
                    this.printEntityField(field);
                } else {
                    this.printCollectionField(field);
                }
            } else if (type.canAsDatatype()) {
                this.printDatatypeField(field);
            }
        }

        private void printEnumField(Field field) {
            this.printEnumGetter(field);
            this.printEnumSetter(field);
            this.printEnumNameGetter(field);
            this.printEnumNameSetter(field);
        }

        private void printEnumSetter(Field field) {
            String fieldName = field.getLocalName();
            String fieldType = field.getRdfType().getLocalName();
            String setter = StringUtil.setter(fieldName);
            String nameSetter = setter + "Name";
            this.println();
            this.indent("public final void ").print(setter).print("(").print(fieldType);
            this.println(" value) {");
            this.pushIndent();
            this.indent(nameSetter).println("(value.name());");
            this.popIndent();
            this.indent().println("}");
        }

        private void printEnumGetter(Field field) {
            String fieldName = field.getLocalName();
            String fieldType = field.getRdfType().getLocalName();
            String getter = StringUtil.getter(fieldName);
            String nameGetter = getter + "Name";
            this.println();
            this.indent("public final ").print(fieldType).print(" ").print(getter).println("() {");
            this.pushIndent();
            this.indent("return ").print(fieldType).print(".valueOf(").print(fieldType).print(".class, ");
            this.print(nameGetter).println("());");
            this.popIndent();
            this.indent().println("};");
        }

        private void printEnumNameSetter(Field field) {
            String fieldName = field.getLocalName();
            String setter = StringUtil.setter(fieldName) + "Name";
            this.println();
            this.indent("private final native void ").print(setter).println("(String value) /*-{");
            this.pushIndent();
            this.indent("this.").print(fieldName).println(" = value;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printEnumNameGetter(Field field) {
            String fieldName = field.getLocalName();
            String getter = StringUtil.getter(fieldName) + "Name";
            this.println();
            this.indent("private final native String ").print(getter).println("() /*-{");
            this.pushIndent();
            this.indent("return this.").print(fieldName).println(";");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printDatatypeField(Field field) {
            this.printDatatypeGetter(field);
            this.printDatatypeSetter(field);
        }

        private void printDatatypeSetter(Field field) {
            Datatype type = field.getRdfType().asDatatype();
            String typeName = DatatypeUtil.toGwtType(type);
            String fieldName = field.getLocalName();
            String setter = StringUtil.setter(fieldName);
            this.println();
            this.indent("public final native void ").print(setter).print("(");
            this.print(typeName).println(" value) /*-{");
            this.pushIndent();
            this.indent("this.").print(fieldName).println(" = value;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printDatatypeGetter(Field field) {
            Datatype type = field.getRdfType().asDatatype();
            String typeName = DatatypeUtil.toGwtType(type);
            String fieldName = field.getLocalName();
            String getter = StringUtil.getter(fieldName);
            this.println();
            this.indent("public final native ").print(typeName).print(" ").print(getter);
            this.println("() /*-{");
            this.pushIndent();
            this.indent("return this.").print(fieldName).println(";");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printCollectionField(Field field) {
            String fieldType = null;
            fieldType = OWL.Thing.getURI().equals(field.getRdfType().getUri()) ? "JavaScriptObject" : field.getRdfType().getLocalName();
            this.printCollectionGetter(field, fieldType);
            this.printCollectionSetter(field, fieldType);
        }

        private void printCollectionSetter(Field field, String fieldType) {
            String fieldName = field.getLocalName();
            String setter = StringUtil.setter(fieldName);
            this.println();
            this.indent("public final native void ").print(setter).print("(JsArray<").print(fieldType);
            this.println("> array) /*-{");
            this.pushIndent();
            this.indent("this.").print(fieldName).println(" = array;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printCollectionGetter(Field field, String fieldType) {
            String fieldName = field.getLocalName();
            String getter = StringUtil.getter(fieldName);
            this.println();
            this.indent("public final native JsArray<");
            this.print(fieldType);
            this.print("> ");
            this.print(getter);
            this.println("() /*-{");
            this.pushIndent();
            this.indent("if (typeof this.").print(fieldName).println(" == \"object\") {");
            this.indent("  return [this.").print(fieldName).println("];");
            this.indent("} else if (typeof this.").print(fieldName).println(" == \"string\") {");
            this.indent("  return [{ \"@id\" : this.").print(fieldName).println("}];");
            this.indent().println("}");
            this.indent("return this.").print(fieldName).println(";");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printEntityField(Field field) {
            String ownerURI = field.getDeclaringFrame().getUri();
            RdfType type = field.getRdfType();
            String fieldType = type.getLocalName();
            String fieldName = field.getLocalName();
            if (!GwtTypeGenerator.this.config.includeType(type.getUri()) || GwtTypeGenerator.this.config.useJavaScriptObject(ownerURI, fieldName)) {
                fieldType = "JavaScriptObject";
            }
            this.printEntityGetter(field, fieldType);
            this.printEntitySetter(field, fieldType);
            this.printEntityUriGetter(field);
            this.printEntityUriSetter(field);
        }

        private void printEntityUriSetter(Field field) {
            String fieldName = field.getLocalName();
            String setter = StringUtil.setter(fieldName) + "Uri";
            this.println();
            this.indent().print("public final native void ").print(setter).println("(String uri) /*-{");
            this.pushIndent();
            this.indent("this.").print(fieldName).println(" = uri;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printEntityUriGetter(Field field) {
            String fieldName = field.getLocalName();
            String getter = StringUtil.getter(fieldName) + "Uri";
            this.println();
            this.indent("public final native String ").print(getter).println("() /*-{");
            this.pushIndent();
            this.indent("if (typeof this.").print(fieldName).println(" == \"string\") {");
            this.indent("  return this.").print(fieldName).println(";");
            this.indent().println("}");
            this.indent("if (typeof this.").print(fieldName).println(" == \"object\") {");
            this.indent(" return this.").print(fieldName).println("[\"@id\"];");
            this.indent().println("}");
            this.indent().println("return null;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printEntitySetter(Field field, String typeName) {
            String fieldName = field.getLocalName();
            String setter = StringUtil.setter(fieldName);
            this.println();
            this.indent("public final native void ").print(setter).print("(");
            this.print(typeName).println(" value) /*-{");
            this.pushIndent();
            this.indent("this.").print(fieldName).println(" = value;");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printEntityGetter(Field field, String fieldType) {
            String fieldName = field.getLocalName();
            String getter = StringUtil.getter(fieldName);
            this.println();
            this.indent("public final native ");
            this.print(fieldType);
            this.print(" ");
            this.print(getter);
            this.println("() /*-{");
            this.pushIndent();
            this.indent("if (typeof this.").print(fieldName).println(" == \"string\") {");
            this.pushIndent();
            this.indent("return { \"@id\" : this.").print(fieldName).println("};");
            this.popIndent();
            this.indent().println("}");
            this.indent("return this.");
            this.print(fieldName);
            this.println(";");
            this.popIndent();
            this.indent().println("}-*/;");
        }

        private void printCreateMethod() {
            this.println();
            this.indent("public static ");
            this.print(this.info.getRdfType().getLocalName());
            this.println(" create() {");
            this.pushIndent();
            this.indent().println("return JavaScriptObject.createObject().cast();");
            this.popIndent();
            this.indent().println("}");
        }

        private void printConstructor() {
            this.println();
            this.indent("protected ");
            this.print(this.info.getRdfType().getLocalName());
            this.println("() {}");
        }

        private void beginClass() {
            this.println();
            this.print("public class ");
            this.print(this.info.getRdfType().getLocalName());
            if (this.info.hasSingleSupertype() && GwtTypeGenerator.this.config.includeType(this.info.getSingleSupertype().getUri())) {
                this.print(" extends ");
                String superTypeName = this.info.getSingleSupertype().getLocalName();
                this.print(superTypeName);
                this.println(" {");
            } else {
                this.println(" extends JavaScriptObject {");
            }
        }

        private void endClass() {
            this.println("}");
        }

        private void printImports() {
            for (String pkg : this.info.listImports()) {
                this.print("import ").print(pkg).println(";");
            }
        }
    }

    class ModuleWriter
    extends BaseWriter {
        private ModuleInfo moduleInfo;

        public ModuleWriter(PrintWriter out, ModuleInfo info) {
            super(out);
            this.moduleInfo = info;
        }

        public void printModule() {
            this.println("<module>");
            this.pushIndent();
            this.printInherits();
            this.indent().println("<source path=\"client\"/>");
            this.popIndent();
            this.println("</module>");
        }

        private void printInherits() {
            ArrayList<String> list = new ArrayList<String>(this.moduleInfo.getInheritSet());
            Collections.sort(list);
            for (String name : list) {
                this.indent("<inherits name=\"").print(name).println("\"/>");
            }
        }
    }

    class BaseWriter {
        private PrintWriter out;
        private int indent = 0;

        public BaseWriter(PrintWriter out) {
            this.out = out;
        }

        protected void pushIndent() {
            ++this.indent;
        }

        protected void popIndent() {
            --this.indent;
        }

        protected BaseWriter print(String text) {
            this.out.print(text);
            return this;
        }

        protected void println() {
            this.out.println();
        }

        protected void println(String text) {
            this.out.println(text);
        }

        protected BaseWriter indent() {
            for (int i = 0; i < 2 * this.indent; ++i) {
                this.out.print(' ');
            }
            return this;
        }

        protected BaseWriter indent(String text) {
            this.indent();
            return this.print(text);
        }
    }
}

