/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.index.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.GlobalProperties;
import org.semantictools.context.renderer.model.ServiceDocumentation;
import org.semantictools.context.view.DefaultDocumentPrinter;
import org.semantictools.frame.api.LinkManager;
import org.semantictools.index.api.LinkedDataIndex;
import org.semantictools.index.model.SchemaReference;
import org.semantictools.index.model.ServiceDocumentationList;

public class LinkedDataIndexPrinter
extends DefaultDocumentPrinter {
    private LinkedDataIndex index;
    private LinkManager linkManager;
    private File indexFile;

    public LinkedDataIndexPrinter(File indexFile, LinkedDataIndex index) {
        this.indexFile = indexFile;
        File pubDir = indexFile.getParentFile();
        this.index = index;
        this.linkManager = new LinkManager();
        this.linkManager.setBaseURI(pubDir.toString().replace("\\", "/") + "/");
        pubDir.mkdirs();
        GlobalProperties metadata = new GlobalProperties();
        metadata.setCss("uml/uml.css");
        this.setMetadata(metadata);
    }

    public void printIndex() throws IOException {
        this.clear();
        this.beginHTML();
        this.pushIndent();
        this.printOntologies();
        this.printDatatypes();
        this.printServices();
        this.printMediaTypes();
        this.popIndent();
        this.endHTML();
        this.writeFile();
    }

    private void printMediaTypes() {
        List<ContextProperties> list = this.index.listAllMediaTypes();
        Collections.sort(list);
        this.indent();
        this.println("<H2>Media Types</H2>");
        this.indent();
        this.println("<UL>");
        this.pushIndent();
        for (ContextProperties context : list) {
            String mediaType = context.getMediaType();
            String mediaTypeHref = this.linkManager.relativize(context.getMediaTypeDocFile());
            this.print("<LI>");
            this.printAnchor(mediaTypeHref, mediaType);
            this.println();
        }
        this.popIndent();
        this.indent();
        this.println("</UL>");
    }

    private void printDatatypes() {
        List<SchemaReference> list = this.index.listDatatypes();
        this.indent();
        this.println("<H2>Data Types</H2>");
        this.indent();
        this.println("<UL>");
        this.pushIndent();
        for (SchemaReference r : list) {
            String label = r.getSchemaLabel();
            String href = this.linkManager.relativize(r.getSchemaDocPath());
            this.indent();
            this.print("<LI>");
            this.printAnchor(href, label);
            this.println();
        }
        this.popIndent();
        this.indent();
        this.println("</UL>");
    }

    private void printOntologies() {
        List<SchemaReference> list = this.index.listOntologies();
        Collections.sort(list);
        this.indent();
        this.println("<H2>Ontologies</H2>");
        this.indent();
        this.println("<UL>");
        this.pushIndent();
        for (SchemaReference r : list) {
            String label = r.getSchemaLabel();
            String href = this.linkManager.relativize(r.getSchemaDocPath());
            this.indent();
            this.print("<LI>");
            this.printAnchor(href, label);
            this.println();
        }
        this.popIndent();
        this.indent();
        this.println("</UL>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile() throws IOException {
        FileWriter writer = new FileWriter(this.indexFile);
        try {
            String text = this.popText();
            writer.write(text);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    private void printServices() {
        List<ServiceDocumentationList> megaList = this.index.listServices();
        if (megaList.isEmpty()) {
            return;
        }
        this.indent();
        this.println("<H2>REST Services</H2>");
        this.indent();
        this.println("<UL>");
        this.pushIndent();
        Collections.sort(megaList, new Comparator<ServiceDocumentationList>(){

            @Override
            public int compare(ServiceDocumentationList a, ServiceDocumentationList b) {
                return a.getRdfTypeLocalName().compareTo(b.getRdfTypeLocalName());
            }
        });
        block4: for (ServiceDocumentationList list : megaList) {
            switch (list.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    this.printServiceDocumentation(list.getRdfTypeLocalName(), (ServiceDocumentation)list.get(0));
                    continue block4;
                }
            }
            this.printMultipleServicesForType(list);
        }
        this.popIndent();
        this.println("</UL>");
    }

    private void printServiceDocumentation(String rdfTypeLocalName, ServiceDocumentation serviceDocumentation) {
        this.print("<LI> ");
        String href = this.linkManager.relativize(serviceDocumentation.getServiceDocumentationFile());
        this.printAnchor(href, rdfTypeLocalName + " Service");
        this.println();
        this.popIndent();
    }

    private void printMultipleServicesForType(ServiceDocumentationList list) {
    }
}

