/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.json;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.RdfType;
import org.semantictools.json.JsonPrettyPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonManager {
    private static final Logger logger = LoggerFactory.getLogger(JsonManager.class);
    private Map<String, ObjectNode> typeURI2Node = new HashMap<String, ObjectNode>();
    private Map<String, ObjectNode> id2Node = new HashMap<String, ObjectNode>();
    private JsonContext context;
    private TypeManager typeManager;
    private JsonNodeFactory factory = JsonNodeFactory.instance;

    public JsonManager(TypeManager typeManager, JsonContext context) {
        this.context = context;
        this.typeManager = typeManager;
    }

    public void add(String jsonText) {
        ObjectMapper mapper = new ObjectMapper();
        StringReader reader = new StringReader(jsonText);
        try {
            JsonNode node = (JsonNode)mapper.readValue((Reader)reader, JsonNode.class);
            if (node instanceof ObjectNode) {
                this.add((ObjectNode)node);
            }
        }
        catch (Throwable ignore) {
            logger.warn("Failed to parse json for " + this.context.getMediaType(), ignore);
        }
    }

    public void add(ObjectNode node) {
        JsonNode typeNode = node.get("@type");
        if (typeNode != null) {
            String type = typeNode.asText();
            type = this.context.rewrite(type);
            this.crawl(type, node);
        }
    }

    public ObjectNode getObjectNodeByTypeURI(String typeURI) {
        return this.typeURI2Node.get(typeURI);
    }

    private void crawl(String typeURI, ObjectNode node) {
        ObjectNode prior = this.getObjectNodeByTypeURI(typeURI);
        ObjectNode clone = this.factory.objectNode();
        if (prior == null) {
            this.typeURI2Node.put(typeURI, clone);
        }
        Iterator sequence = node.getFields();
        while (sequence.hasNext()) {
            Map.Entry entry = (Map.Entry)sequence.next();
            String fieldName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value instanceof ObjectNode) {
                ObjectNode objectValue = (ObjectNode)value;
                String fieldTypeURI = this.getType(objectValue, typeURI, fieldName);
                if (fieldTypeURI != null) {
                    this.crawl(fieldTypeURI, objectValue);
                }
                value = this.factory.objectNode();
            } else if (value instanceof ArrayNode) {
                ArrayNode array = (ArrayNode)value;
                this.crawlArray(typeURI, fieldName, array);
                value = this.factory.arrayNode();
            } else if (fieldName.equals("@id")) {
                this.id2Node.put(value.asText(), clone);
            }
            clone.put(fieldName, value);
        }
    }

    public String getJsonText(String typeURI) {
        ObjectNode node = this.typeURI2Node.get(typeURI);
        if (node == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        StringWriter buffer = new StringWriter();
        ObjectWriter writer = mapper.writer((PrettyPrinter)new JsonPrettyPrinter());
        try {
            writer.writeValue((Writer)buffer, (Object)node);
        }
        catch (Throwable oops) {
            return null;
        }
        buffer.flush();
        return buffer.toString();
    }

    private String getType(ObjectNode object, String frameTypeURI, String fieldName) {
        String fieldTypeURI;
        JsonNode type = object.get("@type");
        String string = fieldTypeURI = type == null ? null : this.context.rewrite(type.asText());
        if (fieldTypeURI == null) {
            fieldTypeURI = this.inferFieldType(frameTypeURI, fieldName);
        }
        return fieldTypeURI;
    }

    private void crawlArray(String typeURI, String fieldName, ArrayNode array) {
        int count = array.size();
        for (int i = 0; i < count; ++i) {
            ObjectNode object;
            String objectTypeURI;
            JsonNode value = array.get(i);
            if (!(value instanceof ObjectNode) || (objectTypeURI = this.getType(object = (ObjectNode)value, typeURI, fieldName)) == null) continue;
            this.crawl(objectTypeURI, object);
        }
    }

    private String inferFieldType(String typeURI, String fieldName) {
        String propertyURI = this.context.rewrite(fieldName);
        Frame frame = this.typeManager.getFrameByUri(typeURI);
        if (frame == null) {
            return null;
        }
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            RdfType fieldType = field.getRdfType();
            if (fieldType.canAsListType()) {
                fieldType = fieldType.asListType().getElementType();
            }
            if (!field.getURI().equals(propertyURI)) continue;
            return fieldType.getUri();
        }
        return null;
    }
}

