/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.PrettyPrinter;

public class JsonPrettyPrinter
implements PrettyPrinter {
    private int indent = 0;
    private int tabSize = 2;
    private List<Container> stack = new ArrayList<Container>();

    private void pushIndent(Container container) {
        this.indent += this.tabSize;
        this.stack.add(container);
    }

    private void popIndent() {
        this.indent -= this.tabSize;
        this.stack.remove(this.stack.size() - 1);
    }

    private Container getContainer() {
        return this.stack.size() > 1 ? this.stack.get(this.stack.size() - 2) : Container.OBJECT;
    }

    private void indent(JsonGenerator g) throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            g.writeRaw(' ');
        }
    }

    public void writeRootValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw('\n');
    }

    public void writeStartObject(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw("{");
        this.pushIndent(Container.OBJECT);
    }

    public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException, JsonGenerationException {
        jg.writeRaw("\n");
        this.popIndent();
        this.indent(jg);
        jg.writeRaw("}");
    }

    public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(",\n");
        this.indent(jg);
    }

    public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(" : ");
    }

    public void writeStartArray(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw("[");
        this.pushIndent(Container.ARRAY);
    }

    public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException, JsonGenerationException {
        jg.writeRaw('\n');
        this.popIndent();
        this.indent(jg);
        jg.writeRaw("]");
    }

    public void writeArrayValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(",\n");
        this.indent(jg);
    }

    public void beforeArrayValues(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(" \n");
        this.indent(jg);
    }

    public void beforeObjectEntries(JsonGenerator jg) throws IOException, JsonGenerationException {
        switch (this.getContainer()) {
            case OBJECT: {
                jg.writeRaw('\n');
                this.indent(jg);
                break;
            }
            case ARRAY: {
                jg.writeRaw(' ');
            }
        }
    }

    private static enum Container {
        OBJECT,
        ARRAY;

    }
}

