/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.json;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.FrameConstraints;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.context.renderer.model.TermInfo;
import org.semantictools.frame.api.FrameNotFoundException;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.ListType;
import org.semantictools.frame.model.RdfType;
import org.semantictools.frame.model.RestCategory;
import org.semantictools.json.UnsupportedDatatypeException;

public class JsonSampleGenerator {
    private TypeManager typeManager;
    private JsonContext context;
    private ContextProperties contextProperties;
    private JsonNodeFactory factory;
    private Random random;
    private int maxCyclicDepth = 2;
    private int maxRepeat = 2;

    public JsonSampleGenerator(TypeManager typeManager) {
        this.typeManager = typeManager;
        this.factory = JsonNodeFactory.instance;
        this.random = new Random(new Date().getTime());
    }

    public ObjectNode generateSample(JsonContext context, ContextProperties properties) {
        ObjectNode node = this.factory.objectNode();
        if (context == null) {
            return node;
        }
        this.contextProperties = properties;
        this.context = context;
        this.addContextProperty(node);
        List<String> graphTypes = properties.getGraphTypes();
        if (graphTypes.isEmpty()) {
            Frame frame = this.typeManager.getFrameByUri(context.getRootType());
            Branch branch = new Branch(null, null, node, frame);
            this.addTypeProperty(node, frame);
            this.addProperties(branch);
        } else {
            this.buildGraph(node, graphTypes);
        }
        return node;
    }

    private void buildGraph(ObjectNode node, List<String> graphTypes) {
        ArrayNode array = this.factory.arrayNode();
        node.put("@graph", (JsonNode)array);
        for (String typeURI : graphTypes) {
            Frame frame = this.typeManager.getFrameByUri(typeURI);
            if (frame == null) {
                throw new FrameNotFoundException(typeURI);
            }
            ObjectNode obj = this.factory.objectNode();
            array.add((JsonNode)obj);
            this.addTypeProperty(obj, frame);
            Branch branch = new Branch(null, null, obj, frame);
            this.addProperties(branch);
        }
    }

    private void addProperties(Branch branch) {
        this.addConditionalTypeProperty(branch);
        this.addIdProperty(branch);
        List<Field> fieldList = branch.getFrame().listAllFields();
        for (Field field : fieldList) {
            if (!this.isIncluded(field, this.contextProperties, branch.getFrame())) continue;
            this.addField(branch, field, null);
        }
    }

    private boolean isIncluded(Field field, ContextProperties properties, Frame declaringFrame) {
        String fieldType = field.getRdfType().getUri();
        if (properties.getExcludedTypes().contains(fieldType)) {
            return false;
        }
        FrameConstraints constraints = properties.getFrameConstraints(declaringFrame.getLocalName());
        return constraints == null || constraints.isIncludedProperty(field.getURI());
    }

    private void addField(Branch branch, Field field, String fieldName) {
        RdfType type = field.getRdfType();
        if (fieldName == null && this.contextProperties.isSetProperty(field.getURI())) {
            this.addSetProperty(branch, field, type);
        } else if (type.canAsDatatype()) {
            this.addDatatype(branch, field, fieldName, type.asDatatype());
        } else if (type.canAsListType()) {
            this.addList(branch, field, type.asListType());
        } else if (type.canAsFrame() && !this.shortCircuit(branch, field, fieldName, type.asFrame())) {
            this.addFrame(branch, field, fieldName, type.asFrame());
        }
    }

    private boolean shortCircuit(Branch branch, Field field, String fieldName, Frame frame) {
        List<Frame> frameList = frame.listAllSubtypes();
        List<Datatype> typeList = frame.getSubdatatypeList();
        if (frameList.size() + typeList.size() != 1) {
            return false;
        }
        if (frameList.isEmpty()) {
            this.addDatatype(branch, field, fieldName, typeList.get(0));
        } else {
            this.addFrame(branch, field, fieldName, frameList.get(0));
        }
        return true;
    }

    private void addFrame(final Branch branch, Field field, String fieldNameOverride, Frame frame) {
        String uri;
        TermInfo term;
        int maxCount = field.getMaxCardinality();
        if (maxCount < 0 || maxCount > this.maxRepeat) {
            maxCount = this.maxRepeat;
        }
        if ((term = this.context.getTermInfoByURI(uri = field.getURI())) == null) {
            return;
        }
        final String fieldName = fieldNameOverride == null ? term.getTermName() : fieldNameOverride;
        NodeConsumer callback = null;
        if (maxCount == 1) {
            callback = new NodeConsumer(){

                @Override
                public void consume(JsonNode node) {
                    branch.getNode().put(fieldName, node);
                }
            };
        } else {
            ArrayNode array = this.factory.arrayNode();
            branch.getNode().put(fieldName, (JsonNode)array);
            callback = new ArrayNodeConsumer(array);
        }
        for (int i = 0; i < maxCount; ++i) {
            this.createFrame(branch, term, field, frame, callback);
        }
    }

    private void createFrame(Branch branch, TermInfo term, Field field, Frame frame, NodeConsumer callback) {
        boolean iriReference;
        boolean bl = iriReference = term != null && term.isCoercedAsIriRef();
        if (iriReference && frame.getCategory() == RestCategory.ENUMERABLE) {
            this.createEnumReference(branch, frame, callback);
        } else if (iriReference) {
            String typeName = frame.getLocalName();
            int id = this.random.nextInt(100000);
            callback.consume((JsonNode)this.factory.textNode("http://server.example.com/resources/" + typeName + "/" + id));
        } else {
            ObjectNode child = this.factory.objectNode();
            if (this.exceedsMaxCyclicDepth(branch, frame)) {
                return;
            }
            Frame childFrame = this.selectType(frame);
            Branch childBranch = new Branch(branch, field, child, childFrame);
            this.addProperties(childBranch);
            callback.consume((JsonNode)child);
        }
    }

    private void createEnumReference(Branch branch, Frame frame, NodeConsumer callback) {
        OntResource target;
        OntClass type = frame.getType();
        List list = type.listInstances(false).toList();
        OntResource ontResource = target = list.isEmpty() ? null : (OntResource)list.get(this.random.nextInt(list.size()));
        if (target == null) {
            String typeName = frame.getLocalName();
            int id = this.random.nextInt(100000);
            callback.consume((JsonNode)this.factory.textNode("http://server.example.com/resources/" + typeName + "/" + id));
        } else {
            String name = this.getSimpleName(target.getURI());
            callback.consume((JsonNode)this.factory.textNode(name));
        }
    }

    private Frame selectType(Frame frame) {
        if (frame.getSubtypeList().isEmpty()) {
            return frame;
        }
        List<Frame> list = frame.listAllSubtypes();
        if (!frame.isAbstract()) {
            list.add(frame);
        }
        Iterator<Frame> sequence = list.iterator();
        while (sequence.hasNext()) {
            Frame type = sequence.next();
            if (!type.isAbstract()) continue;
            sequence.remove();
        }
        if (list.isEmpty()) {
            return frame;
        }
        return list.get(this.random.nextInt(list.size()));
    }

    private boolean exceedsMaxCyclicDepth(Branch branch, Frame frame) {
        int count = 0;
        while (branch != null) {
            RdfType type;
            RdfType rdfType = type = branch.getField() == null ? branch.getFrame() : branch.getField().getRdfType();
            if (type.canAsFrame() && type.asFrame() == frame && ++count >= this.maxCyclicDepth) {
                return true;
            }
            branch = branch.getParent();
        }
        return false;
    }

    private void addList(Branch branch, Field field, ListType listType) {
        String fieldName = this.getSimpleName(field.getURI());
        if (fieldName == null) {
            return;
        }
        RdfType elementType = listType.getElementType();
        ArrayNode array = this.factory.arrayNode();
        branch.getNode().put(fieldName, (JsonNode)array);
        if (elementType.canAsDatatype()) {
            this.addDatatypesToArray(array, elementType.asDatatype());
        } else if (elementType.canAsFrame()) {
            this.addFramesToArray(branch, field, array, elementType.asFrame());
        }
    }

    private void addFramesToArray(Branch branch, Field field, ArrayNode array, Frame frame) {
        ArrayNodeConsumer callback = new ArrayNodeConsumer(array);
        TermInfo term = this.context.getTermInfoByURI(field.getURI());
        for (int i = 0; i < this.maxRepeat; ++i) {
            this.createFrame(branch, term, field, frame, callback);
        }
    }

    private void addDatatypesToArray(ArrayNode array, Datatype datatype) {
        for (int i = 0; i < this.maxRepeat; ++i) {
            JsonNode value = this.createDatatype(datatype);
            array.add(value);
        }
    }

    private void addSetProperty(Branch branch, Field field, RdfType type) {
        String fieldName = this.getSimpleName(field.getURI());
        ObjectNode setContainer = this.factory.objectNode();
        branch.getNode().put(fieldName, (JsonNode)setContainer);
        TermInfo term = this.context.getTermInfoByURI(branch.getFrame().getUri());
        String typeName = term == null ? branch.getFrame().getLocalName() : term.getTermName();
        String value = "http://server.example.com/resources/" + typeName + "/" + this.random.nextInt(100000) + "/" + fieldName;
        setContainer.put("@id", value);
        Branch setBranch = new Branch(branch, field, setContainer, branch.getFrame());
        this.addField(setBranch, field, "@set");
    }

    private void addDatatype(Branch branch, Field field, String fieldName, Datatype type) {
        int maxCount = field.getMaxCardinality();
        if (maxCount < 0 || maxCount > this.maxRepeat) {
            maxCount = this.maxRepeat;
        }
        if (fieldName == null) {
            fieldName = this.getSimpleName(field.getURI());
        }
        if (fieldName == null) {
            return;
        }
        if (maxCount == 1) {
            JsonNode value = this.createDatatype(type);
            branch.getNode().put(fieldName, value);
            return;
        }
        ArrayNode array = this.factory.arrayNode();
        branch.getNode().put(fieldName, (JsonNode)array);
        for (int i = 0; i < maxCount; ++i) {
            JsonNode value = this.createDatatype(type);
            array.add(value);
        }
    }

    private JsonNode createDatatype(Datatype datatype) {
        TextNode node = null;
        String uri = datatype.getUri();
        String baseURI = this.typeManager.getXsdBaseURI(datatype);
        if (baseURI == null) {
            throw new UnsupportedDatatypeException(uri);
        }
        if (XSD.anyURI.getURI().equals(uri)) {
            node = this.factory.textNode("http://www.example.com/sampleURI");
        } else if (XSD.date.getURI().equals(baseURI)) {
            DateTime now = DateTime.now();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-ddZZ");
            node = this.factory.textNode(formatter.print((ReadableInstant)now));
        } else if (XSD.dateTime.getURI().equals(baseURI)) {
            DateTime now = DateTime.now();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd'T'HH:mm:ssZZ");
            node = this.factory.textNode(formatter.print((ReadableInstant)now));
        } else if (XSD.xboolean.getURI().equals(baseURI)) {
            boolean[] value = new boolean[]{true, false};
            node = this.factory.booleanNode(value[this.random.nextInt(2)]);
        } else if (XSD.xbyte.getURI().equals(baseURI) || XSD.unsignedByte.getURI().equals(baseURI)) {
            byte value = (byte)this.random.nextInt(8);
            node = this.factory.numberNode(value);
        } else if (XSD.decimal.getURI().equals(baseURI) || XSD.xdouble.getURI().equals(baseURI) || XSD.xfloat.getURI().equals(baseURI)) {
            String text = Double.toString((double)this.random.nextInt(1000) * this.random.nextDouble());
            if (text.length() > 5) {
                text = text.substring(0, 5) + "000000000";
            }
            double value = Double.parseDouble(text);
            node = this.factory.numberNode(value);
        } else if (XSD.duration.getURI().equals(baseURI) || "http://www.w3.org/2004/10/xpath-datatypes#dayTimeDuration".equals(baseURI)) {
            int hour = this.random.nextInt(24);
            int min = this.random.nextInt(60);
            node = this.factory.textNode("PT" + hour + "H" + min + "M");
        } else if ("http://www.w3.org/2004/10/xpath-datatypes#yearMonthDuration".equals(baseURI)) {
            int year = GregorianCalendar.getInstance().get(1);
            int month = this.random.nextInt(12) + 1;
            node = this.factory.textNode("P" + year + "Y" + month + "M");
        } else if (XSD.gDay.getURI().equals(baseURI)) {
            String text = "---" + this.zeroPad(this.random.nextInt(30), 2);
            node = this.factory.textNode(text);
        } else if (XSD.gMonth.getURI().equals(baseURI)) {
            String text = "--" + this.zeroPad(this.random.nextInt(12) + 1, 2);
            node = this.factory.textNode(text);
        } else if (XSD.gMonthDay.getURI().equals(baseURI)) {
            String text = "--" + this.zeroPad(this.random.nextInt(12) + 1, 2) + "-" + this.zeroPad(this.random.nextInt(30), 2);
            node = this.factory.textNode(text);
        } else if (XSD.gYear.getURI().equals(baseURI)) {
            String text = Integer.toString(GregorianCalendar.getInstance().get(1));
            node = this.factory.textNode(text);
        } else if (XSD.gYearMonth.getURI().equals(baseURI)) {
            int year = GregorianCalendar.getInstance().get(1);
            String month = this.zeroPad(this.random.nextInt(12) + 1, 2);
            node = this.factory.textNode(year + "-" + month);
        } else if (XSD.ID.getURI().equals(baseURI) || XSD.IDREF.getURI().equals(baseURI)) {
            node = this.factory.textNode("x" + this.random.nextInt(10000));
        } else if (XSD.xint.getURI().equals(baseURI) || XSD.integer.getURI().equals(baseURI) || XSD.nonNegativeInteger.getURI().equals(baseURI) || XSD.positiveInteger.getURI().equals(baseURI) || XSD.xlong.getURI().equals(baseURI) || XSD.unsignedInt.getURI().equals(baseURI) || XSD.unsignedLong.getURI().equals(baseURI)) {
            node = this.factory.numberNode(this.random.nextInt(10000));
        } else if (XSD.language.getURI().equals(baseURI)) {
            String[] languageList = new String[]{"ar", "en", "en-us", "fr", "de", "it", "ja", "pl", "ru", "es", "sv", "zh"};
            String text = languageList[this.random.nextInt(languageList.length)];
            node = this.factory.textNode(text);
        } else if (XSD.Name.getURI().equals(baseURI) || XSD.NCName.getURI().equals(baseURI) || XSD.token.getURI().equals(baseURI) || XSD.normalizedString.getURI().equals(baseURI) || XSD.xstring.getURI().equals(baseURI)) {
            String[] name = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
            node = this.factory.textNode(name[this.random.nextInt(name.length)]);
        } else if (XSD.negativeInteger.getURI().equals(baseURI)) {
            int value = -this.random.nextInt(10000);
            node = this.factory.numberNode(value);
        } else if (XSD.xshort.getURI().equals(baseURI) || XSD.unsignedShort.getURI().equals(baseURI)) {
            short value = (short)this.random.nextInt(100);
            node = this.factory.numberNode(value);
        } else if (XSD.time.getURI().equals(baseURI)) {
            DateTime now = DateTime.now();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
            String text = formatter.print((ReadableInstant)now);
            node = this.factory.textNode(text);
        } else {
            throw new UnsupportedDatatypeException(uri);
        }
        return node;
    }

    private String zeroPad(int value, int len) {
        String zero = "00000";
        String text = Integer.toString(value);
        if (text.length() < len) {
            text = zero.substring(0, len - text.length());
        }
        if (text.length() > len) {
            text = text.substring(0, len);
        }
        return text;
    }

    private void addIdProperty(Branch branch) {
        if (branch.getFrame().getCategory() == RestCategory.ADDRESSABLE) {
            String typeName = this.simpleTypeName(branch.getFrame());
            String value = "http://server.example.com/resources/" + typeName + "/" + this.random.nextInt(100000);
            branch.getNode().put("@id", value);
        }
    }

    private String simpleTypeName(Frame frame) {
        TermInfo term = this.context.getTermInfoByURI(frame.getUri());
        return term == null ? frame.getLocalName() : term.getTermName();
    }

    private void addConditionalTypeProperty(Branch branch) {
        RdfType type;
        Field field = branch.getField();
        RdfType rdfType = type = field == null ? null : field.getRdfType();
        Frame declaredFrame = type != null && type.canAsListType() ? type.asListType().getElementType().asFrame() : (type != null ? type.asFrame() : null);
        Frame actualFrame = branch.getFrame();
        if (actualFrame == null || actualFrame == declaredFrame || branch.getNode().has("@type")) {
            return;
        }
        this.addTypeProperty(branch.getNode(), actualFrame);
    }

    private void addTypeProperty(ObjectNode node, Frame frame) {
        node.put("@type", this.getSimpleName(frame.getUri()));
    }

    private String getSimpleName(String uri) {
        TermInfo term = this.context.getTermInfoByURI(uri);
        return term == null ? null : term.getTermName();
    }

    private void addContextProperty(ObjectNode node) {
        node.put("@context", this.context.getContextURI());
    }

    static class Branch {
        private Branch parent;
        private ObjectNode node;
        private Field field;
        private Frame frame;

        public Branch(Branch parent, Field field, ObjectNode node, Frame frame) {
            this.node = node;
            this.field = field;
            this.frame = frame;
            this.parent = parent;
        }

        public ObjectNode getNode() {
            return this.node;
        }

        public Frame getFrame() {
            return this.frame;
        }

        public Branch getParent() {
            return this.parent;
        }

        public Field getField() {
            return this.field;
        }
    }

    static interface NodeConsumer {
        public void consume(JsonNode var1);
    }

    static class ArrayNodeConsumer
    implements NodeConsumer {
        private ArrayNode array;

        public ArrayNodeConsumer(ArrayNode array) {
            this.array = array;
        }

        @Override
        public void consume(JsonNode node) {
            this.array.add(node);
        }
    }
}

