/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.json;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.ListType;
import org.semantictools.frame.model.RdfType;
import org.semantictools.json.UnsupportedDatatypeException;

public class SampleGenerator {
    private Random random;
    private int maxRepeat = 2;
    private int maxInstances = 3;
    private int sequence = 0;
    private Model model;

    public SampleGenerator(Model model) {
        this.model = model;
        this.random = new Random(new Date().getTime());
    }

    public Resource generateSample(Frame frame) {
        Resource root = this.createInstance(frame);
        this.addFields(root, frame);
        return root;
    }

    private Resource createInstance(Frame frame) {
        OntClass type = frame.getType();
        String typeName = type.getLocalName();
        Resource resource = null;
        switch (frame.getCategory()) {
            case EMBEDDABLE: {
                AnonId id = new AnonId(typeName + this.sequence++);
                resource = this.model.createResource(id);
                break;
            }
            case ENUMERABLE: {
                Resource value = this.selectInstance(type);
                if (value != null) {
                    resource = this.model.getResource(value.getURI());
                    if (resource != null) {
                        return resource;
                    }
                    resource = this.model.createResource(value.getURI());
                    break;
                }
            }
            default: {
                String instanceURI = "http://server.example.com/resources/" + typeName + "/" + this.random.nextInt(100000);
                resource = this.model.createResource(instanceURI);
            }
        }
        resource.addProperty(RDF.type, (RDFNode)type);
        return resource;
    }

    private Resource selectInstance(OntClass type) {
        ArrayList list = new ArrayList();
        ExtendedIterator sequence = type.listInstances(false);
        while (sequence.hasNext()) {
            list.add(sequence.next());
        }
        return (Resource)list.get(this.random.nextInt(list.size()));
    }

    private void addFields(Resource parent, Frame frame) {
        for (Field field : frame.listAllFields()) {
            this.addField(parent, field);
        }
    }

    private void addField(Resource parent, Field field) {
        RdfType type = field.getRdfType();
        if (type.canAsDatatype()) {
            this.addDatatype(parent, field);
        } else if (type.canAsListType()) {
            this.addList(parent, field);
        } else if (type.canAsFrame()) {
            this.addFrame(parent, field);
        }
    }

    private void addList(Resource parent, Field field) {
        ListType listType = field.getRdfType().asListType();
        RdfType type = listType.getElementType();
        RDFList list = this.model.createList();
        if (type.canAsDatatype()) {
            list = this.addDatatypes(list, type.asDatatype());
        } else if (type.canAsFrame()) {
            list = this.addFrames(list, type.asFrame());
        }
        parent.addProperty((Property)field.getProperty(), (RDFNode)list);
    }

    private RDFList addFrames(RDFList list, Frame frame) {
        ListResourceConsumer consumer = new ListResourceConsumer(list);
        this.addFrame(frame, this.maxRepeat, consumer);
        return consumer.getList();
    }

    private RDFList addDatatypes(RDFList list, Datatype datatype) {
        for (int i = 0; i < this.maxRepeat; ++i) {
            RDFNode node = this.createDatatype(datatype);
            list = list.with(node);
        }
        return list;
    }

    private void addDatatype(Resource parent, Field field) {
        Datatype type = field.getRdfType().asDatatype();
        int max = field.getMaxCardinality();
        max = max < 0 ? this.maxRepeat : Math.min(max, this.maxRepeat);
        for (int i = 0; i < max; ++i) {
            RDFNode node = this.createDatatype(type);
            parent.addProperty((Property)field.getProperty(), node);
        }
    }

    private void addFrame(final Resource parent, final Field field) {
        Frame frame = field.getRdfType().asFrame();
        int max = field.getMaxCardinality();
        max = max < 0 ? this.maxRepeat : Math.min(max, this.maxRepeat);
        this.addFrame(frame, max, new ResourceConsumer(){

            @Override
            public void consume(Resource value) {
                parent.addProperty((Property)field.getProperty(), (RDFNode)value);
            }
        });
    }

    private void addFrame(Frame frame, int count, ResourceConsumer consumer) {
        HashMap<String, InstanceInfo> map = new HashMap<String, InstanceInfo>();
        for (int i = 0; i < count; ++i) {
            Resource value = null;
            Frame selectedType = this.selectType(frame);
            InstanceInfo info = (InstanceInfo)map.get(selectedType.getUri());
            if (info == null) {
                info = new InstanceInfo(this.listInstancesOfType(selectedType.getType()));
                map.put(selectedType.getUri(), info);
            }
            if ((value = info.get()) == null) {
                value = this.createInstance(selectedType);
                this.addFields(value, selectedType);
                ++info.count;
            }
            consumer.consume(value);
        }
    }

    private List<Resource> listInstancesOfType(OntClass type) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        ResIterator sequence = this.model.listResourcesWithProperty(RDF.type, (RDFNode)type);
        while (sequence.hasNext()) {
            list.add((Resource)sequence.next());
        }
        return list;
    }

    private RDFNode createDatatype(Datatype datatype) {
        Literal node = null;
        String uri = datatype.getUri();
        String baseURI = this.getBaseURI(datatype);
        if (baseURI == null) {
            throw new UnsupportedDatatypeException(uri);
        }
        if (XSD.anyURI.getURI().equals(uri)) {
            node = this.model.createTypedLiteral("http://www.example.com/sampleURI", uri);
        } else if (XSD.date.getURI().equals(baseURI)) {
            DateTime now = DateTime.now();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-ddZZ");
            node = this.model.createTypedLiteral(formatter.print((ReadableInstant)now), uri);
        } else if (XSD.dateTime.getURI().equals(baseURI)) {
            DateTime now = DateTime.now();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd'T'HH:mm:ssZZ");
            node = this.model.createTypedLiteral(formatter.print((ReadableInstant)now), uri);
        } else if (XSD.xboolean.getURI().equals(baseURI)) {
            boolean[] value = new boolean[]{true, false};
            node = this.model.createTypedLiteral((Object)value[this.random.nextInt(2)], uri);
        } else if (XSD.xbyte.getURI().equals(baseURI) || XSD.unsignedByte.getURI().equals(baseURI)) {
            byte value = (byte)this.random.nextInt(8);
            node = this.model.createTypedLiteral((Object)value, uri);
        } else if (XSD.decimal.getURI().equals(baseURI) || XSD.xdouble.getURI().equals(baseURI) || XSD.xfloat.getURI().equals(baseURI)) {
            String text = Double.toString((double)this.random.nextInt(1000) * this.random.nextDouble());
            if (text.length() > 5) {
                text = text.substring(0, 5);
            }
            node = this.model.createTypedLiteral((Object)Float.valueOf(Float.parseFloat(text)), uri);
        } else if (XSD.duration.getURI().equals(baseURI) || "http://www.w3.org/2004/10/xpath-datatypes#dayTimeDuration".equals(baseURI)) {
            int hour = this.random.nextInt(24);
            int min = this.random.nextInt(60);
            node = this.model.createTypedLiteral("PT" + hour + "H" + min + "M", uri);
        } else if ("http://www.w3.org/2004/10/xpath-datatypes#yearMonthDuration".equals(baseURI)) {
            int year = GregorianCalendar.getInstance().get(1);
            int month = this.random.nextInt(12) + 1;
            node = this.model.createTypedLiteral("P" + year + "Y" + month + "M", uri);
        } else if (XSD.gDay.getURI().equals(baseURI)) {
            String text = "---" + this.zeroPad(this.random.nextInt(30), 2);
            node = this.model.createTypedLiteral(text, uri);
        } else if (XSD.gMonth.getURI().equals(baseURI)) {
            String text = "--" + this.zeroPad(this.random.nextInt(12) + 1, 2);
            node = this.model.createTypedLiteral(text, uri);
        } else if (XSD.gMonthDay.getURI().equals(baseURI)) {
            String text = "--" + this.zeroPad(this.random.nextInt(12) + 1, 2) + "-" + this.zeroPad(this.random.nextInt(30), 2);
            node = this.model.createTypedLiteral(text, uri);
        } else if (XSD.gYear.getURI().equals(baseURI)) {
            String text = Integer.toString(GregorianCalendar.getInstance().get(1));
            node = this.model.createTypedLiteral(text, uri);
        } else if (XSD.gYearMonth.getURI().equals(baseURI)) {
            int year = GregorianCalendar.getInstance().get(1);
            String month = this.zeroPad(this.random.nextInt(12) + 1, 2);
            node = this.model.createTypedLiteral(year + "-" + month, uri);
        } else if (XSD.ID.getURI().equals(baseURI) || XSD.IDREF.getURI().equals(baseURI)) {
            node = this.model.createTypedLiteral("x" + this.random.nextInt(10000), uri);
        } else if (XSD.xint.getURI().equals(baseURI) || XSD.integer.getURI().equals(baseURI) || XSD.nonNegativeInteger.getURI().equals(baseURI) || XSD.positiveInteger.getURI().equals(baseURI) || XSD.xlong.getURI().equals(baseURI) || XSD.unsignedInt.getURI().equals(baseURI) || XSD.unsignedLong.getURI().equals(baseURI)) {
            node = this.model.createTypedLiteral((Object)this.random.nextInt(10000), uri);
        } else if (XSD.language.getURI().equals(baseURI)) {
            String[] languageList = new String[]{"ar", "en", "en-us", "fr", "de", "it", "ja", "pl", "ru", "es", "sv", "zh"};
            String text = languageList[this.random.nextInt(languageList.length)];
            node = this.model.createTypedLiteral(text, uri);
        } else if (XSD.Name.getURI().equals(baseURI) || XSD.NCName.getURI().equals(baseURI) || XSD.token.getURI().equals(baseURI) || XSD.normalizedString.getURI().equals(baseURI) || XSD.xstring.getURI().equals(baseURI)) {
            String[] name = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
            node = this.model.createTypedLiteral(name[this.random.nextInt(name.length)], uri);
        } else if (XSD.negativeInteger.getURI().equals(baseURI)) {
            int value = -this.random.nextInt(10000);
            node = this.model.createTypedLiteral((Object)value, uri);
        } else if (XSD.xshort.getURI().equals(baseURI) || XSD.unsignedShort.getURI().equals(baseURI)) {
            short value = (short)this.random.nextInt(100);
            node = this.model.createTypedLiteral((Object)value, uri);
        } else if (XSD.time.getURI().equals(baseURI)) {
            DateTime now = DateTime.now();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
            String text = formatter.print((ReadableInstant)now);
            node = this.model.createTypedLiteral(text, uri);
        } else {
            throw new UnsupportedDatatypeException(uri);
        }
        return node;
    }

    private String getBaseURI(Datatype datatype) {
        String xsdURI = XSD.getURI();
        while (datatype != null) {
            if (datatype.getUri().startsWith(xsdURI)) {
                return datatype.getUri();
            }
            datatype = datatype.getBase();
        }
        return null;
    }

    private String zeroPad(int value, int len) {
        String zero = "00000";
        String text = Integer.toString(value);
        if (text.length() < len) {
            text = zero.substring(0, len - text.length());
        }
        if (text.length() > len) {
            text = text.substring(0, len);
        }
        return text;
    }

    private Frame selectType(Frame frame) {
        if (frame.getSubtypeList().isEmpty()) {
            return frame;
        }
        List<Frame> list = frame.listAllSubtypes();
        list.add(frame);
        return list.get(this.random.nextInt(list.size()));
    }

    private class InstanceInfo {
        List<Resource> list;
        int count;

        InstanceInfo(List<Resource> list) {
            this.list = list;
            this.count = list.size();
        }

        private Resource get() {
            if (this.count >= SampleGenerator.this.maxInstances && !this.list.isEmpty()) {
                return this.list.remove(SampleGenerator.this.random.nextInt(this.list.size()));
            }
            return null;
        }
    }

    private static interface ResourceConsumer {
        public void consume(Resource var1);
    }

    static class ListResourceConsumer
    implements ResourceConsumer {
        private RDFList list;

        public ListResourceConsumer(RDFList list) {
            this.list = list;
        }

        @Override
        public void consume(Resource value) {
            this.list = this.list.with((RDFNode)value);
        }

        public RDFList getList() {
            return this.list;
        }
    }
}

