/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.publish;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.semantictools.context.renderer.GlobalPropertiesReader;
import org.semantictools.context.renderer.MediaTypeFileManager;
import org.semantictools.context.renderer.URLRewriter;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.GlobalProperties;
import org.semantictools.context.renderer.model.SampleJson;
import org.semantictools.context.renderer.model.ServiceFileManager;
import org.semantictools.context.view.ServiceDocumentationPrinter;
import org.semantictools.frame.api.ContextManager;
import org.semantictools.frame.api.MediaTypeDocumenter;
import org.semantictools.frame.api.OntologyManager;
import org.semantictools.frame.api.SchemaParseException;
import org.semantictools.frame.api.ServiceDocumentationManager;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.index.api.LinkedDataIndexPrinter;
import org.semantictools.index.api.impl.LinkedDataIndexImpl;
import org.semantictools.jsonld.LdAsset;
import org.semantictools.jsonld.LdProcessor;
import org.semantictools.jsonld.LdValidationMessage;
import org.semantictools.jsonld.LdValidationReport;
import org.semantictools.jsonld.LdValidationResult;
import org.semantictools.jsonld.impl.LdContentType;
import org.semantictools.jsonld.io.LdParseException;
import org.semantictools.uml.api.UmlFileManager;
import org.semantictools.uml.api.UmlPrinter;
import org.semantictools.uml.model.UmlManager;
import org.semantictools.web.upload.AppspotUploadClient;
import org.xml.sax.SAXException;

public class DocumentationGenerator {
    private static final Logger defaultLogger = Logger.getLogger(DocumentationGenerator.class.getName());
    private Logger logger;
    private File rdfDir;
    private File pubDir;
    private File repoDir;
    private boolean publish = false;
    private String uploadEndpoint = null;
    private String version = null;
    private String indexFileName = "index.html";
    private boolean generate = true;

    public DocumentationGenerator(File sourceDir, File targetDir, File repoDir, boolean publish) {
        this.rdfDir = sourceDir;
        this.pubDir = targetDir;
        this.repoDir = repoDir;
        this.publish = publish;
    }

    public Logger getLogger() {
        return this.logger == null ? defaultLogger : this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public String getIndexFileName() {
        return this.indexFileName;
    }

    public void setIndexFileName(String indexFileName) {
        this.indexFileName = indexFileName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUploadEndpoint() {
        return this.uploadEndpoint;
    }

    public void setUploadEndpoint(String uploadEndpoint) {
        this.uploadEndpoint = uploadEndpoint;
    }

    public void run() throws IOException, ParserConfigurationException, SAXException, SchemaParseException {
        File umlDir = new File(this.pubDir, "uml");
        File mediaTypeDir = new File(this.pubDir, "mediatype");
        File umlCss = new File(umlDir, "uml.css");
        OntologyManager ontoManager = new OntologyManager();
        GlobalPropertiesReader globalReader = new GlobalPropertiesReader(ontoManager);
        GlobalProperties global = globalReader.scan(this.rdfDir);
        UmlFileManager umlFileManager = new UmlFileManager(umlDir);
        TypeManager typeManager = new TypeManager();
        typeManager.loadDir(this.rdfDir);
        typeManager.processOntologies();
        UmlManager umlManager = new UmlManager(typeManager);
        URLRewriter rewriter = new URLRewriter(){

            @Override
            public String rewrite(String url) {
                return url;
            }
        };
        ServiceFileManager serviceFileManager = new ServiceFileManager(umlDir, umlCss);
        MediaTypeFileManager mediatypeFileManager = new MediaTypeFileManager(mediaTypeDir, mediaTypeDir);
        ContextManager contextManager = new ContextManager(global, mediatypeFileManager);
        MediaTypeDocumenter documenter = new MediaTypeDocumenter(contextManager, umlFileManager, global);
        documenter.loadAll(this.rdfDir);
        typeManager.analyzeOntologies();
        if (this.generate) {
            documenter.produceAllDocumentation(mediaTypeDir);
        }
        ServiceDocumentationPrinter servicePrinter = new ServiceDocumentationPrinter(rewriter);
        ServiceDocumentationManager serviceManager = new ServiceDocumentationManager(global, contextManager, serviceFileManager, servicePrinter);
        serviceManager.scan(this.rdfDir);
        if (this.generate) {
            serviceManager.writeAll();
        }
        LinkedDataIndexImpl oracle = new LinkedDataIndexImpl(typeManager, contextManager, serviceManager, umlFileManager);
        File indexFile = new File(this.pubDir, this.indexFileName);
        UmlPrinter umlPrinter = new UmlPrinter(global, rewriter, umlManager, umlFileManager, oracle);
        if (this.generate) {
            LinkedDataIndexPrinter indexPrinter = new LinkedDataIndexPrinter(indexFile, oracle);
            umlPrinter.printAll();
            indexPrinter.printIndex();
        }
        if (this.publish) {
            AppspotUploadClient uploader = new AppspotUploadClient();
            if (this.uploadEndpoint != null) {
                uploader.setEndpointURL(this.uploadEndpoint);
            }
            uploader.setVersion(this.version);
            uploader.uploadAll(this.pubDir);
        }
        this.validate(contextManager);
        ontoManager.scan(this.rdfDir);
        ontoManager.upload();
        ontoManager.uploadJsonLdContextFiles(contextManager.listContextProperties());
        ontoManager.publishToLocalRepository(contextManager.listContextProperties());
    }

    private void validate(ContextManager manager) {
        if (this.repoDir == null) {
            return;
        }
        this.deleteDir(this.repoDir);
        this.repoDir.mkdirs();
        LdProcessor processor = new LdProcessor(this.rdfDir, this.repoDir, false);
        List<ContextProperties> list = manager.listContextProperties();
        for (ContextProperties context : list) {
            this.publishJsonLdContext(processor, context);
        }
        for (ContextProperties context : list) {
            if (!context.getValidateJsonSamples()) continue;
            this.validate(processor, context);
        }
    }

    private void publishJsonLdContext(LdProcessor processor, ContextProperties context) {
        File contextFile = context.getContextFile();
        try {
            String contextURI = context.getContextURI();
            URL url = contextFile.toURI().toURL();
            LdAsset asset = new LdAsset(contextURI, LdContentType.JSON_LD_CONTEXT, url);
            asset.loadContent();
            processor.publish(asset);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to add context to repo: " + contextFile);
        }
    }

    private void validate(LdProcessor processor, ContextProperties context) {
        File defaultFile;
        List<SampleJson> list = context.getSampleJsonList();
        File baseDir = context.getSourceFile().getParentFile();
        if (list.isEmpty() && (defaultFile = new File(baseDir, "sample.json")).exists()) {
            list = new ArrayList<SampleJson>();
            SampleJson sample = new SampleJson();
            sample.setFileName("sample.json");
            list.add(sample);
        }
        for (SampleJson sample : list) {
            File file = new File(baseDir, sample.getFileName());
            try {
                URL url = file.toURI().toURL();
                LdValidationReport report = processor.validate(url);
                this.log(file, report);
            }
            catch (MalformedURLException e) {
                this.getLogger().log(Level.SEVERE, "Failed to validate JSON sample " + file);
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (LdParseException e) {
                this.getLogger().log(Level.SEVERE, "Failed to validate JSON sample " + file);
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Failed to validate JSON sample " + file);
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (Throwable e) {
                this.getLogger().log(Level.SEVERE, "Failed to validate JSON sample " + file);
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
    }

    private void log(File file, LdValidationReport report) {
        if (!this.hasProblem(report)) {
            return;
        }
        Logger logger = this.getLogger();
        logger.warning("Detected problems in file " + file);
        for (LdValidationMessage message : report.listMessages()) {
            LdValidationResult result = message.getResult();
            Level level = result == LdValidationResult.ERROR ? Level.SEVERE : (result == LdValidationResult.WARNING ? Level.WARNING : null);
            if (level == null) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(message.getPath());
            builder.append(": ");
            builder.append(message.getText());
            String text = builder.toString();
            logger.log(level, text);
        }
    }

    private boolean hasProblem(LdValidationReport report) {
        for (LdValidationMessage msg : report.listMessages()) {
            if (msg.getResult() == LdValidationResult.OK) continue;
            return true;
        }
        return false;
    }

    private void deleteDir(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] list;
            for (File doomed : list = file.listFiles()) {
                this.deleteDir(doomed);
            }
        }
        file.delete();
    }
}

