/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.uml.api;

import com.hp.hpl.jena.rdf.model.Property;
import java.io.File;
import org.semantictools.frame.api.LinkManager;
import org.semantictools.frame.model.RdfType;
import org.semantictools.uml.model.UmlClass;

public class UmlFileManager
extends LinkManager {
    private File rootDir;
    private String ontologyURI;
    private File ontologyDir;
    private File imagesDir;

    public UmlFileManager(File rootDir) {
        this.rootDir = rootDir;
    }

    public void setOntology(String ontologyURI) {
        this.ontologyURI = ontologyURI;
        String path = this.getOntologyPath(ontologyURI);
        this.ontologyDir = new File(this.rootDir, path);
        this.imagesDir = new File(this.ontologyDir, "images");
        this.imagesDir.mkdirs();
        String baseURI = this.ontologyDir.toString().replace('\\', '/') + "/";
        this.setBaseURI(baseURI);
    }

    public File getOntologyAllFile() {
        return this.createOntologyAllFile(this.ontologyDir);
    }

    private File createOntologyAllFile(File ontDir) {
        return new File(ontDir, "index.html");
    }

    public File getUmlClassImageFile(UmlClass umlClass) {
        return new File(this.imagesDir, umlClass.getLocalName() + ".png");
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getOntologyDir() {
        return this.ontologyDir;
    }

    public File getImagesDir() {
        return this.imagesDir;
    }

    private String getOntologyPath(String uri) {
        int slash = uri.indexOf(47) + 2;
        String path = uri.substring(slash, uri.length() - 1);
        return path;
    }

    public String getTypeId(RdfType umlClass) {
        return umlClass.getLocalName();
    }

    public String getPropertyId(UmlClass declaringClass, Property rdfProperty) {
        if (rdfProperty == null) {
            return null;
        }
        return declaringClass.getLocalName() + '.' + rdfProperty.getLocalName();
    }

    public String getPropertyHref(UmlClass declaringClass, Property rdfProperty) {
        String classURI = declaringClass.getURI();
        String prefix = classURI.startsWith(this.ontologyURI) ? "" : this.getTypeHref(declaringClass.getType());
        return prefix + "#" + this.getPropertyId(declaringClass, rdfProperty);
    }

    public String getTypeHref(RdfType type) {
        String uri = type.getUri();
        if (uri.startsWith(this.ontologyURI)) {
            return "#" + this.getTypeId(type);
        }
        String ontURI = type.getNamespace();
        String filePath = this.createOntologyAllFile(ontURI).toString().replace('\\', '/');
        String anchorPath = filePath + "#" + this.getTypeId(type);
        return this.relativize(anchorPath);
    }

    public String getTypeRelativePath(File sourceFile, RdfType type) {
        File ontologyFile = this.createOntologyAllFile(type.getNamespace());
        LinkManager linkManager = new LinkManager(sourceFile);
        String uri = linkManager.relativize(ontologyFile) + "#" + this.getTypeId(type);
        return uri;
    }

    public String getTypeLink(RdfType type) {
        return "<A href=\"" + this.getTypeHref(type) + "\">" + type.getLocalName() + "</A>";
    }

    private File createOntologyAllFile(String ontologyURI) {
        String path = this.getOntologyPath(ontologyURI);
        File dir = new File(this.rootDir, path);
        return this.createOntologyAllFile(dir);
    }
}

