/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.uml.api;

import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.semantictools.context.renderer.URLRewriter;
import org.semantictools.context.renderer.model.BaseDocumentMetadata;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.GlobalProperties;
import org.semantictools.context.renderer.model.ServiceDocumentation;
import org.semantictools.context.view.Caption;
import org.semantictools.context.view.CaptionType;
import org.semantictools.context.view.DocumentPrinter;
import org.semantictools.context.view.DocumentPrinterFactory;
import org.semantictools.context.view.Heading;
import org.semantictools.context.view.HtmlPrinter;
import org.semantictools.frame.api.LinkManager;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.NamedIndividual;
import org.semantictools.frame.model.OntologyInfo;
import org.semantictools.frame.model.RdfType;
import org.semantictools.index.api.LinkedDataIndex;
import org.semantictools.uml.api.UmlFileManager;
import org.semantictools.uml.graphics.ClassDiagram;
import org.semantictools.uml.model.UmlAssociation;
import org.semantictools.uml.model.UmlAssociationEnd;
import org.semantictools.uml.model.UmlClass;
import org.semantictools.uml.model.UmlManager;
import org.semantictools.web.upload.AppspotUploadClient;

public class UmlPrinter
extends HtmlPrinter {
    private static final String UML_CSS = "uml.css";
    private UmlManager umlManager;
    private String ontologyTitle;
    private String ontologyURI;
    private UmlFileManager linkManager;
    private LinkedDataIndex mediaTypeOracle;
    private AppspotUploadClient uploadClient;
    private LinkManager uploadLinkManager;
    private GlobalProperties global;
    private BaseDocumentMetadata metadata;
    private DocumentPrinter printer;

    public UmlPrinter(GlobalProperties global, URLRewriter rewriter, UmlManager umlManager, UmlFileManager linkManager, LinkedDataIndex oracle) {
        super(rewriter);
        this.global = global == null ? new GlobalProperties() : global;
        this.umlManager = umlManager;
        this.linkManager = linkManager;
        this.mediaTypeOracle = oracle;
    }

    public AppspotUploadClient getUploadClient() {
        return this.uploadClient;
    }

    public void setUploadClient(AppspotUploadClient uploadClient) {
        this.uploadClient = uploadClient;
        File baseDir = this.linkManager.getRootDir().getParentFile();
        String baseURI = baseDir.getPath().replace('\\', '/') + '/';
        this.uploadLinkManager = new LinkManager();
        this.uploadLinkManager.setBaseURI(baseURI);
    }

    public void printAll() throws IOException {
        Iterator<OntologyInfo> sequence = this.umlManager.getTypeManager().listOntologies().iterator();
        while (sequence.hasNext()) {
            OntologyInfo info;
            String ontURI = sequence.next().getNamespaceUri();
            if (this.global.isIgnoredOntology(ontURI) || this.umlManager.getTypeManager().isStandard(ontURI) || (info = this.umlManager.getTypeManager().getOntologyByNamespaceUri(ontURI)) == null) continue;
            this.init(info);
            switch (info.getType()) {
                case RDF: {
                    if (!info.hasClasses()) break;
                    this.printOntology(ontURI);
                    break;
                }
                case XSD: {
                    this.printXmlSchema(info);
                }
            }
        }
        this.copyStyleSheet();
    }

    private void init(OntologyInfo info) {
        this.init();
        this.ontologyURI = info.getNamespaceUri();
        this.linkManager.setOntology(this.ontologyURI);
    }

    private void printXmlSchema(OntologyInfo info) throws IOException {
        String templateName = this.global.getTemplateName();
        this.metadata = new BaseDocumentMetadata(this.global);
        this.printer = DocumentPrinterFactory.getDefaultFactory().createPrinter(templateName);
        this.printer.setMetadata(this.metadata);
        this.setPrintContext(this.printer.getPrintContext());
        this.setCss();
        this.setXmlSchemaTitle(info);
        this.printer.beginHTML();
        this.printer.printTitlePage();
        this.printer.printTableOfContentsMarker();
        this.println("<hr/>");
        this.printDatatypes(info);
        this.printer.printFooter();
        this.printer.endHTML();
        this.printer.insertTableOfContents();
        this.writeFile();
    }

    private void printDatatypes(OntologyInfo info) {
        List<Datatype> types = this.listDataTypes(info.getNamespaceUri());
        for (Datatype type : types) {
            this.printDatatype(type);
        }
    }

    private void setXmlSchemaTitle(OntologyInfo info) {
        this.ontologyTitle = info.getLabel();
        if (this.ontologyTitle == null) {
            this.ontologyTitle = info.getPrefix().toUpperCase() + " XML Schema";
        }
        this.metadata.setTitle(this.ontologyTitle);
    }

    private List<Datatype> listDataTypes(String uri) {
        ArrayList<Datatype> list = new ArrayList<Datatype>();
        TypeManager typeManager = this.umlManager.getTypeManager();
        Collection<Datatype> source = typeManager.listDatatypes();
        for (Datatype d : source) {
            String typeURI = d.getUri();
            if (!typeURI.startsWith(uri)) continue;
            list.add(d);
        }
        Collections.sort(list, new DatatypeComparator());
        return list;
    }

    private void printDatatype(Datatype type) {
        Heading heading = this.printer.createHeading(type.getLocalName());
        heading.setClassName("rdfType");
        this.print(heading);
        String baseURI = type.getBase().getUri();
        this.printer.beginTable("propertiesTable");
        this.printer.beginRow();
        this.printer.printTH("Restriction&nbsp;Base");
        this.printer.printTD(baseURI);
        this.printer.endRow();
        this.printStringFacet("pattern", type.getPattern());
        this.printNumberFacet("length", type.getLength());
        this.printNumberFacet("minLength", type.getMinLength());
        this.printNumberFacet("maxLength", type.getMaxLength());
        this.printNumberFacet("minInclusive", type.getMinInclusive());
        this.printNumberFacet("maxInclusive", type.getMaxInclusive());
        this.printNumberFacet("minExclusive", type.getMinExclusive());
        this.printNumberFacet("maxExclusive", type.getMaxExclusive());
        this.printNumberFacet("totalDigits", type.getTotalDigits());
        this.printNumberFacet("fractionDigits", type.getFractionDigits());
        this.printer.endTable();
    }

    private void printNumberFacet(String name, Number value) {
        if (value == null) {
            return;
        }
        this.printer.beginRow();
        this.printer.printTH(name);
        this.printer.printTD(value.toString());
        this.printer.endRow();
    }

    private void printStringFacet(String name, String value) {
        if (value == null) {
            return;
        }
        this.printer.beginRow();
        this.printer.printTH(name);
        this.printer.printTD(value);
        this.printer.endRow();
    }

    private void copyStyleSheet() throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(UML_CSS);
        if (stream != null) {
            File cssFile = new File(this.linkManager.getRootDir(), UML_CSS);
            this.copyFile(stream, cssFile);
            if (this.uploadClient != null) {
                this.uploadClient.upload("text/css", "uml/uml.css", cssFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream stream, File cssFile) throws IOException {
        File parent = cssFile.getParentFile();
        parent.mkdirs();
        FileOutputStream out = new FileOutputStream(cssFile);
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            out.close();
        }
    }

    public void printOntology(String ontologyURI) throws IOException {
        String templateName = this.global.getTemplateName();
        this.metadata = new BaseDocumentMetadata(this.global);
        this.printer = DocumentPrinterFactory.getDefaultFactory().createPrinter(templateName);
        this.printer.setMetadata(this.metadata);
        this.setPrintContext(this.printer.getPrintContext());
        this.setCss();
        this.setTitle();
        this.printer.beginHTML();
        this.printer.printTitlePage();
        this.printer.printTableOfContentsMarker();
        this.printDataModel();
        this.printer.printFooter();
        this.printer.endHTML();
        this.printer.insertTableOfContents();
        this.writeFile();
    }

    private void setCss() {
        String ontoPath = this.linkManager.getOntologyDir().getAbsolutePath();
        String basePath = this.linkManager.getRootDir().getAbsolutePath();
        String relativePath = ontoPath.substring(basePath.length());
        relativePath = relativePath.replace('\\', '/');
        int count = this.dirCount(relativePath);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append("../");
        }
        builder.append(UML_CSS);
        String css = builder.toString();
        this.metadata.setCss(css);
    }

    private void setTitle() {
        OntologyInfo info = this.umlManager.getTypeManager().getOntologyByNamespaceUri(this.ontologyURI);
        this.ontologyTitle = this.ontologyURI;
        if (info != null && info.getLabel() != null) {
            this.ontologyTitle = info.getLabel();
        }
        this.metadata.setTitle(this.ontologyTitle);
    }

    private void writeFile() throws IOException {
        File file = this.getOntologyIndexFile();
        file.getParentFile().mkdirs();
        String text = this.printer.popText();
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(text);
            writer.flush();
        }
        catch (IOException oops) {
            throw oops;
        }
        finally {
            writer.close();
        }
        this.uploadFile("text/html", file);
    }

    private void uploadFile(String contentType, File file) throws IOException {
        if (this.uploadClient == null) {
            return;
        }
        String path = file.getPath().replace("\\", "/");
        path = this.uploadLinkManager.relativize(path);
        this.uploadClient.upload(contentType, path, file);
    }

    private File getOntologyIndexFile() {
        return this.linkManager.getOntologyAllFile();
    }

    private void printTitle() {
        this.print("<H1>");
        this.print(this.ontologyTitle);
        this.println("</H1>");
    }

    private void printDataModel() throws IOException {
        List<UmlClass> list = this.getClassList();
        for (UmlClass umlClass : list) {
            String uri = umlClass.getURI();
            if (!uri.startsWith(this.ontologyURI)) continue;
            this.printUmlClass(umlClass);
        }
    }

    private List<UmlClass> getClassList() {
        ArrayList<UmlClass> list = new ArrayList<UmlClass>();
        for (UmlClass umlClass : this.umlManager.listUmlClasses()) {
            String uri = umlClass.getURI();
            if (!uri.startsWith(this.ontologyURI)) continue;
            list.add(umlClass);
        }
        Collections.sort(list, new UmlClassComparator());
        return list;
    }

    private boolean exists(String value) {
        return value != null && value.length() > 0;
    }

    private void printUmlClass(UmlClass umlClass) throws IOException {
        String localName = umlClass.getLocalName();
        this.println("<HR/>");
        Heading heading = this.printer.createHeading(localName, this.linkManager.getTypeId(umlClass.getType()));
        this.print(heading);
        this.pushIndent();
        this.printClassDiagram(umlClass);
        this.printSupertypes(umlClass);
        this.printSubtypes(umlClass);
        this.printClassUses(umlClass);
        this.printMediaTypes(umlClass);
        this.printDescription(umlClass);
        this.printPropertyTable(umlClass);
        this.printInheritedProperties(umlClass);
        this.printNamedInstances(umlClass);
        this.popIndent();
    }

    private void printClassUses(UmlClass umlClass) {
        List<UmlAssociation> list = umlClass.getParentList();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.printer.beginDiv("list-heading");
        this.print("Known Uses:");
        this.printer.endDiv();
        this.indent();
        this.println("<UL>");
        this.pushIndent();
        for (UmlAssociation a : list) {
            UmlAssociationEnd end = a.getOtherEnd(umlClass);
            String classHref = this.linkManager.getTypeHref(end.getParticipant().getType());
            String className = end.getParticipant().getLocalName();
            Field field = a.getSelfEnd(umlClass).getField();
            this.indent();
            this.print("<LI>");
            this.printer.printAnchor(classHref, className);
            if (field == null) continue;
            OntProperty property = field.getProperty();
            String fieldName = field.getLocalName();
            String fieldHref = this.linkManager.getPropertyHref(end.getParticipant(), (Property)property);
            this.print(".");
            this.printer.printAnchor(fieldHref, fieldName);
        }
        this.popIndent();
        this.indent();
        this.println("</UL>");
    }

    private void printMediaTypes(UmlClass umlClass) {
        int count;
        if (this.mediaTypeOracle == null) {
            return;
        }
        List<ContextProperties> mediaTypeList = this.mediaTypeOracle.listMediaTypesForClass(umlClass.getURI());
        ArrayList list = this.mediaTypeOracle.getServiceDocumentationForClass(umlClass.getURI());
        if (list == null) {
            list = new ArrayList();
        }
        if ((count = mediaTypeList.size() + list.size()) == 0) {
            return;
        }
        this.printer.beginDiv("list-heading");
        this.print("See Also:");
        this.printer.endDiv();
        this.println("<UL>");
        this.pushIndent();
        for (int i = 0; i < list.size(); ++i) {
            ServiceDocumentation doc = (ServiceDocumentation)list.get(i);
            String title = doc.getTitle().replace("<br>", " ").replace("<br/>", " ");
            String serviceHref = this.linkManager.relativize(doc.getServiceDocumentationFile());
            this.indent();
            this.print("<LI>");
            this.printer.printAnchor(serviceHref, title);
        }
        for (ContextProperties context : mediaTypeList) {
            String mediaType = context.getMediaType();
            String href = this.linkManager.relativize(context.getMediaTypeDocFile());
            this.indent();
            this.print("<LI>");
            this.printer.printAnchor(href, mediaType);
        }
        this.popIndent();
        this.println("</UL>");
    }

    private void printDescription(UmlClass umlClass) {
        String description = umlClass.getDescription();
        if (this.exists(description)) {
            this.printer.printParagraph(description);
        }
    }

    private void printSupertypes(UmlClass umlClass) {
        List<UmlClass> superList = umlClass.getSupertypeList();
        if (superList == null || superList.isEmpty()) {
            return;
        }
        this.printer.beginDiv("list-heading");
        this.print("Direct Known Supertypes:");
        this.printer.endDiv();
        this.printer.beginDiv("running-list");
        String comma = "";
        for (UmlClass supertype : superList) {
            this.print(comma);
            this.print(this.linkManager.getTypeLink(supertype.getType()));
            comma = ", ";
        }
        this.printer.endDiv();
    }

    private void printSubtypes(UmlClass umlClass) {
        List<UmlClass> subList = umlClass.getSubtypeList();
        if (subList == null || subList.isEmpty()) {
            return;
        }
        this.printer.beginDiv("list-heading");
        this.print("Direct Known Subtypes:");
        this.printer.endDiv();
        this.printer.beginDiv("running-list");
        String comma = "";
        for (UmlClass subtype : subList) {
            this.print(comma);
            this.print(this.linkManager.getTypeLink(subtype.getType()));
            comma = ", ";
        }
        this.printer.endDiv();
    }

    private void printInheritedProperties(UmlClass umlClass) {
        List<UmlClass> list = umlClass.listAllSupertypes();
        if (list.isEmpty()) {
            return;
        }
        list = new ArrayList<UmlClass>(list);
        Collections.sort(list, new UmlClassComparator());
        for (UmlClass superclass : list) {
            this.printInheritedProperties(umlClass, superclass);
        }
    }

    private void printInheritedProperties(UmlClass umlClass, UmlClass superclass) {
        RdfType superType = superclass.getType();
        if (!superType.canAsFrame()) {
            return;
        }
        List<Field> list = superType.asFrame().getDeclaredFields();
        if (list == null || list.isEmpty()) {
            return;
        }
        String title = "Properties inherited from " + superclass.getLocalName();
        this.printer.beginTable("propertiesTable");
        this.printer.beginRow();
        this.printer.printTH(title);
        this.printer.endRow();
        this.printer.beginRow();
        this.indent();
        this.print("<TD>");
        String comma = "";
        for (Field field : list) {
            this.print(comma);
            String id = null;
            id = this.linkManager.getPropertyHref(superclass, (Property)field.getProperty());
            if (id != null) {
                this.print("<a href=\"");
                this.print(id);
                this.print("\">");
            }
            String name = field.getLocalName();
            this.print(name);
            if (id != null) {
                this.print("</a>");
            }
            comma = ", ";
        }
        this.println();
        this.indent();
        this.println("</TD>");
        this.printer.endRow();
        this.printer.endTable();
    }

    private void printClassDiagram(UmlClass umlClass) throws IOException {
        File file = this.linkManager.getUmlClassImageFile(umlClass);
        ClassDiagram diagram = new ClassDiagram(umlClass);
        BufferedImage image = diagram.getImage();
        ImageIO.write((RenderedImage)image, "png", file);
        this.uploadFile("image/png", file);
        String src = "images/" + file.getName();
        this.printer.printFigure(src, null);
    }

    private void printNamedInstances(UmlClass umlClass) {
        List<NamedIndividual> list = umlClass.listInstances(false);
        if (list.isEmpty()) {
            return;
        }
        Collections.sort(list, new Comparator<NamedIndividual>(){

            @Override
            public int compare(NamedIndividual a, NamedIndividual b) {
                return a.getLocalName() != null && b.getLocalName() != null ? a.getLocalName().compareTo(b.getLocalName()) : 0;
            }
        });
        this.printer.beginDiv("list-heading");
        this.print("Known Instances:");
        this.printer.endDiv();
        this.printer.beginTable("propertiesTable");
        this.printer.beginRow();
        this.println("<TH>Simple Name</TH><TH> Description / URI</TH>");
        this.printer.endRow();
        for (NamedIndividual n : list) {
            String comment = n.getComment();
            this.printer.beginRow();
            this.print("<TD>");
            this.print(n.getLocalName());
            this.print("</TD>");
            this.print("<TD>");
            if (comment != null) {
                this.print("<P>");
                this.print(comment);
                this.print("</P>");
            }
            this.print("<code>");
            this.print(n.getUri());
            this.print("</code>");
            this.print("</TD>");
            this.printer.endRow();
        }
        this.printer.endTable();
    }

    private void printPropertyTable(UmlClass umlClass) {
        RdfType type = umlClass.getType();
        if (!type.canAsFrame()) {
            return;
        }
        Frame frame = type.asFrame();
        List<Field> list = frame.getDeclaredFields();
        if (list.isEmpty()) {
            return;
        }
        String tableId = umlClass.getLocalName() + ".properties";
        String captionText = this.format("{0} Properties", umlClass.getLocalName());
        Caption caption = new Caption(CaptionType.Table, captionText, tableId, null);
        this.printer.assignNumber(caption);
        String title = this.format("Properties of class {0}", umlClass.getLocalName());
        this.printer.beginTable("propertiesTable");
        this.printer.beginRow();
        this.println("<TH colspan=\"3\">" + title + "</TH>");
        this.printer.endRow();
        TypeManager typeManager = this.umlManager.getTypeManager();
        for (Field field : list) {
            RdfType fieldType = field.getRdfType();
            String link = typeManager.isStandard(fieldType.getNamespace()) ? fieldType.getLocalName() : this.linkManager.getTypeLink(fieldType);
            String propertyId = this.linkManager.getPropertyId(umlClass, (Property)field.getProperty());
            this.printer.beginRow();
            this.indent();
            this.print("<TD>");
            this.printer.beginDiv("propertyName", propertyId);
            this.indent();
            this.print(field.getLocalName());
            this.printer.endDiv();
            this.printer.beginDiv("description");
            this.indent();
            this.print(field.getComment());
            this.printer.endDiv();
            this.print("</TD>");
            this.printer.printTD("propertyType", link);
            this.printer.printTD("multiplicity", field.getMultiplicity());
            this.printer.endRow();
        }
        this.printer.endTable();
    }

    private int dirCount(String relativePath) {
        int count = 0;
        int index = -1;
        while ((index = relativePath.indexOf(47, index + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    static class UmlClassComparator
    implements Comparator<UmlClass> {
        UmlClassComparator() {
        }

        @Override
        public int compare(UmlClass a, UmlClass b) {
            String aName = a.getLocalName();
            String bName = b.getLocalName();
            return aName.compareTo(bName);
        }
    }

    static class DatatypeComparator
    implements Comparator<Datatype> {
        DatatypeComparator() {
        }

        @Override
        public int compare(Datatype a, Datatype b) {
            return a.getLocalName().compareTo(b.getLocalName());
        }
    }
}

