/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.uml.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import org.semantictools.frame.model.Encapsulation;
import org.semantictools.frame.model.Field;
import org.semantictools.graphics.Arc;
import org.semantictools.graphics.ArcEnd;
import org.semantictools.graphics.GraphicsUtil;
import org.semantictools.graphics.HorizontalPanel;
import org.semantictools.graphics.Label;
import org.semantictools.graphics.Rect;
import org.semantictools.graphics.Style;
import org.semantictools.graphics.VerticalPanel;
import org.semantictools.graphics.Widget;
import org.semantictools.graphics.WidgetTransformer;
import org.semantictools.uml.graphics.ClassWidget;
import org.semantictools.uml.model.UmlAssociation;
import org.semantictools.uml.model.UmlAssociationEnd;
import org.semantictools.uml.model.UmlClass;

public class ClassDiagram {
    private Style classStyle;
    private Style arcStyle;
    private Style classNameStyle;
    private Style fieldStyle;
    private Style classBodyStyle;
    private Style imageStyle;
    private UmlClass umlClass;
    private ClassWidget classWidget;
    private VerticalPanel childrenPanel;
    private VerticalPanel parentPanel;
    private HorizontalPanel superTypePanel;
    private HorizontalPanel subtypePanel;
    private BufferedImage image;
    private int width;
    private int height;
    private int dx;
    private int dy;
    private int maxChildArcWidth;
    private int maxParentArcWidth;
    private int generalizationArrowLength = 50;

    public ClassDiagram(UmlClass type) {
        this.umlClass = type;
        this.createStyles();
        Label classLabel = new Label(type.getLocalName(), this.classNameStyle);
        this.classWidget = new ClassWidget(classLabel, this.classStyle);
        this.childrenPanel = new VerticalPanel();
        this.dx = this.imageStyle.getMarginLeft();
        this.dy = this.imageStyle.getMarginTop();
        this.addFields();
        this.addChildren();
        this.addParents();
        this.addSupertypes();
        this.addSubtypes();
        this.layout();
        this.image = new BufferedImage(this.width + 1, this.height + 1, 2);
        Graphics2D g = this.image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paint(g);
    }

    private void addFields() {
        List<Field> list = this.umlClass.getFieldList();
        for (Field field : list) {
            String name = field.getLocalName();
            String type = field.getType().getLocalName();
            String multiplicity = field.getMultiplicity();
            String text = name + ": " + type + "[" + multiplicity + "]";
            Label label = new Label(text, this.fieldStyle);
            this.classWidget.addField(label);
        }
        if (!list.isEmpty()) {
            this.classWidget.getBody().setStyle(this.classBodyStyle);
        }
    }

    private void addSubtypes() {
        List<UmlClass> list = this.umlClass.getSubtypeList();
        if (list.isEmpty()) {
            return;
        }
        this.subtypePanel = new HorizontalPanel();
        for (UmlClass subtype : list) {
            Label label = new Label(subtype.getLocalName(), this.classNameStyle);
            ClassWidget subWidget = new ClassWidget(label, this.classStyle);
            this.subtypePanel.add(subWidget);
            ArcEnd selfEnd = new ArcEnd(null, null, this.arcStyle);
            ArcEnd otherEnd = new ArcEnd(null, null, this.arcStyle);
            selfEnd.setShape(ArcEnd.TRIANGLE);
            new Arc(selfEnd, otherEnd);
            this.classWidget.addBottomArc(selfEnd);
            subWidget.addTopArc(otherEnd);
        }
    }

    private void addSupertypes() {
        List<UmlClass> list = this.umlClass.getSupertypeList();
        if (list.isEmpty()) {
            return;
        }
        this.superTypePanel = new HorizontalPanel();
        for (UmlClass supertype : list) {
            Label label = new Label(supertype.getLocalName(), this.classNameStyle);
            ClassWidget superWidget = new ClassWidget(label, this.classStyle);
            this.superTypePanel.add(superWidget);
            ArcEnd selfEnd = new ArcEnd(null, null, this.arcStyle);
            ArcEnd otherEnd = new ArcEnd(null, null, this.arcStyle);
            otherEnd.setShape(ArcEnd.TRIANGLE);
            new Arc(selfEnd, otherEnd);
            this.classWidget.addTopArc(selfEnd);
            superWidget.addBottomArc(otherEnd);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void layout() {
        this.performInitialLayout();
        this.performFinalLayout();
        this.setEndWidths();
        this.performFinalLayout();
        this.setDimensions();
    }

    private void setDimensions() {
        this.width = 0;
        this.height = 0;
        this.updateDimensions(this.classWidget);
        this.updateDimensions(this.childrenPanel);
        this.updateDimensions(this.subtypePanel);
        this.updateDimensions(this.parentPanel);
        this.updateDimensions(this.superTypePanel);
        this.width = this.imageStyle.getMarginLeft() + this.width + this.imageStyle.getMarginRight() + 1;
        this.height = this.imageStyle.getMarginTop() + this.height + this.imageStyle.getMarginBottom() + 1;
    }

    private void updateDimensions(Widget widget) {
        if (widget == null) {
            return;
        }
        this.width = Math.max(this.width, widget.getBounds().getRight());
        this.height = Math.max(this.height, widget.getBounds().getBottom());
    }

    private void setEndWidths() {
        this.classWidget.setEndWidths(this.classWidget.listLeftArcs());
        this.classWidget.setEndWidths(this.classWidget.listRightArcs());
    }

    private void performFinalLayout() {
        this.dx = 0;
        this.dy = 0;
        this.maxChildArcWidth = 0;
        this.maxParentArcWidth = 0;
        this.placeClassWidget();
        this.placeChildrenPanel();
        this.placeParentPanel();
        this.placeSuperTypePanel();
        this.placeSubtypePanel();
        Bounds bounds = new Bounds();
        bounds.apply(this.classWidget);
        bounds.apply(this.superTypePanel);
        bounds.apply(this.childrenPanel);
        bounds.apply(this.parentPanel);
        bounds.apply(this.subtypePanel);
        this.width = this.imageStyle.getMarginLeft() + bounds.right - bounds.left + this.imageStyle.getMarginRight() + 1;
        this.height = this.imageStyle.getMarginTop() + bounds.bottom - bounds.top + this.imageStyle.getMarginBottom() + 1;
        if (bounds.left < 0) {
            this.dx = -bounds.left;
        }
        if (bounds.top < 0) {
            this.dy = -bounds.top;
        }
        this.dx += this.imageStyle.getMarginLeft();
        this.dy += this.imageStyle.getMarginTop();
        this.maxChildArcWidth = 0;
        this.maxParentArcWidth = 0;
        this.placeClassWidget();
        this.placeChildrenPanel();
        this.placeParentPanel();
        this.placeSuperTypePanel();
        this.placeSubtypePanel();
    }

    private int getMaxChildArcWidth() {
        if (this.maxChildArcWidth == 0) {
            int leftWidth = 0;
            int rightWidth = 0;
            List<ArcEnd> childList = this.classWidget.listRightArcs();
            if (childList != null) {
                for (ArcEnd end : childList) {
                    Arc arc = end.getArc();
                    int a = arc.getEnds()[0].getBounds().getWidth();
                    leftWidth = Math.max(leftWidth, a);
                    int b = arc.getEnds()[1].getBounds().getWidth();
                    rightWidth = Math.max(rightWidth, b);
                }
                this.maxChildArcWidth = leftWidth + rightWidth;
            }
        }
        return this.maxChildArcWidth;
    }

    private int getMaxParentArcWidth() {
        if (this.maxParentArcWidth == 0) {
            int leftWidth = 0;
            int rightWidth = 0;
            List<ArcEnd> parentList = this.classWidget.listLeftArcs();
            if (parentList != null) {
                for (ArcEnd end : parentList) {
                    Arc arc = end.getArc();
                    int a = arc.getEnds()[0].getBounds().getWidth();
                    leftWidth = Math.max(leftWidth, a);
                    int b = arc.getEnds()[1].getBounds().getWidth();
                    rightWidth = Math.max(rightWidth, b);
                }
                this.maxParentArcWidth = leftWidth + rightWidth;
            }
        }
        return this.maxParentArcWidth;
    }

    private void performInitialLayout() {
        WidgetTransformer t;
        int marginLeft = this.imageStyle.getMarginLeft();
        int marginTop = this.imageStyle.getMarginTop();
        int marginRight = this.imageStyle.getMarginRight();
        int marginBottom = this.imageStyle.getMarginBottom();
        int dy = marginTop;
        this.classWidget.setPosition(marginLeft, marginTop);
        this.classWidget.layout();
        if (this.superTypePanel != null) {
            this.superTypePanel.setPosition(marginLeft, marginTop);
            this.superTypePanel.layout();
            t = new WidgetTransformer(this.superTypePanel);
            dy = t.getBottom() + this.generalizationArrowLength;
            this.classWidget.setTop(dy);
        }
        if (this.parentPanel != null) {
            this.parentPanel.setPosition(marginLeft, dy);
            this.parentPanel.layout();
            this.classWidget.setLeft(600);
            this.height = Math.max(this.height, this.parentPanel.getBottom());
        }
        this.width = this.classWidget.getRight();
        this.height = this.classWidget.getBottom();
        if (this.childrenPanel != null) {
            t = new WidgetTransformer(this.classWidget);
            this.childrenPanel.setPosition(t.getRight() + 100, marginTop);
            this.childrenPanel.layout();
            t.set(this.childrenPanel);
            this.width = t.getWidth();
            this.height = Math.max(this.height, t.getBottom());
        }
        if (this.subtypePanel != null) {
            int top = this.height + this.generalizationArrowLength;
            int left = this.classWidget.getLeft();
            this.subtypePanel.setPosition(left, top);
            this.subtypePanel.layout();
            this.height = this.subtypePanel.getBottom();
        }
        this.width += marginLeft + marginRight;
        this.height += marginTop + marginBottom;
    }

    private void paint(Graphics2D g) {
        GraphicsUtil.paint(g, this.classWidget);
        GraphicsUtil.paint(g, this.superTypePanel);
        GraphicsUtil.paint(g, this.childrenPanel);
        GraphicsUtil.paint(g, this.parentPanel);
        GraphicsUtil.paint(g, this.subtypePanel);
        this.classWidget.paintArcs(g, this.classWidget.listRightArcs());
        this.classWidget.paintArcs(g, this.classWidget.listTopArcs());
        this.classWidget.paintArcs(g, this.classWidget.listLeftArcs());
        this.classWidget.paintArcs(g, this.classWidget.listBottomArcs());
    }

    private void addParents() {
        List<UmlAssociation> list = this.umlClass.getParentList();
        if (list.isEmpty()) {
            return;
        }
        this.parentPanel = new VerticalPanel();
        UmlClass priorParent = null;
        ClassWidget priorWidget = null;
        for (UmlAssociation a : list) {
            ClassWidget otherWidget;
            UmlClass peer = a.getOtherEnd(this.umlClass).getParticipant();
            Label label = new Label(peer.getLocalName(), this.classNameStyle);
            ClassWidget classWidget = otherWidget = peer == priorParent ? priorWidget : new ClassWidget(label, this.classStyle);
            if (otherWidget != priorWidget) {
                this.parentPanel.add(otherWidget);
            }
            priorParent = peer;
            priorWidget = otherWidget;
            UmlAssociationEnd myEnd = a.getSelfEnd(this.umlClass);
            UmlAssociationEnd parentEnd = a.getOtherEnd(this.umlClass);
            ArcEnd selfEnd = new ArcEnd(myEnd.getLocalName(), myEnd.getMultiplicity(), this.arcStyle);
            this.setEndShape(selfEnd, myEnd.getEncapsulation());
            ArcEnd otherEnd = new ArcEnd(parentEnd.getLocalName(), parentEnd.getMultiplicity(), this.arcStyle);
            this.setEndShape(otherEnd, parentEnd.getEncapsulation());
            new Arc(selfEnd, otherEnd);
            this.classWidget.addLeftArc(selfEnd);
            otherWidget.addRightArc(otherEnd);
        }
    }

    private void addChildren() {
        List<UmlAssociation> list = this.umlClass.getChildren();
        if (list.isEmpty()) {
            return;
        }
        this.childrenPanel = new VerticalPanel();
        UmlClass priorClass = null;
        ClassWidget priorWidget = null;
        for (UmlAssociation a : list) {
            ClassWidget otherWidget;
            UmlAssociationEnd classEnd = a.getSelfEnd(this.umlClass);
            UmlAssociationEnd fieldEnd = a.getOtherEnd(this.umlClass);
            UmlClass fieldClass = a.getOtherEnd(this.umlClass).getParticipant();
            UmlClass peer = fieldEnd.getParticipant();
            Label label = new Label(peer.getLocalName(), this.classNameStyle);
            ClassWidget classWidget = otherWidget = priorClass == fieldClass ? priorWidget : new ClassWidget(label, this.classStyle);
            if (otherWidget != priorWidget) {
                this.childrenPanel.add(otherWidget);
            }
            priorClass = fieldClass;
            priorWidget = otherWidget;
            ArcEnd selfEnd = new ArcEnd(classEnd.getLocalName(), classEnd.getMultiplicity(), this.arcStyle);
            this.setEndShape(selfEnd, classEnd.getEncapsulation());
            ArcEnd otherEnd = new ArcEnd(fieldEnd.getLocalName(), fieldEnd.getMultiplicity(), this.arcStyle);
            this.setEndShape(otherEnd, fieldEnd.getEncapsulation());
            new Arc(selfEnd, otherEnd);
            this.classWidget.addRightArc(selfEnd);
            otherWidget.addLeftArc(otherEnd);
        }
    }

    private void setEndShape(ArcEnd end, Encapsulation e) {
        switch (e) {
            case AGGREGATION: {
                end.setShape(ArcEnd.DIAMOND);
                break;
            }
            case COMPOSITION: {
                end.setShape(ArcEnd.DIAMOND);
                end.setFilled(true);
            }
        }
    }

    private void createStyles() {
        if (this.imageStyle == null) {
            this.imageStyle = new Style();
            this.imageStyle.setMarginTop(5);
            this.imageStyle.setMarginBottom(5);
            this.imageStyle.setMarginLeft(5);
            this.imageStyle.setMarginRight(5);
        }
        if (this.classStyle == null) {
            this.classStyle = new Style();
            this.classStyle.setBgColor(new Color(1.0f, 1.0f, 0.7226562f));
            this.classStyle.setBorderColor(new Color(0.5f, 0.0f, 0.0f));
            this.classStyle.setMarginTop(15);
            this.classStyle.setMarginBottom(15);
            this.classStyle.setMarginLeft(15);
            this.classStyle.setMarginRight(15);
        }
        if (this.classBodyStyle == null) {
            this.classBodyStyle = new Style();
            this.classBodyStyle.setPadBottom(3);
        }
        if (this.fieldStyle == null) {
            this.fieldStyle = new Style();
            this.fieldStyle.setFont(new Font("Arial", 0, 11));
            this.fieldStyle.setPadBottom(1);
            this.fieldStyle.setPadTop(1);
            this.fieldStyle.setPadLeft(5);
            this.fieldStyle.setPadRight(5);
        }
        if (this.arcStyle == null) {
            this.arcStyle = new Style();
            this.arcStyle.setBorderColor(new Color(0.5f, 0.0f, 0.0f));
            this.arcStyle.setColor(Color.black);
            this.arcStyle.setFont(new Font("Arial", 0, 11));
            this.arcStyle.setPadBottom(3);
            this.arcStyle.setPadTop(3);
            this.arcStyle.setPadLeft(5);
            this.arcStyle.setPadRight(5);
            this.arcStyle.setMarginTop(10);
            this.arcStyle.setMarginBottom(10);
        }
        if (this.classNameStyle == null) {
            this.classNameStyle = new Style();
            this.classNameStyle.setColor(Color.black);
            this.classNameStyle.setFont(new Font("Arial", 1, 12));
            this.classNameStyle.setPadTop(3);
            this.classNameStyle.setPadBottom(3);
            this.classNameStyle.setPadLeft(5);
            this.classNameStyle.setPadRight(5);
        }
        BufferedImage image = new BufferedImage(10, 10, 2);
        Graphics2D g = image.createGraphics();
        this.setMetrics(this.arcStyle, g);
        this.setMetrics(this.classNameStyle, g);
        this.setMetrics(this.fieldStyle, g);
    }

    private void setMetrics(Style style, Graphics2D g) {
        if (style.getMetrics() != null || style.getFont() == null) {
            return;
        }
        Font font = style.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        style.setMetrics(metrics);
    }

    private void placeClassWidget() {
        this.classWidget.setPosition(this.dx, this.dy);
    }

    private void placeParentPanel() {
        if (this.parentPanel == null) {
            return;
        }
        int middle = this.classWidget.getTop() + this.classWidget.getHeight() / 2;
        int left = this.classWidget.getLeft() - this.getMaxParentArcWidth() - this.parentPanel.getWidth();
        int top = middle - this.parentPanel.getHeight() / 2;
        this.parentPanel.setPosition(left, top);
    }

    private void placeChildrenPanel() {
        if (this.childrenPanel == null) {
            return;
        }
        int dx = this.getMaxChildArcWidth();
        int middle = this.classWidget.getTop() + this.classWidget.getHeight() / 2;
        int left = this.classWidget.getRight() + dx;
        int top = middle - this.childrenPanel.getHeight() / 2;
        this.childrenPanel.setPosition(left, top);
    }

    private void placeSuperTypePanel() {
        if (this.superTypePanel == null) {
            return;
        }
        int center = this.classWidget.getLeft() + this.classWidget.getWidth() / 2;
        int left = center - this.superTypePanel.getWidth() / 2;
        int top = this.classWidget.getTop() - this.generalizationArrowLength - this.superTypePanel.getHeight();
        this.superTypePanel.setPosition(left, top);
    }

    private void placeSubtypePanel() {
        if (this.subtypePanel == null) {
            return;
        }
        int center = this.classWidget.getLeft() + this.classWidget.getWidth() / 2;
        int left = center - this.subtypePanel.getWidth() / 2;
        int top = this.classWidget.getBottom() + this.generalizationArrowLength;
        this.subtypePanel.setPosition(left, top);
    }

    static class Bounds {
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;

        Bounds() {
        }

        void apply(Widget widget) {
            if (widget != null) {
                Rect r = widget.getBounds();
                this.top = Math.min(this.top, r.getTop());
                this.left = Math.min(this.left, r.getLeft());
                this.right = Math.max(this.right, r.getRight());
                this.bottom = Math.max(this.bottom, r.getBottom());
            }
        }
    }
}

