/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.uml.model;

import org.semantictools.uml.model.UmlAssociationEnd;
import org.semantictools.uml.model.UmlClass;

public class UmlAssociation {
    private UmlAssociationEnd[] ends;

    public UmlAssociation(UmlAssociationEnd end1, UmlAssociationEnd end2) {
        this.ends = new UmlAssociationEnd[]{end1, end2};
    }

    public UmlAssociationEnd[] getEnds() {
        return this.ends;
    }

    public UmlAssociationEnd getSelfEnd(UmlClass endpoint) {
        if (this.ends[0].getParticipant().getURI().equals(endpoint.getURI())) {
            return this.ends[0];
        }
        if (this.ends[1].getParticipant().getURI().equals(endpoint.getURI())) {
            return this.ends[1];
        }
        throw new IllegalArgumentException(endpoint.getURI() + " is not a valid endpoint");
    }

    public UmlAssociationEnd getOtherEnd(UmlClass endpoint) {
        if (this.ends[0].getParticipant().getURI().equals(endpoint.getURI())) {
            return this.ends[1];
        }
        if (this.ends[1].getParticipant().getURI().equals(endpoint.getURI())) {
            return this.ends[0];
        }
        throw new IllegalArgumentException(endpoint.getURI() + " is not a valid endpoint");
    }

    public boolean equals(UmlAssociation other) {
        return this.ends[0].equals(other.ends[0]) && this.ends[1].equals(other.ends[1]) || this.ends[0].equals(other.ends[1]) && this.ends[1].equals(other.ends[0]);
    }

    public String toString() {
        return "Association[" + this.ends[0] + ", " + this.ends[1] + "]";
    }
}

