/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.uml.model;

import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.NamedIndividual;
import org.semantictools.frame.model.RdfType;
import org.semantictools.uml.model.UmlAssociation;
import org.semantictools.uml.model.UmlAssociationEnd;
import org.semantictools.uml.model.UmlManager;
import org.semantictools.uml.model.UmlProperty;

public class UmlClass {
    private RdfType type;
    private String stereotype;
    private UmlManager manager;
    private List<Field> fieldList = new ArrayList<Field>();
    private List<UmlClass> supertypeList = null;
    private List<UmlClass> subtypeList = null;
    private List<UmlAssociation> children = new ArrayList<UmlAssociation>();
    private List<UmlAssociation> parentList = new ArrayList<UmlAssociation>();

    public UmlClass(RdfType type, UmlManager manager) {
        this.type = type;
        this.manager = manager;
    }

    public String getDescription() {
        String comment = this.type.canAsFrame() ? this.type.asFrame().getComment() : null;
        return comment;
    }

    public List<NamedIndividual> listInstances(boolean direct) {
        return this.type.asFrame().listInstances(direct);
    }

    public void add(Field field) {
        this.fieldList.add(field);
    }

    public String getURI() {
        return this.type.getUri();
    }

    public String getLocalName() {
        return this.type.getLocalName();
    }

    public RdfType getType() {
        return this.type;
    }

    public String getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(String stereotype) {
        this.stereotype = stereotype;
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    public List<UmlClass> listAllSupertypes() {
        ArrayList<UmlClass> list = new ArrayList<UmlClass>();
        if (this.type.canAsFrame()) {
            List<Frame> frameList = this.type.asFrame().listAllSupertypes();
            for (Frame frame : frameList) {
                String uri = frame.getUri();
                if (uri.startsWith(RDF.getURI()) || uri.startsWith(RDFS.getURI())) continue;
                UmlClass superClass = this.manager.getUmlClassByURI(frame.getUri());
                if (superClass == null) {
                    superClass = new UmlClass(frame, this.manager);
                }
                list.add(superClass);
            }
        }
        return list;
    }

    public List<UmlClass> getSupertypeList() {
        if (this.supertypeList == null) {
            this.supertypeList = new ArrayList<UmlClass>();
            if (this.type.canAsFrame()) {
                List<Frame> list = this.type.asFrame().getSupertypeList();
                for (Frame frame : list) {
                    String uri = frame.getUri();
                    if (uri.startsWith(RDF.getURI()) || uri.startsWith(RDFS.getURI())) continue;
                    UmlClass superClass = this.manager.getUmlClassByURI(frame.getUri());
                    if (superClass == null) {
                        superClass = new UmlClass(frame, this.manager);
                    }
                    this.supertypeList.add(superClass);
                }
            }
        }
        return this.supertypeList;
    }

    public List<UmlClass> getSubtypeList() {
        if (this.subtypeList == null) {
            this.subtypeList = new ArrayList<UmlClass>();
            if (this.type.canAsFrame()) {
                List<Frame> list = this.type.asFrame().getSubtypeList();
                for (Frame frame : list) {
                    String uri = frame.getUri();
                    if (uri.startsWith(RDF.getURI()) || uri.startsWith(RDFS.getURI())) continue;
                    UmlClass subclass = this.manager.getUmlClassByURI(frame.getUri());
                    if (subclass == null) {
                        throw new RuntimeException("UmlClass not found: " + frame.getUri());
                    }
                    this.subtypeList.add(subclass);
                }
                List<Datatype> datatypeList = this.type.asFrame().getSubdatatypeList();
                for (Datatype type : datatypeList) {
                    String uri = type.getUri();
                    UmlClass subclass = this.manager.getUmlClassByURI(uri);
                    if (subclass == null) {
                        subclass = new UmlClass(type, this.manager);
                        this.manager.add(subclass);
                    }
                    this.subtypeList.add(subclass);
                }
            }
        }
        return this.subtypeList;
    }

    public void setSubtypeList(List<UmlClass> subtypeList) {
        this.subtypeList = subtypeList;
    }

    public List<UmlAssociation> getChildren() {
        return this.children;
    }

    public void addChild(UmlAssociation child) {
        this.addUnique(this.children, child);
    }

    public void addParent(UmlAssociation parent) {
        this.addUnique(this.parentList, parent);
    }

    private void addUnique(List<UmlAssociation> list, UmlAssociation element) {
        for (UmlAssociation a : list) {
            if (!a.equals(element)) continue;
            return;
        }
        list.add(element);
    }

    public List<UmlAssociation> getParentList() {
        return this.parentList;
    }

    public List<UmlProperty> listAllDeclaredProperties() {
        ArrayList<UmlProperty> list = new ArrayList<UmlProperty>();
        for (Field field : this.fieldList) {
            list.add(this.createUmlProperty(field));
        }
        for (UmlAssociation a : this.children) {
            UmlAssociationEnd end = a.getOtherEnd(this);
            Field field = end.getField();
            if (field == null) continue;
            list.add(this.createUmlProperty(field));
        }
        return list;
    }

    private UmlProperty createUmlProperty(Field field) {
        UmlProperty p = new UmlProperty();
        p.setLocalName(field.getLocalName());
        p.setDescription(field.getComment());
        p.setMultiplicity(field.getMultiplicity());
        p.setType(field.getType().getLocalName());
        p.setField(field);
        return p;
    }

    public String toString() {
        return this.type.getLocalName();
    }
}

