/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.uml.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Encapsulation;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.InverseProperty;
import org.semantictools.frame.model.RdfType;
import org.semantictools.uml.model.UmlAssociation;
import org.semantictools.uml.model.UmlAssociationEnd;
import org.semantictools.uml.model.UmlClass;

public class UmlManager {
    private TypeManager typeManager;
    private Map<String, UmlClass> uri2Class = new HashMap<String, UmlClass>();

    public UmlManager(TypeManager typeManager) {
        this.typeManager = typeManager;
        this.init();
    }

    public void add(UmlClass umlClass) {
        this.uri2Class.put(umlClass.getURI(), umlClass);
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public UmlClass getUmlClassByURI(String uri) {
        return this.uri2Class.get(uri);
    }

    public Collection<UmlClass> listUmlClasses() {
        return this.uri2Class.values();
    }

    private void init() {
        this.buildClasses();
        this.buildAssociations();
        this.sortAssociations();
    }

    private void sortAssociations() {
        for (UmlClass umlClass : this.uri2Class.values()) {
            UmlAssociationComparator comparator = new UmlAssociationComparator(umlClass);
            this.sort(umlClass.getChildren(), comparator);
        }
    }

    private void sort(List<UmlAssociation> list, Comparator<UmlAssociation> comparator) {
        if (list.isEmpty()) {
            return;
        }
        Collections.sort(list, comparator);
    }

    private void buildClasses() {
        for (Frame frame : this.typeManager.listFrames()) {
            this.buildClass(frame);
        }
        for (Frame frame : this.typeManager.listListTypes()) {
            this.buildClass(frame);
        }
    }

    private void buildClass(Frame frame) {
        String uri = frame.getUri();
        UmlClass umlClass = new UmlClass(frame, this);
        this.uri2Class.put(uri, umlClass);
        for (Field field : frame.getDeclaredFields()) {
            RdfType fieldType = field.getRdfType();
            if (!fieldType.canAsDatatype()) continue;
            umlClass.add(field);
        }
    }

    private void buildAssociations() {
        for (Frame frame : this.typeManager.listFrames()) {
            this.buildAssociations(frame);
        }
    }

    private void buildAssociations(Frame frame) {
        UmlClass umlClass = this.getUmlClassByURI(frame.getUri());
        this.addChildren(umlClass, frame);
    }

    private void addChildren(UmlClass umlClass, Frame frame) {
        for (Field field : frame.getDeclaredFields()) {
            UmlAssociation assoc;
            UmlAssociationEnd end1;
            UmlAssociationEnd end0;
            RdfType fieldType = field.getRdfType();
            Field inverseField = field.getInverseField();
            UmlClass otherClass = null;
            if (fieldType.canAsFrame()) {
                otherClass = this.getUmlClassByURI(fieldType.getUri());
            } else if (fieldType.canAsListType()) {
                otherClass = this.getUmlClassByURI(fieldType.asListType().getElementType().getUri());
            }
            if (otherClass == null) continue;
            InverseProperty inverse = field.getInverseProperty();
            Encapsulation inverseEncapsulation = inverseField == null ? inverse.getEncapsulation() : inverseField.getEncapsulation();
            Encapsulation encapsulation = field.getEncapsulation();
            if (encapsulation == Encapsulation.NONE && inverseEncapsulation != Encapsulation.NONE) {
                end0 = new UmlAssociationEnd(umlClass);
                end0.setMultiplicity(inverse.getMultiplicity());
                this.defineEnd(end0, inverseField, encapsulation);
                end1 = new UmlAssociationEnd(otherClass);
                this.defineEnd(end1, field, inverseEncapsulation);
                assoc = new UmlAssociation(end0, end1);
                otherClass.addChild(assoc);
                umlClass.addParent(assoc);
                continue;
            }
            end0 = new UmlAssociationEnd(umlClass);
            end1 = new UmlAssociationEnd(otherClass);
            this.defineEnd(end0, inverseField, encapsulation);
            this.defineEnd(end1, field, inverseEncapsulation);
            assoc = new UmlAssociation(end0, end1);
            umlClass.addChild(assoc);
            otherClass.addParent(assoc);
        }
    }

    private void defineEnd(UmlAssociationEnd end, Field field, Encapsulation encapsulation) {
        end.setEncapsulation(encapsulation);
        if (field == null) {
            return;
        }
        end.setField(field);
        end.setLocalName(field.getLocalName());
        end.setMultiplicity(field.getMultiplicity());
    }

    static class UmlAssociationComparator
    implements Comparator<UmlAssociation> {
        private UmlClass umlClass;

        public UmlAssociationComparator(UmlClass umlClass) {
            this.umlClass = umlClass;
        }

        @Override
        public int compare(UmlAssociation a, UmlAssociation b) {
            String aName = a.getOtherEnd(this.umlClass).getParticipant().getLocalName();
            String bName = b.getOtherEnd(this.umlClass).getParticipant().getLocalName();
            return aName.compareTo(bName);
        }
    }
}

