/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.web.upload;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.frame.api.LinkManager;
import org.semantictools.web.upload.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppspotUploadClient {
    private static final Logger logger = LoggerFactory.getLogger(AppspotUploadClient.class);
    private static final String SERVLET_URL = "http://semantic-tools.appspot.com/admin/upload.do";
    private static final String CONTENT_TYPE = "contentType";
    private static final String PATH = "path";
    private static final String VERSION = "version";
    private static final String FILE_UPLOAD = "fileUpload";
    private String servletURL = "http://semantic-tools.appspot.com/admin/upload.do";
    private String version;

    public void uploadAll(File baseDir) throws IOException {
        LinkManager linkManager = new LinkManager(baseDir);
        this.uploadFiles(linkManager, baseDir);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEndpointURL() {
        return this.servletURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.servletURL = endpointURL;
    }

    private void uploadFiles(LinkManager linkManager, File dir) throws IOException {
        File[] array;
        for (File file : array = dir.listFiles()) {
            String suffix;
            String contentType;
            if (file.isDirectory()) {
                this.uploadFiles(linkManager, file);
                continue;
            }
            String fileName = file.getName();
            int dot = fileName.lastIndexOf(46);
            if (dot < 0 || (contentType = this.getContentType(suffix = fileName.substring(dot + 1))) == null) continue;
            String path = linkManager.relativize(file);
            this.upload(contentType, path, file);
        }
    }

    private String getContentType(String suffix) {
        return "png".equals(suffix) ? "image/png" : ("html".equals(suffix) ? "text/html" : ("css".equals(suffix) ? "text/css" : ("json".equals(suffix) ? "application/json" : null)));
    }

    public void upload(File baseDir, ContextProperties contextProperties) throws IOException {
        String mediaType = contextProperties.getMediaType();
        String path = "mediatype/" + mediaType.replace('.', '/') + "/";
        this.upload(path, baseDir, contextProperties);
    }

    private void upload(String path, File dir, ContextProperties contextProperties) throws IOException {
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            String fileName = file.getName();
            if (file.isDirectory()) {
                this.upload(path + fileName + "/", file, contextProperties);
                continue;
            }
            int dot = fileName.lastIndexOf(46);
            String uri = path + fileName;
            if (dot < 0) {
                logger.debug("Skipping file because it has no suffix: " + uri);
                continue;
            }
            String suffix = fileName.substring(dot + 1);
            String mediaType = MimeTypes.getMediaType(suffix);
            if (mediaType == null) {
                logger.debug("Skipping file because the media type is not known: " + uri);
                continue;
            }
            this.upload(mediaType, uri, file);
        }
    }

    public String upload(String contentType, String path, File file) throws IOException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.servletURL);
        post.setHeader("CONTENT-TYPE", "multipart/form-data; boundary=xxxBOUNDARYxxx");
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, "xxxBOUNDARYxxx", Charset.forName("UTF-8"));
        FileBody body = new FileBody(file, contentType);
        entity.addPart(CONTENT_TYPE, (ContentBody)new StringBody(contentType));
        entity.addPart(PATH, (ContentBody)new StringBody(path));
        if (this.version != null) {
            entity.addPart(VERSION, (ContentBody)new StringBody(this.version));
        }
        entity.addPart(FILE_UPLOAD, (ContentBody)body);
        post.setEntity((HttpEntity)entity);
        logger.debug("uploading... " + path);
        String response = EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)post).getEntity(), (String)"UTF-8");
        client.getConnectionManager().shutdown();
        return response;
    }
}

