/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.web.upload;

import java.util.ArrayList;
import java.util.List;

public class URLMapper {
    private List<RewriteRule> rewriteRules = new ArrayList<RewriteRule>();

    public void addRewriteRule(String fromURL, String toURL) {
        this.rewriteRules.add(new RewriteRule(fromURL, toURL));
    }

    public String rewrite(String url) {
        for (RewriteRule rule : this.rewriteRules) {
            if (!url.startsWith(rule.getFromURL())) continue;
            String suffix = url.substring(rule.getFromURL().length());
            String result = rule.getToURL() + suffix;
            return result;
        }
        return null;
    }

    private static class RewriteRule {
        private String fromURL;
        private String toURL;

        private RewriteRule(String fromURL, String toURL) {
            this.fromURL = fromURL;
            this.toURL = toURL;
        }

        public String getFromURL() {
            return this.fromURL;
        }

        public String getToURL() {
            return this.toURL;
        }
    }
}

