/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.vlog4j.parser;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.vlog4j.core.exceptions.PrefixDeclarationException;
import org.semanticweb.vlog4j.core.model.api.PrefixDeclarations;

public final class LocalPrefixDeclarations
implements PrefixDeclarations {
    Map<String, String> prefixes = new HashMap<String, String>();
    String baseUri;

    public String getBase() {
        if (this.baseUri == null) {
            this.baseUri = "";
        }
        return this.baseUri.toString();
    }

    public String getPrefix(String prefix) throws PrefixDeclarationException {
        if (!this.prefixes.containsKey(prefix)) {
            throw new PrefixDeclarationException("Prefix " + prefix + " cannot be resolved (not declared yet).");
        }
        return this.prefixes.get(prefix).toString();
    }

    public void setPrefix(String prefix, String uri) throws PrefixDeclarationException {
        if (this.prefixes.containsKey(prefix)) {
            throw new PrefixDeclarationException("Prefix " + prefix + " is already defined as <" + this.prefixes.get(prefix) + ">. It cannot be redefined to mean <" + uri + ">.");
        }
        this.prefixes.put(prefix, uri);
    }

    public void setBase(String baseUri) throws PrefixDeclarationException {
        if (this.baseUri != null) {
            throw new PrefixDeclarationException("Base is already defined as <" + this.baseUri + "> and cannot be re-defined as " + baseUri);
        }
        this.baseUri = baseUri;
    }

    public String resolvePrefixedName(String prefixedName) throws PrefixDeclarationException {
        int idx = prefixedName.indexOf(":") + 1;
        String prefix = prefixedName.substring(0, idx);
        String suffix = prefixedName.substring(idx);
        return this.getPrefix(prefix) + suffix;
    }

    public String absolutize(String iri) throws PrefixDeclarationException {
        URI relative = URI.create(iri);
        if (relative.isAbsolute()) {
            return iri;
        }
        return this.getBase() + iri;
    }
}

